/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommandService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoServiceCommand;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandServiceFactory;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.commands.DocumentFetchPublishedCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.commands.NuxeoCommandDelegate;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.BrowserAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.CMSItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.EditableWindowAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.DocumentFetchLiveCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.FileContentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.InternalPictureCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.PictureContentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.PutInTrashDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentGetMediaLibraryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentPublishSpaceNavigationCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.ExtendedDocInfosCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.ListCMSSubitemsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PartialNavigationCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PartialNavigationInvoker;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PublishInfosCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.AskSetOnLineCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.CancelWorkflowCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentAddComplexPropertyCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentDeleteCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentRemovePropertyCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentUpdatePropertiesCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindowHelper;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.SetOffLineCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.SetOnLineCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.ValidationPublishCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.identity.User;
import org.jboss.portal.server.ServerInvocation;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cache.services.ICacheService;
import org.osivia.portal.api.cache.services.IServiceInvoker;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.ecm.EcmCommand;
import org.osivia.portal.api.ecm.EcmViews;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.BinaryDelegation;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.portal.core.cms.CMSConfigurationItem;
import org.osivia.portal.core.cms.CMSEditableWindow;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSExtendedDocumentInfos;
import org.osivia.portal.core.cms.CMSHandlerProperties;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.NavigationItem;
import org.osivia.portal.core.cms.RegionInheritance;
import org.osivia.portal.core.page.PageProperties;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;
import org.osivia.portal.core.profils.IProfilManager;

public class CMSService
implements ICMSService {
    protected static final Log logger = LogFactory.getLog(CMSService.class);
    private final PortletContext portletCtx;
    private INuxeoCommandService nuxeoCommandService;
    private INuxeoService nuxeoService;
    private IProfilManager profilManager;
    private ICacheService serviceCache;
    private DefaultCMSCustomizer customizer;
    private IPortalUrlFactory urlFactory;

    public CMSService(PortletContext portletCtx) {
        this.portletCtx = portletCtx;
    }

    public DefaultCMSCustomizer getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(DefaultCMSCustomizer customizer) {
        this.customizer = customizer;
    }

    public CMSItem createItem(CMSServiceCtx cmsCtx, String path, String displayName, Document doc) throws CMSException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("displayName", displayName);
        properties.put("type", doc.getType());
        String domainId = doc.getString("ttc:domainID");
        String webId = doc.getString("ttc:webid");
        CMSItem cmsItem = new CMSItem(path, domainId, webId, properties, (Object)doc);
        CMSItemType type = (CMSItemType)this.customizer.getCMSItemTypes().get(doc.getType());
        cmsItem.setType(type);
        return cmsItem;
    }

    public CMSItem createNavigationItem(CMSServiceCtx cmsCtx, String path, String displayName, Document doc, String publishSpacePath) throws CMSException {
        CMSItem cmsItem = this.createItem(cmsCtx, path, displayName, doc);
        CMSItem publishSpaceItem = null;
        publishSpaceItem = publishSpacePath != null && !path.equals(publishSpacePath) ? this.getPortalNavigationItem(cmsCtx, publishSpacePath, publishSpacePath) : cmsItem;
        this.getCustomizer().getNavigationItemAdapter().adaptPublishSpaceNavigationItem(cmsItem, publishSpaceItem);
        return cmsItem;
    }

    public List<CMSItem> getChildren(CMSServiceCtx ctx, String path) throws CMSException {
        return new ArrayList<CMSItem>();
    }

    public IProfilManager getProfilManager() throws Exception {
        if (this.profilManager == null) {
            this.profilManager = (IProfilManager)this.portletCtx.getAttribute("ProfileService");
        }
        return this.profilManager;
    }

    public INuxeoService getNuxeoService() throws Exception {
        if (this.nuxeoService == null) {
            this.nuxeoService = (INuxeoService)this.portletCtx.getAttribute("NuxeoService");
        }
        return this.nuxeoService;
    }

    public ICacheService getCacheService() throws Exception {
        if (this.serviceCache == null) {
            this.serviceCache = (ICacheService)this.portletCtx.getAttribute("CacheService");
        }
        return this.serviceCache;
    }

    public INuxeoCommandService getNuxeoCommandService() throws Exception {
        if (this.nuxeoCommandService == null) {
            this.nuxeoCommandService = NuxeoCommandServiceFactory.getNuxeoCommandService((PortletContext)this.portletCtx);
        }
        return this.nuxeoCommandService;
    }

    public IPortalUrlFactory getPortalUrlFactory() {
        if (this.urlFactory == null) {
            this.urlFactory = (IPortalUrlFactory)this.portletCtx.getAttribute("UrlService");
        }
        return this.urlFactory;
    }

    public Object executeNuxeoCommand(CMSServiceCtx cmsCtx, INuxeoCommand command) throws Exception {
        NuxeoCommandContext commandCtx = null;
        if (cmsCtx.getServerInvocation() != null) {
            commandCtx = new NuxeoCommandContext(this.portletCtx, cmsCtx.getServerInvocation());
        } else if (cmsCtx.getServletRequest() != null) {
            commandCtx = new NuxeoCommandContext(this.portletCtx, cmsCtx.getServletRequest());
        }
        if (commandCtx == null) {
            commandCtx = new NuxeoCommandContext(this.portletCtx);
        }
        commandCtx.setAsyncCacheRefreshing(cmsCtx.isAsyncCacheRefreshing());
        if (cmsCtx.isForceReload()) {
            commandCtx.setForceReload(true);
        }
        String scope = cmsCtx.getScope();
        commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
        commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        if (scope != null && !"__nocache".equals(scope)) {
            if ("user_session".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_SESSION);
            } else if ("anonymous".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_ANONYMOUS);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            } else if ("superuser_context".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            } else if ("superuser_no_cache".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            } else {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_PROFIL);
                commandCtx.setAuthProfil(this.getProfilManager().getProfil(scope));
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            }
        }
        return this.getNuxeoCommandService().executeCommand(commandCtx, (INuxeoServiceCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSItem fetchContent(CMSServiceCtx cmsCtx, String path) throws Exception {
        String savedScope = cmsCtx.getScope();
        try {
            boolean saveAsync = cmsCtx.isAsyncCacheRefreshing();
            cmsCtx.setAsyncCacheRefreshing(false);
            CMSPublicationInfos pubInfos = this.getPublicationInfos(cmsCtx, path);
            path = pubInfos.getDocumentPath();
            cmsCtx.setAsyncCacheRefreshing(saveAsync);
            boolean haveToGetLive = "1".equals(cmsCtx.getDisplayLiveVersion());
            if (pubInfos.getDocumentPath().equals(cmsCtx.getForcedLivePath()) || pubInfos.getLiveId().equals(cmsCtx.getForcedLivePath())) {
                haveToGetLive = true;
            }
            if (!pubInfos.isPublished() && StringUtils.isNotEmpty((String)pubInfos.getPublishSpacePath()) && pubInfos.isLiveSpace()) {
                haveToGetLive = true;
            }
            if (!pubInfos.isPublished() && pubInfos.getPublishSpacePath() == null) {
                haveToGetLive = true;
            }
            cmsCtx.setScope("superuser_context");
            if (haveToGetLive) {
                Document doc = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentFetchLiveCommand(path, "Read"));
                CMSItem cMSItem = this.createItem(cmsCtx, path, doc.getTitle(), doc);
                return cMSItem;
            }
            Document doc = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentFetchPublishedCommand(path));
            CMSItem cMSItem = this.createItem(cmsCtx, path, doc.getTitle(), doc);
            return cMSItem;
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
    }

    public CMSItem getContent(CMSServiceCtx cmsCtx, String path) throws CMSException {
        CMSItem content = null;
        try {
            content = this.fetchContent(cmsCtx, path);
            this.getCustomizer().getCMSItemAdapter().adaptItem(cmsCtx, content);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return content;
    }

    public CMSBinaryContent getBinaryContent(CMSServiceCtx cmsCtx, String type, String docPath, String parameter) throws CMSException {
        CMSBinaryContent content = new CMSBinaryContent();
        if ("file".equals(type)) {
            content = this.getFileContent(cmsCtx, docPath, parameter);
        } else if ("attachedPicture".equals(type)) {
            content = this.getAttachedPicture(cmsCtx, docPath, parameter);
        } else if ("picture".equals(type)) {
            content = this.getPicture(cmsCtx, docPath, parameter);
        }
        return content;
    }

    public CMSBinaryContent getAttachedPicture(CMSServiceCtx cmsCtx, String docPath, String pictureIndex) throws CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchAttachedPicture(cmsCtx, docPath, pictureIndex);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return cmsContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSBinaryContent fetchAttachedPicture(CMSServiceCtx cmsCtx, String docPath, String pictureIndex) throws Exception {
        CMSBinaryContent pictureContent = null;
        String savedScope = cmsCtx.getScope();
        try {
            CMSItem containerDoc = this.fetchContent(cmsCtx, docPath);
            if (containerDoc != null) {
                cmsCtx.setScope("superuser_context");
                pictureContent = (CMSBinaryContent)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new InternalPictureCommand((Document)containerDoc.getNativeItem(), pictureIndex));
            }
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return pictureContent;
    }

    public CMSBinaryContent getPicture(CMSServiceCtx cmsCtx, String docPath, String content) throws CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchPicture(cmsCtx, docPath, content);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return cmsContent;
    }

    private CMSBinaryContent fetchPicture(CMSServiceCtx cmsCtx, String docPath, String content) throws Exception {
        CMSBinaryContent pictureContent = null;
        String savedScope = cmsCtx.getScope();
        String savedPubInfosScope = cmsCtx.getForcePublicationInfosScope();
        try {
            cmsCtx.setForcePublicationInfosScope("superuser_context");
            CMSPublicationInfos publiInfos = this.getPublicationInfos(cmsCtx, docPath);
            cmsCtx.setForcePublicationInfosScope(null);
            if (publiInfos.isAnonymouslyReadable()) {
                cmsCtx.setForcePublicationInfosScope("anonymous");
            }
            CMSItem picture = this.fetchContent(cmsCtx, publiInfos.getDocumentPath());
            cmsCtx.setScope("superuser_context");
            pictureContent = (CMSBinaryContent)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PictureContentCommand((Document)picture.getNativeItem(), content));
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    CMSBinaryContent cMSBinaryContent = null;
                    return cMSBinaryContent;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
            cmsCtx.setForcePublicationInfosScope(savedPubInfosScope);
        }
        return pictureContent;
    }

    public CMSBinaryContent getFileContent(CMSServiceCtx cmsCtx, String docPath, String fieldName) throws CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchFileContent(cmsCtx, docPath, fieldName);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return cmsContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSBinaryContent fetchFileContent(CMSServiceCtx cmsCtx, String docPath, String fieldName) throws Exception {
        CMSBinaryContent content = null;
        String savedScope = cmsCtx.getScope();
        try {
            CMSItem document;
            if (StringUtils.isNotEmpty((String)savedScope)) {
                cmsCtx.setForcePublicationInfosScope(savedScope);
            }
            if ((document = this.fetchContent(cmsCtx, docPath)) != null) {
                String size;
                PropertyMap map;
                cmsCtx.setScope("superuser_context");
                FileContentCommand cmd = new FileContentCommand((Document)document.getNativeItem(), fieldName);
                if (cmsCtx.isStreamingSupport() && (map = ((Document)document.getNativeItem()).getProperties().getMap("file:content")) != null && !map.isEmpty() && (size = map.getString("length")) != null && Long.parseLong(size) > 100000L) {
                    cmd.setStreamingSupport(true);
                    cmsCtx.setScope("superuser_no_cache");
                }
                content = (CMSBinaryContent)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)cmd);
            }
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return content;
    }

    public boolean checkContentAnonymousAccess(CMSServiceCtx cmsCtx, String path) throws CMSException {
        try {
            CMSPublicationInfos pubInfos = this.getPublicationInfos(cmsCtx, path);
            return pubInfos.isAnonymouslyReadable();
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return false;
    }

    public CMSHandlerProperties getItemHandler(CMSServiceCtx ctx) throws CMSException {
        try {
            if (!"detailedView".equals(ctx.getDisplayContext())) {
                return this.getNuxeoService().getCMSCustomizer().getCMSPlayer(ctx);
            }
            return ((DefaultCMSCustomizer)this.getNuxeoService().getCMSCustomizer()).getCMSDefaultPlayer(ctx);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return null;
    }

    public Map<String, NavigationItem> loadPartialNavigationTree(CMSServiceCtx cmsCtx, CMSItem publishSpaceConfig, String path, boolean fetchSubItems) throws CMSException {
        String savedScope = cmsCtx.getScope();
        try {
            Map<String, Object> navItems = null;
            ArrayList<String> idsToFetch = new ArrayList<String>();
            boolean fetchRoot = false;
            String cacheId = "partial_navigation_tree/" + publishSpaceConfig.getPath();
            HttpServletRequest request = cmsCtx.getServerInvocation().getServerContext().getClientRequest();
            boolean refreshing = PageProperties.getProperties().isRefreshingPage();
            PartialNavigationInvoker partialNavInvoker = null;
            if (refreshing) {
                partialNavInvoker = (PartialNavigationInvoker)request.getAttribute("partialNavInvoker");
            }
            CacheInfo cacheInfos = new CacheInfo(cacheId, CacheInfo.CACHE_SCOPE_PORTLET_SESSION, null, (Object)request, this.portletCtx, false);
            cacheInfos.setExpirationDelay(200000L);
            navItems = (HashMap<String, NavigationItem>)this.getCacheService().getCache(cacheInfos);
            if (navItems == null) {
                navItems = new HashMap<String, NavigationItem>();
                fetchRoot = true;
            }
            String pathToCheck = path;
            CMSServiceCtx superUserCtx = new CMSServiceCtx();
            superUserCtx.setControllerContext(cmsCtx.getControllerContext());
            cmsCtx.setScope("superuser_context");
            while (pathToCheck.contains(publishSpaceConfig.getPath())) {
                Document doc;
                NavigationItem navItem = (NavigationItem)navItems.get(pathToCheck);
                if (navItem != null && fetchSubItems && navItem.isUnfetchedChildren() && !idsToFetch.contains((doc = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentFetchLiveCommand(pathToCheck, "Read"))).getId())) {
                    idsToFetch.add(doc.getId());
                }
                if (navItem == null && !idsToFetch.contains((doc = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentFetchLiveCommand(pathToCheck, "Read"))).getId())) {
                    idsToFetch.add(doc.getId());
                }
                CMSObjectPath parentPath = CMSObjectPath.parse((String)pathToCheck).getParent();
                pathToCheck = parentPath.toString();
            }
            if (idsToFetch.size() > 0 || fetchRoot) {
                cmsCtx.setScope("__nocache");
                navItems = (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PartialNavigationCommand(publishSpaceConfig, navItems, idsToFetch, fetchRoot, path));
                cacheInfos.setForceReload(true);
                cacheInfos.setForceNOTReload(false);
                partialNavInvoker = new PartialNavigationInvoker(navItems);
                if (refreshing) {
                    request.setAttribute("partialNavInvoker", (Object)partialNavInvoker);
                }
                cacheInfos.setInvoker((IServiceInvoker)partialNavInvoker);
                this.getCacheService().getCache(cacheInfos);
            }
            HashMap<String, NavigationItem> hashMap = navItems;
            return hashMap;
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
    }

    public CMSItem getPortalNavigationItem(CMSServiceCtx cmsCtx, String publishSpacePath, String path) throws CMSException {
        String savedScope = cmsCtx.getScope();
        if (cmsCtx.getScope() == null || "__nocache".equals(cmsCtx.getScope())) {
            cmsCtx.setScope("user_session");
        }
        try {
            NavigationItem navItem;
            String livePath = DocumentPublishSpaceNavigationCommand.computeNavPath((String)path);
            CMSItem publishSpaceConfig = this.getSpaceConfig(cmsCtx, publishSpacePath);
            if (publishSpaceConfig == null) {
                throw new CMSException(3);
            }
            Map navItems = null;
            boolean forceLiveVersion = false;
            if ("1".equals(cmsCtx.getDisplayLiveVersion()) || "1".equals(publishSpaceConfig.getProperties().get("displayLiveVersion"))) {
                forceLiveVersion = true;
            }
            boolean canUseES = NuxeoCompatibility.canUseES() && BooleanUtils.toBoolean((String)((String)publishSpaceConfig.getProperties().get("useES")));
            boolean refreshing = PageProperties.getProperties().isRefreshingPage();
            navItems = (!canUseES || canUseES && refreshing) && "1".equals(publishSpaceConfig.getProperties().get("partialLoading")) ? this.loadPartialNavigationTree(cmsCtx, publishSpaceConfig, path, false) : (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentPublishSpaceNavigationCommand(publishSpaceConfig, forceLiveVersion));
            if (navItems != null && (navItem = (NavigationItem)navItems.get(livePath)) != null) {
                CMSItem item = navItem.getAdaptedCMSItem();
                if (item == null) {
                    if (navItem.getMainDoc() != null) {
                        navItem.setAdaptedCMSItem(this.createNavigationItem(cmsCtx, livePath, ((Document)navItem.getMainDoc()).getTitle(), (Document)navItem.getMainDoc(), publishSpaceConfig.getPath()));
                    } else {
                        CMSItem cMSItem = null;
                        return cMSItem;
                    }
                }
                CMSItem cMSItem = navItem.getAdaptedCMSItem();
                return cMSItem;
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return null;
    }

    public List<CMSItem> getPortalNavigationSubitems(CMSServiceCtx cmsCtx, String publishSpacePath, String path) throws CMSException {
        String savedScope = cmsCtx.getScope();
        if (cmsCtx.getScope() == null || "__nocache".equals(cmsCtx.getScope())) {
            cmsCtx.setScope("user_session");
        }
        try {
            NavigationItem navItem;
            CMSItem publishSpaceConfig = this.getSpaceConfig(cmsCtx, publishSpacePath);
            if (publishSpaceConfig == null) {
                throw new CMSException(3);
            }
            Map navItems = null;
            boolean forceLiveVersion = false;
            if ("1".equals(cmsCtx.getDisplayLiveVersion()) || "1".equals(publishSpaceConfig.getProperties().get("displayLiveVersion"))) {
                forceLiveVersion = true;
            }
            boolean canUseES = NuxeoCompatibility.canUseES() && BooleanUtils.toBoolean((String)((String)publishSpaceConfig.getProperties().get("useES")));
            boolean refreshing = PageProperties.getProperties().isRefreshingPage();
            navItems = (!canUseES || canUseES && refreshing) && "1".equals(publishSpaceConfig.getProperties().get("partialLoading")) ? this.loadPartialNavigationTree(cmsCtx, publishSpaceConfig, path, true) : (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentPublishSpaceNavigationCommand(publishSpaceConfig, forceLiveVersion));
            if (navItems != null && (navItem = (NavigationItem)navItems.get(path)) != null) {
                ArrayList<CMSItem> childrens = new ArrayList<CMSItem>();
                for (Object child : navItem.getChildren()) {
                    Document docChild = (Document)child;
                    String childNavPath = DocumentPublishSpaceNavigationCommand.computeNavPath((String)docChild.getPath());
                    NavigationItem navChild = (NavigationItem)navItems.get(childNavPath);
                    CMSItem item = navChild.getAdaptedCMSItem();
                    if (item == null && navChild.getMainDoc() != null) {
                        item = this.createNavigationItem(cmsCtx, childNavPath, ((Document)navChild.getMainDoc()).getTitle(), (Document)navChild.getMainDoc(), publishSpacePath);
                        navChild.setAdaptedCMSItem(item);
                    }
                    if (item != null) {
                        item.getProperties().put("unfetchedChildren", BooleanUtils.toStringTrueFalse((boolean)navChild.isUnfetchedChildren()));
                    }
                    childrens.add(navChild.getAdaptedCMSItem());
                }
                ArrayList<CMSItem> arrayList = childrens;
                return arrayList;
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return null;
    }

    public List<CMSItem> getPortalSubitems(CMSServiceCtx cmsContext, String path) throws CMSException {
        try {
            Document parent = (Document)this.fetchContent(cmsContext, path).getNativeItem();
            String parentId = parent.getId();
            boolean liveContent = "1".equals(cmsContext.getDisplayLiveVersion());
            ListCMSSubitemsCommand nuxeoCommand = new ListCMSSubitemsCommand(cmsContext, parentId, liveContent);
            return (List)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)nuxeoCommand);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSPublicationInfos getPublicationInfos(CMSServiceCtx ctx, String path) throws CMSException {
        CMSPublicationInfos pubInfos = new CMSPublicationInfos();
        try {
            String savedScope = ctx.getScope();
            try {
                List errors;
                if (StringUtils.isNotEmpty((String)ctx.getForcePublicationInfosScope())) {
                    ctx.setScope(ctx.getForcePublicationInfosScope());
                } else if (ctx.getServerInvocation() != null) {
                    ServerInvocation invocation = ctx.getServerInvocation();
                    User user = (User)invocation.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)"user");
                    if (user == null) {
                        ctx.setScope("anonymous");
                    } else {
                        ctx.setScope("user_session");
                    }
                }
                String cmsReferrerNavigationPath = ctx.getCmsReferrerNavigationPath();
                String displayLiveVersion = ctx.getDisplayLiveVersion();
                pubInfos = (CMSPublicationInfos)this.executeNuxeoCommand(ctx, (INuxeoCommand)new PublishInfosCommand(cmsReferrerNavigationPath, path, displayLiveVersion));
                if (pubInfos != null && (errors = pubInfos.getErrorCodes()) != null) {
                    if (errors.contains(2)) {
                        throw new CMSException(1);
                    }
                    if (errors.contains(1)) {
                        throw new CMSException(3);
                    }
                }
            }
            finally {
                ctx.setScope(savedScope);
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return pubInfos;
    }

    public List<CMSItem> getWorkspaces(CMSServiceCtx cmsContext, boolean userWorkspaces, boolean administrator) throws CMSException {
        BrowserAdapter browserAdapter = this.customizer.getBrowserAdapter();
        List workspaces = userWorkspaces ? browserAdapter.getUserWorkspaces(cmsContext) : browserAdapter.getWorkspaces(cmsContext, administrator);
        return workspaces;
    }

    public CMSExtendedDocumentInfos getExtendedDocumentInfos(CMSServiceCtx ctx, String path) throws CMSException {
        CMSExtendedDocumentInfos docInfos = new CMSExtendedDocumentInfos();
        try {
            docInfos = (CMSExtendedDocumentInfos)this.executeNuxeoCommand(ctx, (INuxeoCommand)new ExtendedDocInfosCommand(path));
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return docInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSItem getSpaceConfig(CMSServiceCtx cmsCtx, String publishSpacePath) throws CMSException {
        CMSItem configItem = null;
        HttpServletRequest portalRequest = cmsCtx.getServerInvocation().getServerContext().getClientRequest();
        boolean forceLiveVersion = false;
        if ("1".equals(cmsCtx.getDisplayLiveVersion())) {
            forceLiveVersion = true;
        }
        String requestKey = "osivia.cache.spaceConfig." + publishSpacePath + "." + forceLiveVersion;
        try {
            CMSItem value = (CMSItem)portalRequest.getAttribute(requestKey);
            if (value != null) {
                if (PageProperties.getProperties().isRefreshingPage() && portalRequest.getAttribute(requestKey + ".resfreshed") == null) {
                    portalRequest.setAttribute(requestKey + ".resfreshed", (Object)"1");
                    value = null;
                }
                if (value != null) {
                    return value;
                }
            }
            String savedScope = cmsCtx.getScope();
            String savedPubInfosScope = cmsCtx.getForcePublicationInfosScope();
            try {
                cmsCtx.setForcePublicationInfosScope("superuser_context");
                configItem = this.fetchContent(cmsCtx, publishSpacePath);
                this.getCustomizer().getNavigationItemAdapter().adaptPublishSpaceNavigationItem(configItem, configItem);
                portalRequest.setAttribute(requestKey, (Object)configItem);
            }
            finally {
                cmsCtx.setScope(savedScope);
                cmsCtx.setForcePublicationInfosScope(savedPubInfosScope);
            }
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return configItem;
    }

    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws CMSException {
        try {
            return this.customizer.parseCMSURL(cmsCtx, requestPath, requestParameters);
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
    }

    public String adaptWebPathToCms(CMSServiceCtx cmsCtx, String requestPath) throws CMSException {
        try {
            CMSItem content = this.getContent(cmsCtx, requestPath);
            return content.getPath();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
    }

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws CMSException {
        try {
            return this.customizer.computeUserPreloadedPages(cmsCtx);
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
    }

    public List<CMSEditableWindow> getEditableWindows(CMSServiceCtx cmsContext, String path, String publishSpacePath, String sitePath, String navigationScope) throws CMSException {
        ArrayList<CMSEditableWindow> windows = new ArrayList<CMSEditableWindow>();
        String workingPath = path == null ? sitePath : path;
        boolean editionMode = false;
        if ("1".equals(cmsContext.getDisplayLiveVersion())) {
            editionMode = true;
        }
        Map inheritedRegions = this.getInheritedRegions(cmsContext, workingPath, publishSpacePath, sitePath, navigationScope, editionMode);
        for (List inheritedWindows : inheritedRegions.values()) {
            if (!CollectionUtils.isNotEmpty((Collection)inheritedWindows)) continue;
            windows.addAll(inheritedWindows);
        }
        int windowsCount = windows.size();
        try {
            PropertyList fragments;
            CMSItem pageItem = this.fetchContent(cmsContext, workingPath);
            Document document = (Document)pageItem.getNativeItem();
            if (publishSpacePath != null && (fragments = document.getProperties().getList("fgts:fragments")) != null && !fragments.isEmpty()) {
                EditableWindowAdapter adapter = this.customizer.getEditableWindowAdapter();
                int regionWindowsCount = 0;
                for (int i = 0; i < fragments.size(); ++i) {
                    PropertyMap fragment = fragments.getMap(i);
                    String regionId = fragment.getString("regionId");
                    if (inheritedRegions.get(regionId) != null) continue;
                    String category = fragment.getString("fragmentCategory");
                    EditableWindow editableWindow = adapter.getType(category);
                    if (editableWindow != null) {
                        int windowId = windowsCount + regionWindowsCount;
                        Map properties = editableWindow.fillProps(document, fragment, Boolean.valueOf(editionMode));
                        CMSEditableWindow window = editableWindow.createNewEditabletWindow(windowId, properties);
                        windows.add(window);
                        ++regionWindowsCount;
                        continue;
                    }
                    logger.warn((Object)("Type de fragment " + category + " non g\u00e9r\u00e9"));
                }
            }
        }
        catch (CMSException e) {
            if (e.getErrorCode() != 1) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        return windows;
    }

    private Map<String, List<CMSEditableWindow>> getInheritedRegions(CMSServiceCtx cmsContext, String path, String publishSpacePath, String sitePath, String navigationScope, boolean editionMode) {
        boolean directInheritance;
        HashMap<String, List<CMSEditableWindow>> inheritedRegions = new HashMap<String, List<CMSEditableWindow>>();
        CMSServiceCtx navCMSContext = new CMSServiceCtx();
        if (cmsContext.getControllerContext() != null) {
            navCMSContext.setControllerContext(cmsContext.getControllerContext());
        } else if (cmsContext.getServerInvocation() != null) {
            navCMSContext.setServerInvocation(cmsContext.getServerInvocation());
        }
        navCMSContext.setScope(navigationScope);
        EditableWindowAdapter adapter = this.customizer.getEditableWindowAdapter();
        Set overridedRegions = this.getPageOverridedRegions(cmsContext, path, publishSpacePath);
        int windowId = 0;
        String parentPath = CMSObjectPath.parse((String)path).getParent().toString();
        while (StringUtils.startsWith((String)parentPath, (String)publishSpacePath)) {
            Map pagePropagatedRegions = this.getPagePropagatedRegions(navCMSContext, overridedRegions, windowId, adapter, parentPath, publishSpacePath, editionMode);
            inheritedRegions.putAll(pagePropagatedRegions);
            overridedRegions.addAll(pagePropagatedRegions.keySet());
            for (List windows : pagePropagatedRegions.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)windows)) continue;
                windowId += windows.size();
            }
            parentPath = CMSObjectPath.parse((String)parentPath).getParent().toString();
        }
        boolean bl = directInheritance = publishSpacePath != null && StringUtils.startsWith((String)path, (String)sitePath);
        if (!directInheritance) {
            Map pagePropagatedRegions = this.getPagePropagatedRegions(navCMSContext, overridedRegions, windowId, adapter, sitePath, sitePath, editionMode);
            inheritedRegions.putAll(pagePropagatedRegions);
        }
        return inheritedRegions;
    }

    private Set<String> getPageOverridedRegions(CMSServiceCtx cmsContext, String path, String publishSpacePath) {
        TreeSet<String> overridedRegions = new TreeSet<String>();
        try {
            CMSItem navItem = this.getPortalNavigationItem(cmsContext, publishSpacePath, path);
            if (navItem != null) {
                Map regionsInheritance = this.getCMSRegionsInheritance(navItem);
                for (Map.Entry region : regionsInheritance.entrySet()) {
                    if (RegionInheritance.DEFAULT.equals(region.getValue())) continue;
                    overridedRegions.add((String)region.getKey());
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return overridedRegions;
    }

    private Map<String, List<CMSEditableWindow>> getPagePropagatedRegions(CMSServiceCtx cmsContext, Set<String> overridedRegions, int windowsCount, EditableWindowAdapter adapter, String path, String publishSpacePath, boolean editionMode) {
        HashMap<String, List<CMSEditableWindow>> pagePropagatedRegions;
        block14: {
            pagePropagatedRegions = new HashMap<String, List<CMSEditableWindow>>();
            try {
                String regionId;
                PropertyMap fragment;
                PropertyList fragments;
                CMSItem item;
                CMSItem navItem = this.getPortalNavigationItem(cmsContext, publishSpacePath, path);
                if (navItem == null) break block14;
                HashSet<Object> propagatedRegions = new HashSet<Object>();
                HashSet lockedRegions = new HashSet();
                Document document = null;
                boolean fetched = false;
                Portal portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext());
                if (PortalObjectUtils.isSpaceSite((PortalObject)portal)) {
                    Map inheritance = this.getCMSRegionsInheritance(navItem);
                    for (Map.Entry region : inheritance.entrySet()) {
                        if (RegionInheritance.LOCKED.equals(region.getValue())) {
                            pagePropagatedRegions.put((String)region.getKey(), new ArrayList());
                            propagatedRegions.add(region.getKey());
                            lockedRegions.add(region.getKey());
                            continue;
                        }
                        if (overridedRegions.contains(region.getKey())) continue;
                        if (RegionInheritance.NO_INHERITANCE.equals(region.getValue())) {
                            pagePropagatedRegions.put((String)region.getKey(), (List<CMSEditableWindow>)null);
                            continue;
                        }
                        if (!RegionInheritance.PROPAGATED.equals(region.getValue())) continue;
                        pagePropagatedRegions.put((String)region.getKey(), new ArrayList());
                        propagatedRegions.add(region.getKey());
                    }
                } else {
                    item = this.fetchContent(cmsContext, path);
                    fetched = true;
                    if (item != null) {
                        document = (Document)item.getNativeItem();
                        fragments = document.getProperties().getList("fgts:fragments");
                        for (int i = 0; i < fragments.size(); ++i) {
                            fragment = fragments.getMap(i);
                            regionId = fragment.getString("regionId");
                            if (propagatedRegions.contains(regionId)) continue;
                            pagePropagatedRegions.put(regionId, new ArrayList());
                            propagatedRegions.add(regionId);
                        }
                    }
                }
                if (!propagatedRegions.isEmpty()) {
                    if (!fetched && (item = this.fetchContent(cmsContext, path)) != null) {
                        document = (Document)item.getNativeItem();
                    }
                    if (document != null) {
                        int regionWindowsCount = 0;
                        fragments = document.getProperties().getList("fgts:fragments");
                        for (int i = 0; i < fragments.size(); ++i) {
                            String category;
                            EditableWindow editableWindow;
                            fragment = fragments.getMap(i);
                            regionId = fragment.getString("regionId");
                            if (!propagatedRegions.contains(regionId) || (editableWindow = adapter.getType(category = fragment.getString("fragmentCategory"))) == null) continue;
                            List windows = (List)pagePropagatedRegions.get(regionId);
                            int windowId = windowsCount + regionWindowsCount;
                            Map properties = editableWindow.fillProps(document, fragment, Boolean.valueOf(editionMode));
                            properties.put("osivia.cms.inheritance.indicator", String.valueOf(true));
                            if (lockedRegions.contains(regionId)) {
                                properties.put("osivia.cms.inheritance.locked", String.valueOf(true));
                            }
                            CMSEditableWindow window = editableWindow.createNewEditabletWindow(windowId, properties);
                            windows.add(window);
                            ++regionWindowsCount;
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return pagePropagatedRegions;
    }

    public Map<String, RegionInheritance> getCMSRegionsInheritance(CMSItem item) {
        Document document;
        PropertyList regions;
        HashMap<String, RegionInheritance> regionsInheritance = new HashMap<String, RegionInheritance>();
        if (item != null && (regions = (document = (Document)item.getNativeItem()).getProperties().getList("rg:regions")) != null) {
            for (int i = 0; i < regions.size(); ++i) {
                PropertyMap region = regions.getMap(i);
                String id = region.getString("regionId");
                RegionInheritance inheritance = RegionInheritance.fromValue((String)region.getString("inheritance"));
                regionsInheritance.put(id, inheritance);
            }
        }
        return regionsInheritance;
    }

    public void saveCMSRegionInheritance(CMSServiceCtx cmsContext, String path, String regionName, RegionInheritance inheritance) throws CMSException {
        cmsContext.setDisplayLiveVersion("1");
        try {
            CMSItem cmsItem = this.getContent(cmsContext, path);
            Document document = (Document)cmsItem.getNativeItem();
            PropertyList regions = document.getProperties().getList("rg:regions");
            if (regions != null) {
                DocumentUpdatePropertiesCommand command;
                ArrayList<String> properties = new ArrayList<String>();
                for (int i = 0; i < regions.size(); ++i) {
                    PropertyMap region = regions.getMap(i);
                    if (!StringUtils.equals((String)regionName, (String)region.getString("regionId"))) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append("rg:regions");
                    builder.append("/");
                    builder.append(i);
                    builder.append("/");
                    builder.append("inheritance");
                    builder.append("=");
                    builder.append(StringUtils.trimToEmpty((String)inheritance.getValue()));
                    properties.add(builder.toString());
                    break;
                }
                if (properties.isEmpty()) {
                    HashMap<String, String> value = new HashMap<String, String>();
                    value.put("regionId", regionName);
                    value.put("inheritance", StringUtils.trimToEmpty((String)inheritance.getValue()));
                    command = new DocumentAddComplexPropertyCommand(document, "rg:regions", value);
                } else {
                    command = new DocumentUpdatePropertiesCommand(document, properties);
                }
                this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            }
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public Set<CMSConfigurationItem> getCMSRegionLayoutsConfigurationItems(CMSServiceCtx cmsContext) throws CMSException {
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)cmsContext);
        HashSet<CMSConfigurationItem> configurationItems = null;
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.REGION_LAYOUT);
            try {
                Documents documents = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)cmsContext, (CMSService)this, (WebConfigurationQueryCommand)command);
                configurationItems = new HashSet<CMSConfigurationItem>(documents.size());
                for (Document document : documents) {
                    PropertyMap properties = document.getProperties();
                    String code = properties.getString("wconf:code");
                    String additionalCode = properties.getString("wconf:code2");
                    CMSConfigurationItem configurationItem = new CMSConfigurationItem(document.getTitle(), code);
                    configurationItem.setAdditionalCode(additionalCode);
                    configurationItems.add(configurationItem);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return configurationItems;
    }

    public Map<String, CMSConfigurationItem> getCMSRegionsSelectedLayout(CMSItem item, Set<CMSConfigurationItem> regionLayouts) throws CMSException {
        Document document;
        PropertyList regions;
        HashMap<String, CMSConfigurationItem> regionsLayout = new HashMap<String, CMSConfigurationItem>();
        if (item != null && (regions = (document = (Document)item.getNativeItem()).getProperties().getList("rg:regions")) != null) {
            for (int i = 0; i < regions.size(); ++i) {
                PropertyMap region = regions.getMap(i);
                String id = region.getString("regionId");
                String regionLayoutCode = region.getString("regionLayout");
                CMSConfigurationItem selectedRegionLayout = null;
                for (CMSConfigurationItem regionLayout : regionLayouts) {
                    if (!StringUtils.equals((String)regionLayout.getCode(), (String)regionLayoutCode)) continue;
                    selectedRegionLayout = regionLayout;
                    break;
                }
                regionsLayout.put(id, selectedRegionLayout);
            }
        }
        return regionsLayout;
    }

    public void saveCMSRegionSelectedLayout(CMSServiceCtx cmsContext, String path, String regionName, String regionLayoutName) throws CMSException {
        cmsContext.setDisplayLiveVersion("1");
        try {
            CMSItem cmsItem = this.getContent(cmsContext, path);
            Document document = (Document)cmsItem.getNativeItem();
            PropertyList regions = document.getProperties().getList("rg:regions");
            if (regions != null) {
                DocumentUpdatePropertiesCommand command;
                ArrayList<String> properties = new ArrayList<String>();
                for (int i = 0; i < regions.size(); ++i) {
                    PropertyMap region = regions.getMap(i);
                    if (!StringUtils.equals((String)regionName, (String)region.getString("regionId"))) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append("rg:regions");
                    builder.append("/");
                    builder.append(i);
                    builder.append("/");
                    builder.append("regionLayout");
                    builder.append("=");
                    builder.append(StringUtils.trimToEmpty((String)regionLayoutName));
                    properties.add(builder.toString());
                    break;
                }
                if (properties.isEmpty()) {
                    HashMap<String, String> value = new HashMap<String, String>();
                    value.put("regionId", regionName);
                    value.put("regionLayout", StringUtils.trimToEmpty((String)regionLayoutName));
                    command = new DocumentAddComplexPropertyCommand(document, "rg:regions", value);
                } else {
                    command = new DocumentUpdatePropertiesCommand(document, properties);
                }
                this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            }
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void deleteFragment(CMSServiceCtx cmsCtx, String pagePath, String refURI) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        PropertyList fragments = doc.getProperties().getList("fgts:fragments");
        List propertiesToRemove = null;
        if (fragments != null && !fragments.isEmpty()) {
            for (int fragmentIndex = 0; fragmentIndex < fragments.size(); ++fragmentIndex) {
                if (!refURI.equals(fragments.getMap(fragmentIndex).get("uri"))) continue;
                String fragmentCategory = (String)fragments.getMap(fragmentIndex).get("fragmentCategory");
                EditableWindowAdapter adapter = this.customizer.getEditableWindowAdapter();
                EditableWindow ew = adapter.getType(fragmentCategory);
                if (ew == null) continue;
                propertiesToRemove = ew.prepareDelete(doc, refURI);
            }
        }
        try {
            if (propertiesToRemove != null) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentRemovePropertyCommand(doc, propertiesToRemove));
                cmsCtx.setForceReload(true);
                this.getContent(cmsCtx, pagePath);
                cmsCtx.setForceReload(false);
            }
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public String getEcmDomain(CMSServiceCtx cmsCtx) {
        return NuxeoConnectionProperties.getPublicDomainUri().toString();
    }

    public String getEcmUrl(CMSServiceCtx cmsCtx, EcmViews command, String path, Map<String, String> requestParameters) throws CMSException {
        String uri = NuxeoConnectionProperties.getPublicBaseUri().toString();
        String url = "";
        if (command == EcmViews.createPage) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_create_document?";
            requestParameters.put("type", "PortalPage");
        } else if (command == EcmViews.createDocument) {
            url = uri.toString() + "/nxpath/default" + path + "@toutatice_create?";
        } else if (command == EcmViews.editDocument) {
            url = uri.toString() + "/nxpath/default" + path + "@toutatice_edit?";
        } else if (command == EcmViews.editPage) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_edit_document?";
        } else if (command == EcmViews.createFgtInRegion) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_create_fragment?";
        } else if (command == EcmViews.createFgtBelowWindow) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_create_fragment?";
        } else if (command == EcmViews.editFgt) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_edit_fragment?";
        } else if (command == EcmViews.viewSummary) {
            url = uri.toString() + "/nxpath/default" + path + "@view_documents?";
        } else if (command == EcmViews.shareDocument) {
            url = uri.toString() + "/nxpath/default" + path + "@send_notification_email?";
        } else if (command == EcmViews.startValidationWf) {
            url = uri.toString() + "/nxpath/default" + path + "@choose_wf?";
        } else if (command == EcmViews.followWfValidation) {
            url = uri.toString() + "/nxpath/default" + path + "@current_task?";
        } else if (command == EcmViews.remotePublishing) {
            url = uri.toString() + "/nxpath/default" + path + "@remote_publishing?";
        } else if (command == EcmViews.validateRemotePublishing) {
            url = uri.toString() + "/nxpath/default" + path + "@validate_remote_publishing?";
        } else if (command == EcmViews.gotoMediaLibrary) {
            Document mediaLibrary;
            try {
                String baseDomainPath = "/".concat(path.split("/")[1]);
                mediaLibrary = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentGetMediaLibraryCommand(baseDomainPath));
            }
            catch (Exception e) {
                throw new CMSException((Throwable)e);
            }
            url = mediaLibrary != null ? uri.toString() + "/nxpath/default" + mediaLibrary.getPath() + "@view_documents?" : "";
        }
        if (command != EcmViews.gotoMediaLibrary) {
            PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsCtx.getControllerContext());
            String portalUrl = this.getPortalUrlFactory().getBasePortalUrl(portalControllerContext);
            requestParameters.put("fromUrl", portalUrl);
            for (Map.Entry<String, String> param : requestParameters.entrySet()) {
                url = url.concat(param.getKey()).concat("=").concat(param.getValue()).concat("&");
            }
        }
        return url;
    }

    public void moveFragment(CMSServiceCtx cmsCtx, String pagePath, String fromRegion, Integer fromPos, String toRegion, Integer toPos, String refUri) throws CMSException {
        cmsCtx.setForceReload(true);
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            List propertiesToUpdate = EditableWindowHelper.checkBeforeMove((Document)doc, (String)fromRegion, (Integer)fromPos, (String)refUri);
            if (propertiesToUpdate.size() > 0) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentUpdatePropertiesCommand(doc, propertiesToUpdate));
                CMSItem content = this.getContent(cmsCtx, pagePath);
                doc = (Document)content.getNativeItem();
            }
            if ((propertiesToUpdate = EditableWindowHelper.prepareMove((Document)doc, (String)fromRegion, (Integer)fromPos, (String)toRegion, (Integer)toPos, (String)refUri)).size() > 0) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentUpdatePropertiesCommand(doc, propertiesToUpdate));
                this.getContent(cmsCtx, pagePath);
            }
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        finally {
            cmsCtx.setForceReload(false);
        }
    }

    public boolean isCmsWebPage(CMSServiceCtx cmsCtx, String cmsPath) throws CMSException {
        CMSItem content = this.getContent(cmsCtx, cmsPath);
        Document nativeItem = (Document)content.getNativeItem();
        PropertyList list = nativeItem.getProperties().getList("fgts:fragments");
        return list != null;
    }

    public void publishDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new SetOnLineCommand(doc));
            cmsCtx.setDisplayLiveVersion("0");
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
            this.refreshBinaryResource(cmsCtx, pagePath);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void unpublishDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        boolean isRemoteProxy;
        Document doc;
        String reloadPagePath = pagePath;
        cmsCtx.setDisplayLiveVersion("0");
        CMSItem cmsPublishedItem = this.getContent(cmsCtx, pagePath);
        Document publishedDoc = (Document)cmsPublishedItem.getNativeItem();
        String publishedDocPath = CMSItemAdapter.computeNavPath((String)publishedDoc.getPath());
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document inputDoc = doc = (Document)cmsItem.getNativeItem();
        boolean bl = isRemoteProxy = !publishedDocPath.equals(doc.getPath());
        if (isRemoteProxy) {
            inputDoc = publishedDoc;
            reloadPagePath = StringUtils.substringBeforeLast((String)pagePath, (String)"/");
            cmsCtx.setDisplayLiveVersion("0");
        }
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new SetOffLineCommand(inputDoc));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, reloadPagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void askToPublishDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new AskSetOnLineCommand(doc));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void cancelPublishWorkflow(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new CancelWorkflowCommand(doc, "toutatice_online_approbation"));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void validatePublicationOfDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        this.callValidationCommand(cmsCtx, pagePath, true);
    }

    public void rejectPublicationOfDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        this.callValidationCommand(cmsCtx, pagePath, false);
    }

    public void callValidationCommand(CMSServiceCtx cmsCtx, String pagePath, boolean accept) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new ValidationPublishCommand(doc, accept));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void deleteDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentDeleteCommand(doc));
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void putDocumentInTrash(CMSServiceCtx cmsCtx, String docId) throws CMSException {
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PutInTrashDocumentCommand(docId));
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public Link getUserAvatar(CMSServiceCtx cmsCtx, String username) throws CMSException {
        return this.customizer.getUserAvatar(cmsCtx, username);
    }

    public String refreshUserAvatar(CMSServiceCtx cmsCtx, String username) {
        return this.customizer.refreshUserAvatar(cmsCtx, username);
    }

    public Link getBinaryResourceURL(CMSServiceCtx cmsCtx, BinaryDescription binary) throws CMSException {
        return this.customizer.getBinaryResourceURL(cmsCtx, binary);
    }

    public BinaryDelegation validateBinaryDelegation(CMSServiceCtx cmsCtx, String path) {
        return this.customizer.validateBinaryDelegation(cmsCtx, path);
    }

    public String refreshBinaryResource(CMSServiceCtx cmsCtx, String path) {
        return this.customizer.refreshBinaryResource(cmsCtx, path);
    }

    public void executeEcmCommand(CMSServiceCtx cmsCtx, EcmCommand command, String cmsPath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, cmsPath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new NuxeoCommandDelegate(command, doc));
            cmsCtx.setDisplayLiveVersion("0");
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, cmsPath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }
}

