/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.InputStream;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.osivia.portal.core.cms.CMSExtendedDocumentInfos;

public class ExtendedDocInfosCommand
implements INuxeoCommand {
    private String path;

    public ExtendedDocInfosCommand(String path) {
        this.path = path;
    }

    public CMSExtendedDocumentInfos execute(Session nuxeoSession) throws Exception {
        CMSExtendedDocumentInfos docInfos = new CMSExtendedDocumentInfos();
        OperationRequest request = nuxeoSession.newRequest("Document.FetchExtendedDocInfos");
        if (this.path.startsWith("webId:")) {
            request.set("webid", (Object)this.path.replaceAll("webId:", ""));
        } else {
            request.set("path", (Object)this.path);
        }
        Blob infosAsBlob = (Blob)request.execute();
        if (infosAsBlob != null) {
            docInfos = new CMSExtendedDocumentInfos();
            String infosContentStr = IOUtils.toString((InputStream)infosAsBlob.getStream(), (String)"UTF-8");
            JSONArray infosContent = JSONArray.fromObject((Object)infosContentStr);
            for (JSONObject infos : infosContent) {
                String taskName;
                if (infos.containsKey((Object)"taskName") && StringUtils.isNotBlank((String)(taskName = infos.getString("taskName")))) {
                    docInfos.setTaskName(taskName);
                    docInfos.setIsOnlineTaskPending(Boolean.valueOf(infos.getBoolean("isTaskPending")));
                    docInfos.setCanUserValidateOnlineTask(Boolean.valueOf(infos.getBoolean("canManageTask")));
                    docInfos.setIsUserOnlineTaskInitiator(Boolean.valueOf(infos.getBoolean("isTaskInitiator")));
                }
                if (infos.containsKey((Object)"isValidationWfRunning")) {
                    docInfos.setIsValidationWorkflowRunning(Boolean.valueOf(infos.getBoolean("isValidationWfRunning")));
                }
                if (infos.containsKey((Object)"subscription_status")) {
                    docInfos.setSubscriptionStatus(CMSExtendedDocumentInfos.SubscriptionStatus.valueOf((String)infos.get("subscription_status").toString()));
                }
                if (infos.containsKey((Object)"lockStatus")) {
                    docInfos.setLockStatus(CMSExtendedDocumentInfos.LockStatus.valueOf((String)infos.get("lockStatus").toString()));
                    if (infos.containsKey((Object)"lockOwner")) {
                        docInfos.setLockOwner(infos.get("lockOwner").toString());
                    }
                }
                if (infos.containsKey((Object)"canSynchronize")) {
                    docInfos.setCanSynchronize(BooleanUtils.toBoolean((String)infos.get("canSynchronize").toString()));
                }
                if (infos.containsKey((Object)"canUnsynchronize")) {
                    docInfos.setCanUnsynchronize(BooleanUtils.toBoolean((String)infos.get("canUnsynchronize").toString()));
                }
                if (infos.containsKey((Object)"synchronizationRootPath")) {
                    docInfos.setSynchronizationRootPath(infos.get("synchronizationRootPath").toString());
                }
                if (!infos.containsKey((Object)"driveEditURL")) continue;
                docInfos.setDriveEditURL(infos.get("driveEditURL").toString());
            }
        }
        if (infosAsBlob instanceof FileBlob) {
            ((FileBlob)infosAsBlob).getFile().delete();
        }
        return docInfos;
    }

    public String getId() {
        return "ExtendedDocInfosCommand /" + this.path;
    }
}

