/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.editablewindow;

import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindowComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.core.cms.CMSException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EditableWindowHelper {
    public static final String SCHEMA_FRAGMENTS = "fgts:fragments";
    public static final String SCHEMA_REGIONS = "rg:regions";
    public static final String FGT_URI = "uri";
    public static final String FGT_TYPE = "fragmentCategory";
    public static final String FGT_ORDER = "order";
    public static final String REGION_IDENTIFIER = "regionId";
    public static final String INHERITANCE = "inheritance";
    public static final String REGION_LAYOUT = "regionLayout";
    private static EditableWindowComparator comparator = new EditableWindowComparator();
    private static final Log LOGGER = LogFactory.getLog(EditableWindowHelper.class);

    private EditableWindowHelper() {
    }

    public static Integer findIndexByURI(Document doc, String refURI) {
        PropertyList list = doc.getProperties().getList("fgts:fragments");
        int index = 0;
        for (Object o : list.list()) {
            PropertyMap map;
            if (o instanceof PropertyMap && (refURI.equals((map = (PropertyMap)o).get("uri")) || refURI.equals(map.get("refURI")))) {
                return index;
            }
            ++index;
        }
        LOGGER.warn((Object)("Fragment " + refURI + " non d\u00e9fini dans le sch\u00e9ma " + "fgts:fragments"));
        return null;
    }

    public static Integer findIndexByRefURI(Document doc, String schema, String refURI) {
        PropertyList list = doc.getProperties().getList(schema);
        int index = 0;
        for (Object o : list.list()) {
            PropertyMap map;
            if (o instanceof PropertyMap && (refURI.equals((map = (PropertyMap)o).get("uri")) || refURI.equals(map.get("refURI")))) {
                return index;
            }
            ++index;
        }
        LOGGER.warn((Object)("Fragment " + refURI + " non d\u00e9fini dans le sch\u00e9ma " + schema));
        return null;
    }

    public static List<Integer> findIndexesByRefURI(Document doc, String schema, String refURI) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        PropertyList list = doc.getProperties().getList(schema);
        int index = 0;
        for (Object o : list.list()) {
            PropertyMap map;
            if (o instanceof PropertyMap && (refURI.equals((map = (PropertyMap)o).get("uri")) || refURI.equals(map.get("refURI")))) {
                indexes.add(new Integer(index));
            }
            ++index;
        }
        LOGGER.warn((Object)("Fragment " + refURI + " non d\u00e9fini dans le sch\u00e9ma " + schema));
        return indexes;
    }

    public static PropertyMap findSchemaByRefURI(Document doc, String schema, String refURI) {
        PropertyList list = doc.getProperties().getList(schema);
        for (Object o : list.list()) {
            PropertyMap map;
            if (!(o instanceof PropertyMap) || !refURI.equals((map = (PropertyMap)o).get("uri")) && !refURI.equals(map.get("refURI"))) continue;
            return map;
        }
        LOGGER.warn((Object)("Fragment " + refURI + " non d\u00e9fini dans le sch\u00e9ma " + schema));
        return null;
    }

    public static List<String> checkBeforeMove(Document doc, String fromRegion, Integer fromPos, String refUri) throws CMSException {
        ArrayList<String> propertiesToUpdate = new ArrayList<String>();
        PropertyList list = doc.getProperties().getList("fgts:fragments");
        HashMap map = new HashMap();
        for (Object o : list.list()) {
            TreeSet<PropertyMap> currentSet;
            if (!(o instanceof PropertyMap)) continue;
            PropertyMap currentFrag = (PropertyMap)o;
            String currentRegion = currentFrag.getString("regionId");
            if (map.get(currentRegion) != null) {
                currentSet = (TreeSet<PropertyMap>)map.get(currentRegion);
            } else {
                currentSet = new TreeSet<PropertyMap>((Comparator<PropertyMap>)comparator);
                map.put(currentRegion, currentSet);
            }
            currentSet.add(currentFrag);
        }
        for (SortedSet region : map.values()) {
            Integer expectedOrder = 0;
            for (PropertyMap fragment : region) {
                Integer currentOrder = Integer.parseInt(fragment.getString("order"));
                if (currentOrder != expectedOrder) {
                    Integer fgtToUpdate = EditableWindowHelper.findIndexByURI((Document)doc, (String)fragment.getString("uri"));
                    String moveToOrder = "fgts:fragments".concat("/").concat(fgtToUpdate.toString()).concat("/").concat("order").concat("=").concat(expectedOrder.toString());
                    propertiesToUpdate.add(moveToOrder);
                }
                Integer n = expectedOrder;
                Integer n2 = expectedOrder = Integer.valueOf(expectedOrder + 1);
            }
        }
        return propertiesToUpdate;
    }

    public static List<String> prepareMove(Document doc, String fromRegion, Integer fromPos, String toRegion, Integer toPos, String refUri) throws CMSException {
        PropertyMap currentInNuxeo = EditableWindowHelper.findSchemaByRefURI((Document)doc, (String)"fgts:fragments", (String)refUri);
        if (!currentInNuxeo.getString("order").equals(Integer.toString(fromPos)) || !currentInNuxeo.getString("regionId").equals(fromRegion)) {
            throw new CMSException("Document Nux\u00e9o d\u00e9synchronis\u00e9");
        }
        ArrayList<String> propertiesToUpdate = new ArrayList<String>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+-------> Move " + refUri + " (" + fromRegion + "/" + fromPos + ") to (" + toRegion + "/" + toPos + ") "));
        }
        if (fromRegion.equals(toRegion) && fromPos.equals(toPos)) {
            return propertiesToUpdate;
        }
        PropertyList list = doc.getProperties().getList("fgts:fragments");
        Integer index = 0;
        if (fromRegion.equals(toRegion)) {
            boolean moveDown = true;
            Integer minOrder = fromPos;
            Integer maxOrder = toPos;
            if (fromPos > toPos) {
                moveDown = false;
                minOrder = toPos;
                maxOrder = fromPos;
            }
            for (Object o : list.list()) {
                Integer currentOrder;
                Integer currentFrag;
                if (o instanceof PropertyMap) {
                    currentFrag = (PropertyMap)o;
                    currentOrder = Integer.parseInt(currentFrag.getString("order"));
                    if (fromRegion.equals(currentFrag.getString("regionId"))) {
                        String moveToOrder;
                        Integer newOrder;
                        if (fromPos.equals(currentOrder)) {
                            newOrder = toPos;
                            moveToOrder = "fgts:fragments".concat("/").concat(index.toString()).concat("/").concat("order").concat("=").concat(newOrder.toString());
                            propertiesToUpdate.add(moveToOrder);
                        } else if (fromRegion.equals(currentFrag.getString("regionId")) && currentOrder >= minOrder && currentOrder <= maxOrder) {
                            newOrder = moveDown ? currentOrder - 1 : currentOrder + 1;
                            moveToOrder = "fgts:fragments".concat("/").concat(index.toString()).concat("/").concat("order").concat("=").concat(newOrder.toString());
                            propertiesToUpdate.add(moveToOrder);
                        }
                    }
                }
                currentFrag = index;
                currentOrder = index = Integer.valueOf(index + 1);
            }
        } else {
            for (Object o : list.list()) {
                if (o instanceof PropertyMap) {
                    PropertyMap currentFrag = (PropertyMap)o;
                    Integer currentOrder = Integer.parseInt(currentFrag.getString("order"));
                    if (fromRegion.equals(currentFrag.getString("regionId")) && fromPos.equals(currentOrder)) {
                        String moveToRegion = "fgts:fragments".concat("/").concat(index.toString()).concat("/").concat("regionId").concat("=").concat(toRegion);
                        propertiesToUpdate.add(moveToRegion);
                        Integer newOrder = toPos;
                        String moveToOrder = "fgts:fragments".concat("/").concat(index.toString()).concat("/").concat("order").concat("=").concat(newOrder.toString());
                        propertiesToUpdate.add(moveToOrder);
                    } else {
                        String moveToOrder;
                        Integer newOrder;
                        if (fromRegion.equals(currentFrag.getString("regionId")) && currentOrder > fromPos) {
                            newOrder = currentOrder - 1;
                            moveToOrder = "fgts:fragments".concat("/").concat(index.toString()).concat("/").concat("order").concat("=").concat(newOrder.toString());
                            propertiesToUpdate.add(moveToOrder);
                        }
                        if (toRegion.equals(currentFrag.getString("regionId")) && currentOrder >= toPos) {
                            newOrder = currentOrder + 1;
                            moveToOrder = "fgts:fragments".concat("/").concat(index.toString()).concat("/").concat("order").concat("=").concat(newOrder.toString());
                            propertiesToUpdate.add(moveToOrder);
                        }
                    }
                }
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        return propertiesToUpdate;
    }
}

