/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.tags;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSException;

public class UserTag
extends SimpleTagSupport {
    private static final IPortalUrlFactory PORTAL_URL_FACTORY = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private static final IDirectoryServiceLocator DIRECTORY_SERVICE_LOCATOR = (IDirectoryServiceLocator)Locator.findMBean(IDirectoryServiceLocator.class, (String)"osivia:service=DirectoryServiceLocator");
    private String name;
    private Boolean linkable;

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest request = pageContext.getRequest();
        NuxeoController nuxeoController = (NuxeoController)request.getAttribute("nuxeoController");
        IDirectoryService directoryService = DIRECTORY_SERVICE_LOCATOR.getDirectoryService();
        JspWriter out = pageContext.getOut();
        if (nuxeoController != null && directoryService != null) {
            Element text;
            String avatarSource;
            DirectoryPerson person = directoryService.getPerson(this.name);
            try {
                Link link = nuxeoController.getUserAvatar(this.name);
                avatarSource = link.getUrl();
            }
            catch (CMSException e) {
                avatarSource = "";
            }
            String displayName = person != null && StringUtils.isNotEmpty((String)person.getDisplayName()) ? person.getDisplayName() : this.name;
            Element container = DOM4JUtils.generateElement((String)"span", null, null);
            Element avatar = DOM4JUtils.generateElement((String)"img", (String)"avatar", null);
            DOM4JUtils.addAttribute((Element)avatar, (String)"src", (String)avatarSource);
            DOM4JUtils.addAttribute((Element)avatar, (String)"alt", (String)"");
            container.add(avatar);
            if (BooleanUtils.isFalse((Boolean)this.linkable) || person == null) {
                text = DOM4JUtils.generateElement((String)"span", null, (String)displayName);
            } else {
                String profileURL = this.getUserProfilePageURL(nuxeoController, this.name, displayName);
                text = DOM4JUtils.generateLinkElement((String)profileURL, null, null, null, (String)displayName);
            }
            container.add(text);
            HTMLWriter htmlWriter = new HTMLWriter((Writer)out);
            htmlWriter.write(container);
        } else {
            out.write(this.name);
        }
    }

    private String getUserProfilePageURL(NuxeoController nuxeoController, String name, String displayName) {
        String url;
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.hideTitle", "1");
        properties.put("osivia.ajaxLink", "1");
        properties.put("theme.dyna.partial_refresh_enabled", "true");
        properties.put("uidFichePersonne", name);
        HashMap parameters = new HashMap(0);
        try {
            url = PORTAL_URL_FACTORY.getStartPortletInNewPage(portalControllerContext, "myprofile", displayName, "toutatice-identite-fichepersonne-portailPortletInstance", properties, parameters);
        }
        catch (PortalException e) {
            url = "";
        }
        return url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getLinkable() {
        return this.linkable;
    }

    public void setLinkable(Boolean linkable) {
        this.linkable = linkable;
    }
}

