package com.osivia.cns.proto.constants;

import java.util.HashMap;
import java.util.Map;


/**
 * @author David Chevrier.
 *
 */ 
public interface CnsConstants {
    
    /** CNS nature vocabulary. */
    String NATURE_VOCABULARY = "nature";
    /** CNS nature vocabulary schema. */
    String NATURE_VOCABULARY_SCHEMA = "l10nxvocabulary";
    
    /** CNS Direct validation. */
    String CNS_VALIDATION_WF = "cns-validation";
    /** CNS direct Validation task. */
    String CNS_VALIDATION_TASK = "direct-validation-task";
    /** CNS direct validation button. */
    String CNS_VALIDATION_BUTTON = "direct-validation";
    /** CNS cancel button. */
    String CNS_CANCEL_BUTTON = "cancel";
    
    /** Metadata (map task/document). */
    Map<String, String> METADATA = new HashMap<String, String>(5) {

        private static final long serialVersionUID = -7996841415431657806L;

        {
            put("cns.cycle_vie", "cns:cycle_vie");
            put("dc.subjects", "dc:subjects");
            put("dc.nature", "dc:nature");
            put("cns.s_info_associe", "cns:s_info_associe");
            put("dc.source", "dc:source");
        }
    };
    
}
