/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.cns.proto.userworkspaces;

import java.io.Serializable;
import java.security.Principal;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;

public class UserWorkspaceService
extends DefaultUserWorkspaceServiceImpl {
    private static final String TTC_SHOW_IN_MENU = "ttc:showInMenu";
    private static final String DC_TITLE = "dc:title";
    private static final long serialVersionUID = 4621010585970187579L;

    protected DocumentModel doCreateUserWorkspace(CoreSession unrestrictedSession, PathRef wsRef, Principal principal, String userName) throws ClientException {
        DocumentModel userWorkspace = super.doCreateUserWorkspace(unrestrictedSession, wsRef, principal, userName);
        userWorkspace.setProperty("toutatice", "pageTemplate", (Object)"/templates/userWorkspace");
        userWorkspace.setProperty("toutatice", "tabOrder", (Object)"100");
        userWorkspace.setProperty("toutatice", "isPreloadedOnLogin", (Object)true);
        userWorkspace.setPropertyValue(DC_TITLE, (Serializable)((Object)"Mon espace"));
        unrestrictedSession.saveDocument(userWorkspace);
        DocumentModel mesDocs = unrestrictedSession.createDocumentModel(userWorkspace.getPathAsString(), "Mes documents", "Folder");
        mesDocs.setPropertyValue(DC_TITLE, (Serializable)((Object)"Mes documents"));
        mesDocs.setPropertyValue(TTC_SHOW_IN_MENU, (Serializable)Boolean.TRUE);
        unrestrictedSession.createDocument(mesDocs);
        DocumentModel mesLiens = unrestrictedSession.createDocumentModel(userWorkspace.getPathAsString(), "Mes liens", "DocumentUrlContainer");
        mesLiens.setPropertyValue(DC_TITLE, (Serializable)((Object)"Mes liens"));
        mesLiens.setPropertyValue(TTC_SHOW_IN_MENU, (Serializable)Boolean.TRUE);
        unrestrictedSession.createDocument(mesLiens);
        DocumentModel monBlog = unrestrictedSession.createDocumentModel(userWorkspace.getPathAsString(), "Mon blog", "BlogSite");
        monBlog.setPropertyValue(DC_TITLE, (Serializable)((Object)("Le blog de " + this.buildUserWorkspaceTitle(principal, userName))));
        unrestrictedSession.createDocument(monBlog);
        this.setFoldersACL(monBlog, userName);
        DocumentModel publicFolder = unrestrictedSession.createDocumentModel(userWorkspace.getPathAsString(), "Public", "Folder");
        publicFolder.setPropertyValue(DC_TITLE, (Serializable)((Object)"Public"));
        publicFolder.setPropertyValue(TTC_SHOW_IN_MENU, (Serializable)Boolean.TRUE);
        unrestrictedSession.createDocument(publicFolder);
        this.setFoldersACL(publicFolder, userName);
        return userWorkspace;
    }

    protected void setFoldersACL(DocumentModel doc, String userName) throws ClientException {
        ACPImpl acp = new ACPImpl();
        ACE grantMembersRead = new ACE("members", "Read", true);
        ACE grantEverything = new ACE(userName, "Everything", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{grantMembersRead, grantEverything});
        acp.addACL((ACL)acl);
        doc.setACP((ACP)acp, true);
    }
}

