/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.cns.proto.massvalidation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="massValidation")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=132)
public class MassValidationBean {
    private static final String MASS_VALIDATION_EVENT = "massValidationEvent";
    private static final String PV_MASS_VALIDATION_CHOOSE = "mass_validation";
    private static final String PV_MASS_VALIDATION = "mass_validation_2";
    private static final String PV_MASS_VALIDATION_CONFIRM = "mass_validation_3";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    private Integer nbDocToModify = 0;
    private Map<String, Serializable> propertiesToModify;
    private Boolean withValidation = null;

    public Integer getNbDocToModify() {
        return this.nbDocToModify;
    }

    public Boolean getWithValidation() {
        return this.withValidation;
    }

    public void setWithValidation(Boolean withValidation) {
        this.withValidation = withValidation;
    }

    public String goToChooseValidation() {
        return PV_MASS_VALIDATION_CHOOSE;
    }

    public String goToStartValidation() {
        return PV_MASS_VALIDATION;
    }

    public String validate() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        this.propertiesToModify = new HashMap<String, Serializable>();
        this.propertiesToModify.put("cns:cycle_vie", doc.getPropertyValue("cns:cycle_vie"));
        this.propertiesToModify.put("dc:subjects", doc.getPropertyValue("dc:subjects"));
        this.propertiesToModify.put("dc:nature", doc.getPropertyValue("dc:nature"));
        this.propertiesToModify.put("cns:s_info_associe", doc.getPropertyValue("cns:s_info_associe"));
        this.propertiesToModify.put("dc:source", doc.getPropertyValue("dc:source"));
        DocumentModelList listToModify = this.documentManager.query("SELECT * FROM Document WHERE ecm:path STARTSWITH '" + doc.getPathAsString() + "' AND ecm:mixinType <> 'folderish'" + " AND ecm:currentLifeCycleState = 'project' AND ecm:isVersion = 0 ");
        this.nbDocToModify = listToModify.size();
        DocumentRoutingService routingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        for (DocumentModel child : listToModify) {
            if (routingService.getDocumentRoutesForAttachedDocument(this.documentManager, child.getId()).size() <= 0) continue;
            this.nbDocToModify = this.nbDocToModify - 1;
        }
        return PV_MASS_VALIDATION_CONFIRM;
    }

    public String confirmValidate() {
        EventProducer eventProducer;
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        try {
            eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            return PV_MASS_VALIDATION_CONFIRM;
        }
        DocumentEventContext ctx = new DocumentEventContext(this.documentManager, this.documentManager.getPrincipal(), doc);
        ctx.setProperties(this.propertiesToModify);
        ctx.setProperty("withValidation", (Serializable)this.withValidation);
        Event event = ctx.newEvent(MASS_VALIDATION_EVENT);
        try {
            eventProducer.fireEvent(event);
        }
        catch (ClientException e) {
            return PV_MASS_VALIDATION_CONFIRM;
        }
        return "done";
    }
}

