/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.services.calendar.portlet.model.CalendarConfiguration;
import org.osivia.services.calendar.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.portlet.model.events.Event;
import org.osivia.services.calendar.portlet.repository.ICalendarRepository;
import org.osivia.services.calendar.portlet.repository.ListEventsCommand;
import org.springframework.stereotype.Repository;

@Repository
public class CalendarRepositoryImpl
implements ICalendarRepository {
    private static final String CMS_PATH_WINDOW_PROPERTY = "osivia.calendar.cmsPath";
    private static final String DEFAULT_VIEW_WINDOW_PROPERTY = "osivia.calendar.defaultView";
    private static final String COMPACT_VIEW_WINDOW_PROPERTY = "osivia.calendar.compactView";
    private static final String DOCUMENT_REQUEST_ATTRIBUTE = "osivia.calendar.document";

    public CalendarConfiguration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        CalendarConfiguration configuration = new CalendarConfiguration();
        configuration.setCmsPath(window.getProperty(CMS_PATH_WINDOW_PROPERTY));
        configuration.setPeriodTypeName(window.getProperty(DEFAULT_VIEW_WINDOW_PROPERTY));
        configuration.setCompactView(BooleanUtils.toBoolean((String)window.getProperty(COMPACT_VIEW_WINDOW_PROPERTY)));
        return configuration;
    }

    public String getTitle(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        Document document = this.getDocument(nuxeoController);
        return document.getTitle();
    }

    public void saveConfiguration(PortalControllerContext portalControllerContext, CalendarConfiguration configuration) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        window.setProperty(CMS_PATH_WINDOW_PROPERTY, configuration.getCmsPath());
        window.setProperty(DEFAULT_VIEW_WINDOW_PROPERTY, configuration.getPeriodTypeName());
        window.setProperty(COMPACT_VIEW_WINDOW_PROPERTY, BooleanUtils.toStringTrueFalse((boolean)configuration.isCompactView()));
    }

    public List<Event> getEvents(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String cmsPath = this.getCMSPath(nuxeoController);
        NuxeoQueryFilterContext queryContext = nuxeoController.getQueryFilterContextForPath(cmsPath);
        ListEventsCommand nuxeoCommand = new ListEventsCommand(queryContext, cmsPath, calendarData.getStartDate(), calendarData.getEndDate());
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
        ArrayList<Event> events = new ArrayList<Event>(documents.size());
        for (Document document : documents) {
            String id = document.getId();
            String title = document.getTitle();
            Date startDate = document.getDate("vevent:dtstart");
            Date endDate = document.getDate("vevent:dtend");
            String viewURL = nuxeoController.getLink(document).getUrl();
            if (startDate == null || endDate == null) continue;
            Event event = new Event(id, title, startDate, endDate, viewURL);
            events.add(event);
        }
        return events;
    }

    public void insertContentMenubarItems(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String cmsPath = this.getCMSPath(nuxeoController);
        try {
            CMSPublicationInfos cmsPublicationInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), cmsPath);
            if (cmsPublicationInfos.isEditableByUser()) {
                nuxeoController.setParentPathToCreate(cmsPath);
            }
            Document document = this.getDocument(nuxeoController);
            nuxeoController.setCurrentDoc(document);
            nuxeoController.insertContentMenuBarItems();
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private String getCMSPath(NuxeoController nuxeoController) throws PortletException {
        String cmsPath;
        CalendarConfiguration configuration = this.getConfiguration(nuxeoController.getPortalCtx());
        if (StringUtils.isNotBlank((String)configuration.getCmsPath())) {
            cmsPath = configuration.getCmsPath();
        } else {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
            cmsPath = window.getPageProperty("osivia.cms.basePath");
        }
        cmsPath = nuxeoController.getLivePath(cmsPath);
        return nuxeoController.getComputedPath(cmsPath);
    }

    private Document getDocument(NuxeoController nuxeoController) throws PortletException {
        PortletRequest request = nuxeoController.getRequest();
        Document document = (Document)request.getAttribute(DOCUMENT_REQUEST_ATTRIBUTE);
        if (document == null) {
            String cmsPath = this.getCMSPath(nuxeoController);
            document = nuxeoController.fetchDocument(cmsPath);
            request.setAttribute(DOCUMENT_REQUEST_ATTRIBUTE, (Object)document);
        }
        return document;
    }
}

