/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.service.generator;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.portlet.PortletException;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.services.calendar.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.portlet.model.events.DailyEvent;
import org.osivia.services.calendar.portlet.model.events.Event;
import org.osivia.services.calendar.portlet.model.events.EventsData;
import org.osivia.services.calendar.portlet.model.events.PlanningCalendarCompactEventsData;
import org.osivia.services.calendar.portlet.model.events.PlanningCalendarEvent;
import org.osivia.services.calendar.portlet.model.events.PlanningCalendarEventHeader;
import org.osivia.services.calendar.portlet.model.events.PlanningCalendarEventsData;
import org.osivia.services.calendar.portlet.service.ICalendarService;
import org.osivia.services.calendar.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planningCalendarGenerator")
public class PlanningCalendarGeneratorImpl
extends CalendarGeneratorImpl {
    @Autowired
    private ICalendarService calendarService;

    public PeriodTypes getPeriodType() {
        return PeriodTypes.PLANNING;
    }

    protected CalendarData generateSpecializedCalendarData(PortalControllerContext portalControllerContext) throws PortletException {
        return new CalendarData();
    }

    protected void updateSpecializedCalendarData(PortalControllerContext portalControllerContext, CalendarData calendarData) {
    }

    protected String getDisplayDate(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        DateFormat dateFormat = SimpleDateFormat.getDateInstance(2, portalControllerContext.getRequest().getLocale());
        StringBuilder builder = new StringBuilder();
        builder.append(dateFormat.format(calendarData.getStartDate()));
        builder.append(" - ");
        builder.append(dateFormat.format(calendarData.getEndDate()));
        return builder.toString();
    }

    protected EventsData generateSpecializedEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData, List<Event> events) throws PortletException {
        PlanningCalendarCompactEventsData eventsData;
        boolean compact = this.calendarService.isCompact(portalControllerContext);
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.getBundleFactory().getBundle(locale);
        DateFormat timeFormat = SimpleDateFormat.getTimeInstance(3, locale);
        Calendar startCalendar = GregorianCalendar.getInstance(locale);
        Calendar endCalendar = GregorianCalendar.getInstance(locale);
        ArrayList<PlanningCalendarEvent> planningEvents = new ArrayList<PlanningCalendarEvent>(events.size());
        TreeMap<PlanningCalendarEventHeader, ArrayList<DailyEvent>> planningCompactEvents = new TreeMap<PlanningCalendarEventHeader, ArrayList<DailyEvent>>();
        for (Event event : events) {
            startCalendar.setTime(event.getStartDate());
            endCalendar.setTime(event.getEndDate());
            boolean begin = true;
            while (!startCalendar.after(endCalendar)) {
                Date currentDate = DateUtils.truncate((Date)startCalendar.getTime(), (int)5);
                if (!currentDate.before(calendarData.getStartDate()) && currentDate.before(calendarData.getEndDate())) {
                    Object planningEvent = compact ? new DailyEvent(event, currentDate) : new PlanningCalendarEvent(event, currentDate);
                    planningEvent.setBegin(begin);
                    boolean end = DateUtils.isSameDay((Calendar)startCalendar, (Calendar)endCalendar);
                    planningEvent.setEnd(end);
                    StringBuilder builder = new StringBuilder();
                    if (begin || end) {
                        if (begin) {
                            builder.append(timeFormat.format(event.getStartDate()));
                            if (end) {
                                builder.append(" - ");
                            }
                        }
                        if (end) {
                            builder.append(timeFormat.format(event.getEndDate()));
                        }
                    } else {
                        builder.append(bundle.getString("CALENDAR_EVENT_ALL_DAY"));
                    }
                    planningEvent.setTime(builder.toString());
                    PlanningCalendarEventHeader header = new PlanningCalendarEventHeader(startCalendar.getTime());
                    header.setDayOfMonth(String.valueOf(startCalendar.get(5)));
                    header.setDayOfWeek(startCalendar.getDisplayName(7, 2, locale));
                    builder = new StringBuilder();
                    builder.append(startCalendar.getDisplayName(2, 2, locale));
                    builder.append(" ");
                    builder.append(startCalendar.get(1));
                    header.setMonth(builder.toString());
                    if (compact) {
                        ArrayList<DailyEvent> dailyEvents = (ArrayList<DailyEvent>)planningCompactEvents.get(header);
                        if (dailyEvents == null) {
                            dailyEvents = new ArrayList<DailyEvent>();
                            planningCompactEvents.put(header, dailyEvents);
                        }
                        dailyEvents.add((DailyEvent)planningEvent);
                    } else {
                        PlanningCalendarEvent planningCalendarEvent = (PlanningCalendarEvent)planningEvent;
                        planningCalendarEvent.setHeader(header);
                        planningEvents.add(planningCalendarEvent);
                    }
                }
                startCalendar.add(5, 1);
                startCalendar = DateUtils.truncate((Calendar)startCalendar, (int)5);
                begin = false;
            }
        }
        if (compact) {
            PlanningCalendarCompactEventsData planningCompactEventsData;
            eventsData = planningCompactEventsData = new PlanningCalendarCompactEventsData();
            planningCompactEventsData.setMappedEvents(planningCompactEvents);
        } else {
            PlanningCalendarEventsData planningEventsData = new PlanningCalendarEventsData();
            eventsData = planningEventsData;
            Collections.sort(planningEvents);
            planningEventsData.setEvents(planningEvents);
        }
        return eventsData;
    }
}

