/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.service.generator;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.portlet.PortletException;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.services.calendar.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.portlet.model.calendar.WeeklyCalendarData;
import org.osivia.services.calendar.portlet.model.calendar.WeeklyCalendarHeader;
import org.osivia.services.calendar.portlet.model.events.DailyCalendarEventsData;
import org.osivia.services.calendar.portlet.model.events.DailyEvent;
import org.osivia.services.calendar.portlet.model.events.Event;
import org.osivia.services.calendar.portlet.model.events.EventsData;
import org.osivia.services.calendar.portlet.model.events.TimeSlotEvent;
import org.osivia.services.calendar.portlet.service.ICalendarCollisionManager;
import org.osivia.services.calendar.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="weeklyCalendarGenerator")
public class WeeklyCalendarGeneratorImpl
extends CalendarGeneratorImpl {
    @Autowired
    private ICalendarCollisionManager collisionManager;

    public PeriodTypes getPeriodType() throws PortletException {
        return PeriodTypes.WEEK;
    }

    protected CalendarData generateSpecializedCalendarData(PortalControllerContext portalControllerContext) throws PortletException {
        Locale locale = portalControllerContext.getRequest().getLocale();
        WeeklyCalendarData calendarData = new WeeklyCalendarData();
        Date selectedDate = this.getSelectedDate(portalControllerContext);
        Date startDate = this.getStartDate(portalControllerContext, this.getPeriodType(), selectedDate);
        calendarData.setHeaders(this.getHeaders(portalControllerContext, startDate));
        Calendar todayCalendar = GregorianCalendar.getInstance(locale);
        Calendar startCalendar = GregorianCalendar.getInstance(locale);
        startCalendar.setTime(startDate);
        if (todayCalendar.get(1) == startCalendar.get(1) && todayCalendar.get(3) == startCalendar.get(3)) {
            int dayOfWeek = (todayCalendar.get(7) - todayCalendar.getFirstDayOfWeek() + 1) % 7;
            if (dayOfWeek == 0) {
                dayOfWeek = 7;
            }
            calendarData.setToday(dayOfWeek);
        }
        int position = 280;
        calendarData.setAutoScroll(String.valueOf(position));
        return calendarData;
    }

    protected void updateSpecializedCalendarData(PortalControllerContext portalControllerContext, CalendarData calendarData) {
        WeeklyCalendarData weeklyCalendarData = (WeeklyCalendarData)calendarData;
        Date startDate = calendarData.getStartDate();
        weeklyCalendarData.setHeaders(this.getHeaders(portalControllerContext, startDate));
    }

    private List<WeeklyCalendarHeader> getHeaders(PortalControllerContext portalControllerContext, Date startDate) {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Calendar calendar = GregorianCalendar.getInstance(locale);
        calendar.setTime(startDate);
        SimpleDateFormat weekDayFormat = new SimpleDateFormat("EEE", locale);
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        ArrayList<WeeklyCalendarHeader> headers = new ArrayList<WeeklyCalendarHeader>(7);
        for (int i = 0; i < 7; ++i) {
            Date date = calendar.getTime();
            WeeklyCalendarHeader header = new WeeklyCalendarHeader(date);
            StringBuilder builder = new StringBuilder();
            builder.append(weekDayFormat.format(date));
            builder.append(" ");
            builder.append(dateFormat.format(date));
            header.setName(builder.toString());
            headers.add(header);
            calendar.add(5, 1);
        }
        return headers;
    }

    protected String getDisplayDate(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        Bundle bundle = this.getBundleFactory().getBundle(portalControllerContext.getRequest().getLocale());
        Calendar calendar = DateUtils.toCalendar((Date)calendarData.getSelectedDate());
        StringBuilder builder = new StringBuilder();
        builder.append(bundle.getString("CALENDAR_WEEK"));
        builder.append(" ");
        builder.append(calendar.get(3));
        return builder.toString();
    }

    protected EventsData generateSpecializedEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData, List<Event> events) throws PortletException {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.getBundleFactory().getBundle(locale);
        DateFormat timeFormat = DateFormat.getTimeInstance(3, locale);
        Calendar startCalendar = GregorianCalendar.getInstance(locale);
        Calendar endCalendar = GregorianCalendar.getInstance(locale);
        ArrayList<TimeSlotEvent> dailyEvents = new ArrayList<TimeSlotEvent>(events.size());
        TreeMap<String, ArrayList<DailyEvent>> fullDayEvents = new TreeMap<String, ArrayList<DailyEvent>>();
        for (Event event : events) {
            StringBuilder builder;
            startCalendar.setTime(event.getStartDate());
            endCalendar.setTime(event.getEndDate());
            if (DateUtils.isSameDay((Calendar)startCalendar, (Calendar)endCalendar)) {
                Date currentDate = DateUtils.truncate((Date)startCalendar.getTime(), (int)5);
                TimeSlotEvent timeSlotEvent = new TimeSlotEvent(event, currentDate);
                timeSlotEvent.setBegin(true);
                timeSlotEvent.setEnd(true);
                builder = new StringBuilder();
                builder.append(timeFormat.format(event.getStartDate()));
                builder.append(" - ");
                builder.append(timeFormat.format(event.getEndDate()));
                timeSlotEvent.setTime(builder.toString());
                builder = new StringBuilder();
                builder.append((float)DateUtils.getFragmentInMilliseconds((Calendar)startCalendar, (int)5) / Float.valueOf(3600000.0f).floatValue() * 40.0f);
                builder.append("px");
                timeSlotEvent.setTop(builder.toString());
                builder = new StringBuilder();
                builder.append(this.getEventHours(startCalendar, endCalendar, true, true) * 40.0f);
                builder.append("px");
                timeSlotEvent.setHeight(builder.toString());
                timeSlotEvent.setStartTime(event.getStartDate().getTime());
                timeSlotEvent.setEndTime(event.getEndDate().getTime());
                dailyEvents.add(timeSlotEvent);
                continue;
            }
            boolean begin = true;
            while (startCalendar.before(endCalendar)) {
                Date currentDate = DateUtils.truncate((Date)startCalendar.getTime(), (int)5);
                if (!currentDate.before(calendarData.getStartDate()) && currentDate.before(calendarData.getEndDate())) {
                    String key;
                    ArrayList<DailyEvent> fullDayEventsList;
                    DailyEvent fullDayEvent = new DailyEvent(event, currentDate);
                    fullDayEvent.setBegin(begin);
                    boolean end = DateUtils.isSameDay((Calendar)startCalendar, (Calendar)endCalendar);
                    fullDayEvent.setEnd(end);
                    builder = new StringBuilder();
                    if (begin) {
                        builder.append(timeFormat.format(event.getStartDate()));
                    } else if (end) {
                        builder.append(timeFormat.format(event.getEndDate()));
                    } else {
                        builder.append(bundle.getString("CALENDAR_EVENT_ALL_DAY"));
                    }
                    fullDayEvent.setTime(builder.toString());
                    int dayOfWeek = (startCalendar.get(7) - startCalendar.getFirstDayOfWeek() + 1) % 7;
                    if (dayOfWeek == 0) {
                        dayOfWeek = 7;
                    }
                    if ((fullDayEventsList = (ArrayList<DailyEvent>)fullDayEvents.get(key = "week-day-" + String.valueOf(dayOfWeek))) == null) {
                        fullDayEventsList = new ArrayList<DailyEvent>();
                        fullDayEvents.put(key, fullDayEventsList);
                    }
                    fullDayEventsList.add(fullDayEvent);
                }
                startCalendar.add(5, 1);
                startCalendar = DateUtils.truncate((Calendar)startCalendar, (int)5);
                begin = false;
            }
        }
        this.collisionManager.updateWeeklyEvents(portalControllerContext, dailyEvents, calendarData.getSelectedDate());
        DailyCalendarEventsData eventsData = new DailyCalendarEventsData();
        eventsData.setEvents(dailyEvents);
        eventsData.setMappedEvents(fullDayEvents);
        return eventsData;
    }
}

