/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.services.calendar.portlet.model.CalendarConfiguration;
import org.osivia.services.calendar.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.portlet.model.events.Event;
import org.osivia.services.calendar.portlet.repository.ICalendarRepository;
import org.osivia.services.calendar.portlet.repository.ListEventsCommand;
import org.springframework.stereotype.Repository;

@Repository
public class CalendarRepositoryImpl
implements ICalendarRepository {
    private static final String CMS_PATH_WINDOW_PROPERTY = "osivia.calendar.cmsPath";
    private static final String DEFAULT_VIEW_WINDOW_PROPERTY = "osivia.calendar.defaultView";
    private static final String COMPACT_VIEW_WINDOW_PROPERTY = "osivia.calendar.compactView";
    private static final String DOCUMENT_REQUEST_ATTRIBUTE = "osivia.calendar.document";

    public CalendarConfiguration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        CalendarConfiguration configuration = new CalendarConfiguration();
        configuration.setCmsPath(window.getProperty(CMS_PATH_WINDOW_PROPERTY));
        configuration.setPeriodTypeName(window.getProperty(DEFAULT_VIEW_WINDOW_PROPERTY));
        configuration.setCompactView(BooleanUtils.toBoolean((String)window.getProperty(COMPACT_VIEW_WINDOW_PROPERTY)));
        return configuration;
    }

    public String getTitle(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        Document document = this.getDocument(nuxeoController);
        String title = null;
        if (document != null) {
            title = document.getTitle();
        }
        return title;
    }

    public void saveConfiguration(PortalControllerContext portalControllerContext, CalendarConfiguration configuration) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        window.setProperty(CMS_PATH_WINDOW_PROPERTY, configuration.getCmsPath());
        window.setProperty(DEFAULT_VIEW_WINDOW_PROPERTY, configuration.getPeriodTypeName());
        window.setProperty(COMPACT_VIEW_WINDOW_PROPERTY, BooleanUtils.toStringTrueFalse((boolean)configuration.isCompactView()));
    }

    public List<Event> getEvents(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        ArrayList<Event> events;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String cmsPath = this.getCMSPath(nuxeoController);
        if (StringUtils.isEmpty((String)cmsPath)) {
            events = null;
        } else {
            ListEventsCommand nuxeoCommand = new ListEventsCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, cmsPath, calendarData.getStartDate(), calendarData.getEndDate());
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
            events = new ArrayList<Event>(documents.size());
            for (Document document : documents) {
                String id = document.getId();
                String title = document.getTitle();
                Date startDate = document.getDate("vevent:dtstart");
                Date endDate = document.getDate("vevent:dtend");
                boolean allDay = BooleanUtils.isTrue((Boolean)document.getProperties().getBoolean("vevent:allDay"));
                String viewURL = nuxeoController.getLink(document).getUrl();
                if (startDate == null || endDate == null) continue;
                Event event = new Event(id, title, startDate, endDate, allDay, viewURL);
                events.add(event);
            }
        }
        return events;
    }

    public void insertContentMenubarItems(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        try {
            Document document = this.getDocument(nuxeoController);
            if (document != null && "Agenda".equals(document.getType())) {
                nuxeoController.setCurrentDoc(document);
                ICMSService cmsService = NuxeoController.getCMSService();
                CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
                String cmsPath = this.getCMSPath(nuxeoController);
                CMSPublicationInfos cmsPublicationInfos = cmsService.getPublicationInfos(cmsContext, cmsPath);
                if (cmsPublicationInfos.isEditableByUser()) {
                    nuxeoController.setParentPathToCreate(cmsPath);
                }
                nuxeoController.insertContentMenuBarItems();
            }
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void definePortletUri(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        NuxeoController nuxeoController = new NuxeoController(request, portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String path = this.getCMSPath(nuxeoController);
        request.setAttribute("osivia.cms.uri", (Object)path);
    }

    private String getCMSPath(NuxeoController nuxeoController) throws PortletException {
        String cmsPath;
        CalendarConfiguration configuration = this.getConfiguration(nuxeoController.getPortalCtx());
        if (StringUtils.isNotBlank((String)configuration.getCmsPath())) {
            cmsPath = configuration.getCmsPath();
        } else {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
            cmsPath = window.getPageProperty("osivia.cms.basePath");
        }
        return nuxeoController.getComputedPath(cmsPath);
    }

    private Document getDocument(NuxeoController nuxeoController) throws PortletException {
        Document document;
        block4: {
            PortletRequest request = nuxeoController.getRequest();
            document = (Document)request.getAttribute(DOCUMENT_REQUEST_ATTRIBUTE);
            if (document == null) {
                try {
                    String cmsPath = this.getCMSPath(nuxeoController);
                    if (StringUtils.isNotEmpty((String)cmsPath)) {
                        NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)nuxeoController.getResponse(), (PortletContext)nuxeoController.getPortletCtx(), (String)cmsPath);
                        document = documentContext.getDoc();
                        request.setAttribute(DOCUMENT_REQUEST_ATTRIBUTE, (Object)document);
                    }
                }
                catch (NuxeoException e) {
                    if (NuxeoException.ERROR_FORBIDDEN == e.getErrorCode()) break block4;
                    throw new PortletException((Throwable)e);
                }
            }
        }
        return document;
    }
}

