/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.service.generator;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.portlet.PortletException;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.portlet.model.calendar.MonthlyCalendarData;
import org.osivia.services.calendar.portlet.model.calendar.MonthlyCalendarDay;
import org.osivia.services.calendar.portlet.model.calendar.MonthlyCalendarWeek;
import org.osivia.services.calendar.portlet.model.events.DailyCalendarEventsData;
import org.osivia.services.calendar.portlet.model.events.DailyEvent;
import org.osivia.services.calendar.portlet.model.events.Event;
import org.osivia.services.calendar.portlet.model.events.EventsData;
import org.osivia.services.calendar.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.portlet.utils.PeriodTypes;
import org.springframework.stereotype.Service;

@Service(value="monthlyCalendarGenerator")
public class MonthlyCalendarGeneratorImpl
extends CalendarGeneratorImpl {
    public PeriodTypes getPeriodType() throws PortletException {
        return PeriodTypes.MONTH;
    }

    protected CalendarData generateSpecializedCalendarData(PortalControllerContext portalControllerContext) throws PortletException {
        MonthlyCalendarData calendarData = new MonthlyCalendarData();
        PeriodTypes periodType = this.getPeriodType();
        Date selectedDate = this.getSelectedDate(portalControllerContext, periodType);
        Date startDate = this.getStartDate(portalControllerContext, periodType, selectedDate);
        Date endDate = this.getEndDate(portalControllerContext, periodType, selectedDate, startDate);
        calendarData.setHeaders(this.getHeaders(portalControllerContext, startDate));
        calendarData.setWeeks(this.getWeeks(portalControllerContext, selectedDate, startDate, endDate));
        return calendarData;
    }

    protected void updateSpecializedCalendarData(PortalControllerContext portalControllerContext, CalendarData calendarData) {
        MonthlyCalendarData monthlyCalendarData = (MonthlyCalendarData)calendarData;
        Date selectedDate = calendarData.getSelectedDate();
        Date startDate = calendarData.getStartDate();
        Date endDate = calendarData.getEndDate();
        monthlyCalendarData.setHeaders(this.getHeaders(portalControllerContext, startDate));
        monthlyCalendarData.setWeeks(this.getWeeks(portalControllerContext, selectedDate, startDate, endDate));
    }

    private List<String> getHeaders(PortalControllerContext portalControllerContext, Date startDate) {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Calendar calendar = GregorianCalendar.getInstance(locale);
        calendar.setTime(startDate);
        ArrayList<String> headers = new ArrayList<String>(7);
        for (int i = 0; i < 7; ++i) {
            headers.add(calendar.getDisplayName(7, 2, locale));
            calendar.add(5, 1);
        }
        return headers;
    }

    private List<MonthlyCalendarWeek> getWeeks(PortalControllerContext portalControllerContext, Date selectedDate, Date startDate, Date endDate) {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Calendar calendar = GregorianCalendar.getInstance(locale);
        calendar.setTime(startDate);
        int currentMonth = DateUtils.toCalendar((Date)selectedDate).get(2);
        ArrayList<MonthlyCalendarWeek> weeks = new ArrayList<MonthlyCalendarWeek>();
        while (!calendar.getTime().after(endDate)) {
            MonthlyCalendarWeek week = new MonthlyCalendarWeek();
            week.setName(String.valueOf(calendar.get(3)));
            ArrayList<MonthlyCalendarDay> days = new ArrayList<MonthlyCalendarDay>(7);
            week.setDays(days);
            for (int i = 0; i < 7; ++i) {
                MonthlyCalendarDay day = new MonthlyCalendarDay(calendar.getTime());
                day.setName(String.valueOf(calendar.get(5)));
                day.setCurrentMonth(currentMonth == calendar.get(2));
                if (calendar.get(5) == 1) {
                    day.setMonthDisplay(calendar.getDisplayName(2, 1, locale));
                }
                days.add(day);
                calendar.add(5, 1);
            }
            weeks.add(week);
        }
        return weeks;
    }

    protected String getDisplayDate(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", portalControllerContext.getRequest().getLocale());
        return dateFormat.format(calendarData.getSelectedDate());
    }

    protected EventsData generateSpecializedEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData, List<Event> events) throws PortletException {
        Locale locale = portalControllerContext.getRequest().getLocale();
        DateFormat timeFormat = SimpleDateFormat.getTimeInstance(3, locale);
        Calendar startCalendar = GregorianCalendar.getInstance(locale);
        Calendar endCalendar = GregorianCalendar.getInstance(locale);
        TreeMap<String, ArrayList<DailyEvent>> fullDayEvents = new TreeMap<String, ArrayList<DailyEvent>>();
        for (Event event : events) {
            startCalendar.setTime(event.getStartDate());
            endCalendar.setTime(event.getEndDate());
            boolean begin = true;
            while (begin || startCalendar.before(endCalendar)) {
                Date currentDate = DateUtils.truncate((Date)startCalendar.getTime(), (int)5);
                DailyEvent fullDayEvent = new DailyEvent(event, currentDate);
                fullDayEvent.setBegin(begin);
                boolean end = DateUtils.isSameDay((Calendar)startCalendar, (Calendar)endCalendar);
                fullDayEvent.setEnd(end);
                if (begin) {
                    fullDayEvent.setTime(timeFormat.format(event.getStartDate()));
                }
                StringBuilder builder = new StringBuilder();
                builder.append(startCalendar.get(3));
                builder.append(":");
                builder.append(startCalendar.get(5));
                String key = builder.toString();
                ArrayList<DailyEvent> fullDayEventsList = (ArrayList<DailyEvent>)fullDayEvents.get(key);
                if (fullDayEventsList == null) {
                    fullDayEventsList = new ArrayList<DailyEvent>();
                    fullDayEvents.put(key, fullDayEventsList);
                }
                fullDayEventsList.add(fullDayEvent);
                startCalendar.add(5, 1);
                startCalendar = DateUtils.truncate((Calendar)startCalendar, (int)5);
                begin = false;
            }
        }
        DailyCalendarEventsData eventsData = new DailyCalendarEventsData();
        eventsData.setMappedEvents(fullDayEvents);
        return eventsData;
    }
}

