/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.portlet.model.events.DailyEvent;
import org.osivia.services.calendar.portlet.model.events.TimeSlotEvent;
import org.osivia.services.calendar.portlet.service.ICalendarCollisionManager;
import org.osivia.services.calendar.portlet.utils.Collision;
import org.osivia.services.calendar.portlet.utils.CollisionEvent;
import org.springframework.stereotype.Service;

@Service
public class CalendarCollisionManagerImpl
implements ICalendarCollisionManager {
    private static final float TABLE_WIDTH = 100.0f;
    private static final float DAY_MARGIN_WIDTH = 5.0f;
    private static final float WEEK_MARGIN_WIDTH = 1.0f;

    @Override
    public void updateDailyEvents(PortalControllerContext portalControllerContext, List<DailyEvent> events, Date date) {
        List<CollisionEvent> collisionEvents = this.getCollisionEvents(events, date);
        for (CollisionEvent collisionEvent : collisionEvents) {
            TimeSlotEvent event = collisionEvent.getEvent();
            int column = collisionEvent.getColumn();
            int count = collisionEvent.getCollisionsCount();
            float eventWidth = 100.0f / Float.valueOf(count).floatValue();
            StringBuilder builder = new StringBuilder();
            builder.append(Float.valueOf(column - 1).floatValue() * eventWidth);
            builder.append("%");
            event.setLeft(builder.toString());
            builder = new StringBuilder();
            builder.append(eventWidth - 5.0f);
            builder.append("%");
            event.setWidth(builder.toString());
        }
    }

    @Override
    public void updateWeeklyEvents(PortalControllerContext portalControllerContext, List<DailyEvent> events, Date date) {
        Calendar calendar = GregorianCalendar.getInstance(portalControllerContext.getRequest().getLocale());
        calendar.setTime(date);
        calendar.set(7, calendar.getFirstDayOfWeek());
        for (int i = 0; i < 7; ++i) {
            Date weekDay = calendar.getTime();
            ArrayList<DailyEvent> weekDayEvents = new ArrayList<DailyEvent>();
            for (DailyEvent event : events) {
                TimeSlotEvent timeSlotEvent = (TimeSlotEvent)event;
                if (!DateUtils.isSameDay((Date)weekDay, (Date)new Date(timeSlotEvent.getStartTime()))) continue;
                weekDayEvents.add(event);
            }
            List<CollisionEvent> collisionEvents = this.getCollisionEvents(weekDayEvents, weekDay);
            for (CollisionEvent collisionEvent : collisionEvents) {
                TimeSlotEvent event = collisionEvent.getEvent();
                int column = collisionEvent.getColumn();
                int count = collisionEvent.getCollisionsCount();
                float columnWidth = 100.0f / Float.valueOf(7.0f).floatValue();
                float eventWidth = columnWidth / Float.valueOf(count).floatValue();
                float left = columnWidth * Float.valueOf(i).floatValue() + Float.valueOf(column - 1).floatValue() * eventWidth;
                StringBuilder builder = new StringBuilder();
                builder.append(left);
                builder.append("%");
                event.setLeft(builder.toString());
                builder = new StringBuilder();
                builder.append(eventWidth - 1.0f);
                builder.append("%");
                event.setWidth(builder.toString());
            }
            calendar.add(5, 1);
        }
    }

    private List<CollisionEvent> getCollisionEvents(List<DailyEvent> events, Date date) {
        List<Collision> collisions = this.initCollisions(date);
        ArrayList<CollisionEvent> collisionEvents = new ArrayList<CollisionEvent>(events.size());
        for (DailyEvent event : events) {
            TimeSlotEvent timeSlotEvent = (TimeSlotEvent)event;
            long start = timeSlotEvent.getStartTime();
            long end = timeSlotEvent.getEndTime();
            CollisionEvent collisionEvent = new CollisionEvent(timeSlotEvent);
            collisionEvents.add(collisionEvent);
            ArrayList<Collision> collisionsClone = new ArrayList<Collision>(collisions);
            for (Collision collision : collisionsClone) {
                if (collision.getBegin() >= end || collision.getEnd() <= start) continue;
                collisions.remove(collision);
                if (collision.getBegin() < start) {
                    Collision beginCollision = new Collision(collision.getEvents());
                    beginCollision.setBegin(Math.min(collision.getBegin(), start));
                    beginCollision.setEnd(Math.max(collision.getBegin(), start));
                    if (collision.getBegin() > start) {
                        beginCollision.getEvents().add(collisionEvent);
                    }
                    collisions.add(beginCollision);
                }
                Collision innerCollision = new Collision(collision.getEvents());
                innerCollision.setBegin(Math.max(collision.getBegin(), start));
                innerCollision.setEnd(Math.min(collision.getEnd(), end));
                innerCollision.getEvents().add(collisionEvent);
                collisions.add(innerCollision);
                if (collision.getEnd() <= end) continue;
                Collision endCollision = new Collision(collision.getEvents());
                endCollision.setBegin(Math.min(collision.getEnd(), end));
                endCollision.setEnd(Math.max(collision.getEnd(), end));
                if (collision.getEnd() < end) {
                    endCollision.getEvents().add(collisionEvent);
                }
                collisions.add(endCollision);
            }
        }
        Collections.sort(collisions);
        for (Collision collision : collisions) {
            List<CollisionEvent> currentSortedCollisionEvents = collision.getEvents();
            Collections.sort(currentSortedCollisionEvents);
            for (CollisionEvent currentCollisionEvent : currentSortedCollisionEvents) {
                if (currentCollisionEvent.isInitialized()) continue;
                Set<CollisionEvent> currentCollisionEvents = this.getCollisionEvents(collisions, currentCollisionEvent);
                int columnsCount = this.getColumnsCount(collisions, currentCollisionEvent);
                int columnNumber = this.getColumnNumber(currentCollisionEvents, currentCollisionEvent, columnsCount);
                currentCollisionEvent.setColumn(columnNumber);
                currentCollisionEvent.setCollisionsCount(columnsCount);
                currentCollisionEvent.setInitialized(true);
            }
        }
        return collisionEvents;
    }

    private List<Collision> initCollisions(Date date) {
        Collision collision = new Collision();
        long begin = DateUtils.truncate((Date)date, (int)5).getTime();
        long end = begin + 86400000L;
        collision.setBegin(begin);
        collision.setEnd(end);
        ArrayList<Collision> collisions = new ArrayList<Collision>();
        collisions.add(collision);
        return collisions;
    }

    private Set<CollisionEvent> getCollisionEvents(List<Collision> collisions, CollisionEvent collisionEvent) {
        TimeSlotEvent event = collisionEvent.getEvent();
        TreeSet<CollisionEvent> collisionsEvents = new TreeSet<CollisionEvent>();
        for (Collision collision : collisions) {
            if (collision.getBegin() >= event.getEndTime() || collision.getEnd() <= event.getStartTime()) continue;
            collisionsEvents.addAll(collision.getEvents());
        }
        return collisionsEvents;
    }

    private int getColumnsCount(List<Collision> collisions, CollisionEvent currentCollisionEvent) {
        int count = 1;
        for (Collision collision : collisions) {
            if (!collision.getEvents().contains(currentCollisionEvent)) continue;
            count = Math.max(count, collision.getEvents().size());
        }
        return count;
    }

    private int getColumnNumber(Set<CollisionEvent> currentCollisionEvents, CollisionEvent currentCollisionEvent, int columnsCount) {
        TreeSet<Integer> numbers = new TreeSet<Integer>();
        for (int i = 1; i <= columnsCount; ++i) {
            numbers.add(i);
        }
        for (CollisionEvent collisionEvent : currentCollisionEvents) {
            if (!collisionEvent.isInitialized()) continue;
            float eventBegin = Float.valueOf(collisionEvent.getColumn() - 1).floatValue() / Float.valueOf(collisionEvent.getCollisionsCount()).floatValue();
            float eventEnd = Float.valueOf(collisionEvent.getColumn()).floatValue() / Float.valueOf(collisionEvent.getCollisionsCount()).floatValue();
            for (int i = 1; i <= columnsCount; ++i) {
                float columnBegin = Float.valueOf(i - 1).floatValue() / Float.valueOf(columnsCount).floatValue();
                float columnEnd = Float.valueOf(i).floatValue() / Float.valueOf(columnsCount).floatValue();
                if (!(eventBegin < columnEnd) || !(eventEnd > columnBegin)) continue;
                numbers.remove(i);
            }
        }
        return (Integer)numbers.first();
    }
}

