/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.edition.portlet.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.common.service.CalendarServiceImpl;
import org.osivia.services.calendar.edition.portlet.model.CalendarEditionForm;
import org.osivia.services.calendar.edition.portlet.model.CalendarSynchronizationSource;
import org.osivia.services.calendar.edition.portlet.model.Picture;
import org.osivia.services.calendar.edition.portlet.repository.CalendarEditionRepository;
import org.osivia.services.calendar.edition.portlet.service.CalendarEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CalendarEditionServiceImpl
extends CalendarServiceImpl
implements CalendarEditionService {
    private static final String PORTLET_TITLE_KEY_PREFIX = "CALENDAR_PORTLET_TITLE_";
    private static final String CREATION_PORTLET_TITLE_KEY = "CALENDAR_PORTLET_TITLE_CREATION";
    private static final String EDITION_PORTLET_TITLE_KEY = "CALENDAR_PORTLET_TITLE_EDITION";
    private static final String VIGNETTE_TEMPORARY_FILE_PREFIX = "vignette-";
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected CalendarEditionRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;

    protected String getPortletTitle(PortalControllerContext portalControllerContext, boolean creation) throws PortletException {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        String key = creation ? CREATION_PORTLET_TITLE_KEY : EDITION_PORTLET_TITLE_KEY;
        return bundle.getString(key);
    }

    public CalendarEditionForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarEditionOptions options = this.getEditionOptions(portalControllerContext);
        CalendarEditionForm form = (CalendarEditionForm)this.applicationContext.getBean(CalendarEditionForm.class);
        Document document = options.getDocument();
        String title = this.repository.getTitle(portalControllerContext, document);
        form.setTitle(title);
        String description = this.repository.getDescription(portalControllerContext, document);
        form.setDescription(description);
        Picture vignette = this.repository.getVignette(portalControllerContext, document);
        form.setVignette(vignette);
        CalendarColor color = this.getCalendarColor(portalControllerContext, document);
        form.setColor(color);
        List sources = this.repository.getSynchronizationSources(portalControllerContext, document);
        form.setSynchronizationSources(sources);
        return form;
    }

    public void uploadVignette(PortalControllerContext portalControllerContext, CalendarEditionForm form) throws PortletException, IOException {
        MimeType mimeType;
        Picture vignette = form.getVignette();
        vignette.setDeleted(false);
        MultipartFile upload = vignette.getUpload();
        File temporaryFile = vignette.getTemporaryFile();
        if (temporaryFile != null) {
            temporaryFile.delete();
        }
        temporaryFile = File.createTempFile(VIGNETTE_TEMPORARY_FILE_PREFIX, ".tmp");
        temporaryFile.deleteOnExit();
        upload.transferTo(temporaryFile);
        vignette.setTemporaryFile(temporaryFile);
        vignette.setTemporaryFileName(upload.getOriginalFilename());
        try {
            mimeType = new MimeType(upload.getContentType());
        }
        catch (MimeTypeParseException e) {
            mimeType = null;
        }
        vignette.setTemporaryMimeType(mimeType);
    }

    public void deleteVignette(PortalControllerContext portalControllerContext, CalendarEditionForm form) throws PortletException, IOException {
        Picture vignette = form.getVignette();
        vignette.setDeleted(true);
        File temporaryFile = vignette.getTemporaryFile();
        if (temporaryFile != null) {
            temporaryFile.delete();
            vignette.setTemporaryFile(null);
        }
        vignette.setTemporaryFileName(null);
        vignette.setTemporaryMimeType(null);
    }

    public void save(PortalControllerContext portalControllerContext, CalendarEditionOptions options, CalendarEditionForm form) throws PortletException, IOException {
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        this.repository.save(portalControllerContext, options, form);
        String redirectionUrl = this.getRedirectionUrl(portalControllerContext, true);
        response.sendRedirect(redirectionUrl);
    }

    public void cancel(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        String redirectionUrl = this.getRedirectionUrl(portalControllerContext, false);
        response.sendRedirect(redirectionUrl);
    }

    public void addSynchronizationSource(PortalControllerContext portalControllerContext, CalendarEditionForm form) throws PortletException {
        CalendarSynchronizationSource addedSource = form.getAddedSynchronizationSource();
        String sourceId = UUID.randomUUID().toString();
        addedSource.setId(sourceId);
        List sources = form.getSynchronizationSources();
        sources.add(addedSource);
        form.setAddedSynchronizationSource((CalendarSynchronizationSource)this.applicationContext.getBean(CalendarSynchronizationSource.class));
    }

    public void editSynchronizationSource(PortalControllerContext portalControllerContext, CalendarEditionForm form) throws PortletException {
    }

    public void removeSynchronizationSource(PortalControllerContext portalControllerContext, CalendarEditionForm form, String sourceId) throws PortletException {
        List sources = form.getSynchronizationSources();
        CalendarSynchronizationSource source = (CalendarSynchronizationSource)this.applicationContext.getBean(CalendarSynchronizationSource.class);
        source.setId(sourceId);
        sources.remove(source);
    }

    public void vignettePreview(PortalControllerContext portalControllerContext, CalendarEditionForm form) throws PortletException, IOException {
        ResourceResponse response = (ResourceResponse)portalControllerContext.getResponse();
        File temporaryFile = form.getVignette().getTemporaryFile();
        Long size = new Long(temporaryFile.length());
        response.setContentLength(size.intValue());
        String contentType = response.getContentType();
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        response.getCacheControl().setExpirationTime(0);
        FileInputStream inputSteam = new FileInputStream(temporaryFile);
        OutputStream outputStream = response.getPortletOutputStream();
        IOUtils.copy((InputStream)inputSteam, (OutputStream)outputStream);
        outputStream.close();
    }

    public void synchronizationSourceEditionUrl(PortalControllerContext portalControllerContext, CalendarEditionForm form, String sourceId) throws PortletException, IOException {
        String url;
        ResourceResponse response = (ResourceResponse)portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        boolean creation = StringUtils.isEmpty((String)sourceId);
        String title = creation ? bundle.getString("CALENDAR_SYNCHRONIZATION_SOURCE_ADD_TITLE") : bundle.getString("CALENDAR_SYNCHRONIZATION_SOURCE_EDIT_TITLE");
        CalendarSynchronizationSource source = null;
        if (!creation && CollectionUtils.isNotEmpty((Collection)form.getSynchronizationSources())) {
            for (CalendarSynchronizationSource synchronizationSource : form.getSynchronizationSources()) {
                if (!StringUtils.equals((String)sourceId, (String)synchronizationSource.getId())) continue;
                source = synchronizationSource;
                break;
            }
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!creation) {
            properties.put("osivia.calendar.synchronizationSource.id", sourceId);
        }
        if (source != null) {
            properties.put("osivia.calendar.synchronizationSource.url", URLEncoder.encode(URLEncoder.encode(source.getUrl(), "UTF-8"), "UTF-8"));
            if (source.getColor() != null) {
                properties.put("osivia.calendar.synchronizationSource.color", source.getColor().getId());
            }
            properties.put("osivia.calendar.synchronizationSource.displayName", source.getDisplayName());
        }
        try {
            url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-calendar-synchronization-edition-instance", properties, PortalUrlType.MODAL);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        JSONObject object = new JSONObject();
        object.put((Object)"title", (Object)title);
        object.put((Object)"url", (Object)url);
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(object.toString());
        printWriter.close();
    }

    private String getRedirectionUrl(PortalControllerContext portalControllerContext, boolean refresh) throws PortletException {
        return this.portalUrlFactory.getBackURL(portalControllerContext, false, refresh);
    }
}

