/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.repository.CalendarRepositoryImpl;
import org.osivia.services.calendar.common.repository.command.EventRemoveCommand;
import org.osivia.services.calendar.edition.portlet.model.CalendarSynchronizationSource;
import org.osivia.services.calendar.view.portlet.model.CalendarEditionMode;
import org.osivia.services.calendar.view.portlet.model.CalendarOptions;
import org.osivia.services.calendar.view.portlet.model.CalendarViewForm;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventKey;
import org.osivia.services.calendar.view.portlet.model.events.EventToSync;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.repository.command.EventEditionCommand;
import org.osivia.services.calendar.view.portlet.repository.command.EventGetCommand;
import org.osivia.services.calendar.view.portlet.repository.command.EventListCommand;
import org.osivia.services.calendar.view.portlet.repository.command.SynchronizationCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class CalendarViewRepositoryImpl
extends CalendarRepositoryImpl
implements CalendarViewRepository {
    private static final String DOCUMENT_REQUEST_ATTRIBUTE = "osivia.calendar.document";
    @Autowired
    protected ApplicationContext applicationContext;

    public CalendarOptions getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        CalendarOptions configuration = (CalendarOptions)this.applicationContext.getBean(CalendarOptions.class);
        configuration.setCmsPath(window.getProperty("osivia.calendar.cmsPath"));
        configuration.setPeriodTypeName(window.getProperty("osivia.calendar.defaultView"));
        configuration.setCompactView(BooleanUtils.toBoolean((String)window.getProperty("osivia.calendar.compactView")));
        configuration.setReadOnly(BooleanUtils.toBoolean((String)window.getProperty("osivia.calendar.readOnly")));
        configuration.setIntegration(BooleanUtils.toBoolean((String)window.getProperty("osivia.calendar.integration")));
        return configuration;
    }

    public String getCalendarPath(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        return this.getCMSPath(nuxeoController);
    }

    public String getTitle(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        Document document = this.getDocument(nuxeoController);
        String title = null;
        if (document != null) {
            title = document.getTitle();
        }
        return title;
    }

    public List<CalendarSynchronizationSource> getSynchronizationSources(PortalControllerContext portalControllerContext) throws PortletException {
        PropertyList propertyList;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        Document document = this.getDocument(nuxeoController);
        ArrayList<CalendarSynchronizationSource> listSource = new ArrayList<CalendarSynchronizationSource>();
        if (document != null && (propertyList = (PropertyList)document.getProperties().get("cal:sources")) != null) {
            for (int i = 0; i < propertyList.size(); ++i) {
                PropertyMap map = propertyList.getMap(i);
                CalendarSynchronizationSource source = new CalendarSynchronizationSource();
                source.setColor(map.getString("color") == null ? null : CalendarColor.fromId((String)map.getString("color")));
                source.setDisplayName(map.getString("displayName"));
                source.setUrl(map.getString("url"));
                source.setId(map.getString("sourceId"));
                listSource.add(source);
            }
        }
        return listSource;
    }

    public String getColorIdAgenda(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        Document document = this.getDocument(nuxeoController);
        if (document != null) {
            return document.getString("cal:color");
        }
        return "";
    }

    public void saveConfiguration(PortalControllerContext portalControllerContext, CalendarOptions configuration) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        window.setProperty("osivia.calendar.cmsPath", configuration.getCmsPath());
        window.setProperty("osivia.calendar.defaultView", configuration.getPeriodTypeName());
        window.setProperty("osivia.calendar.compactView", BooleanUtils.toStringTrueFalse((boolean)configuration.isCompactView()));
        window.setProperty("osivia.calendar.readOnly", BooleanUtils.toStringTrueFalse((boolean)configuration.isReadOnly()));
        window.setProperty("osivia.calendar.integration", BooleanUtils.toStringTrueFalse((boolean)configuration.isIntegration()));
    }

    public List<Event> getEvents(PortalControllerContext portalControllerContext, Date start, Date end) throws PortletException {
        ArrayList<Event> events;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String cmsPath = this.getCMSPath(nuxeoController);
        if (StringUtils.isEmpty((String)cmsPath)) {
            events = null;
        } else {
            List listSource = this.getSynchronizationSources(portalControllerContext);
            EventListCommand nuxeoCommand = new EventListCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, cmsPath, start, end, listSource);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
            events = new ArrayList<Event>(documents.size());
            for (Document document : documents) {
                if (document.getDate("vevent:dtstart") == null || document.getDate("vevent:dtend") == null) continue;
                Event event = this.fillEvent(document, nuxeoController);
                events.add(event);
            }
        }
        return events;
    }

    public Event getEvent(PortalControllerContext portalControllerContext, String docid) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String cmsPath = this.getCMSPath(nuxeoController);
        EventGetCommand nuxeoCommand = new EventGetCommand(cmsPath, docid);
        Document document = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
        return this.fillEvent(document, nuxeoController);
    }

    protected Event fillEvent(Document document, NuxeoController nuxeoController) {
        String id = document.getId();
        String title = document.getTitle();
        Date startDate = document.getDate("vevent:dtstart");
        Date endDate = document.getDate("vevent:dtend");
        String bckgcolor = document.getString("vevent:color");
        boolean allDay = BooleanUtils.isTrue((Boolean)document.getProperties().getBoolean("vevent:allDay"));
        String viewURL = nuxeoController.getLink(document).getUrl();
        String idEventSrc = document.getString("sync:idSource");
        String idParentSrc = document.getString("sync:idParentSource");
        Event event = (Event)this.applicationContext.getBean(Event.class, new Object[]{id, title, startDate, endDate, allDay, bckgcolor, viewURL, idEventSrc, idParentSrc});
        Date lastModified = document.getDate("dc:modified");
        event.setLastModified(lastModified);
        String location = document.getString("vevent:location");
        event.setLocation(location);
        String content = document.getString("note:note");
        if (StringUtils.isNotBlank((String)content)) {
            String description = nuxeoController.transformHTMLContent(content);
            event.setDescription(description);
        }
        return event;
    }

    public void definePortletUri(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        NuxeoController nuxeoController = new NuxeoController(request, portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String path = this.getCMSPath(nuxeoController);
        request.setAttribute("osivia.cms.uri", (Object)path);
    }

    protected String getCMSPath(NuxeoController nuxeoController) throws PortletException {
        String cmsPath;
        CalendarOptions configuration = this.getConfiguration(nuxeoController.getPortalCtx());
        if (StringUtils.isNotBlank((String)configuration.getCmsPath())) {
            cmsPath = configuration.getCmsPath();
        } else {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
            cmsPath = window.getPageProperty("osivia.cms.basePath");
        }
        return nuxeoController.getComputedPath(cmsPath);
    }

    protected Document getDocument(NuxeoController nuxeoController) throws PortletException {
        Document document;
        block4: {
            PortletRequest request = nuxeoController.getRequest();
            document = (Document)request.getAttribute(DOCUMENT_REQUEST_ATTRIBUTE);
            if (document == null) {
                try {
                    String cmsPath = this.getCMSPath(nuxeoController);
                    if (StringUtils.isNotEmpty((String)cmsPath)) {
                        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(cmsPath);
                        document = documentContext.getDocument();
                        request.setAttribute(DOCUMENT_REQUEST_ATTRIBUTE, (Object)document);
                    }
                }
                catch (NuxeoException e) {
                    if (1 == e.getErrorCode()) break block4;
                    throw new PortletException((Throwable)e);
                }
            }
        }
        return document;
    }

    public void save(PortalControllerContext portalControllerContext, CalendarViewForm form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String cmsPath = this.getCMSPath(nuxeoController);
        form.setParentPath(cmsPath);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(EventEditionCommand.class, new Object[]{form});
        Document document = (Document)nuxeoController.executeNuxeoCommand(command);
        if (CalendarEditionMode.EDITION.equals((Object)form.getMode())) {
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(document.getPath());
            documentContext.reload();
            document = documentContext.getDocument();
        }
        form.setDocument((DocRef)document);
    }

    public boolean isEventEditable(PortalControllerContext portalControllerContext, String docid) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        NuxeoController nuxeoController = new NuxeoController(request, portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
        return documentContext.getPermissions().isEditable();
    }

    public void remove(PortalControllerContext portalControllerContext, CalendarViewForm form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        EventRemoveCommand command = new EventRemoveCommand(form.getDocId());
        nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
    }

    public void synchronize(PortalControllerContext portalControllerContext, Map<EventKey, EventToSync> map) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String cmsPath = this.getCMSPath(nuxeoController);
        String parentPath = nuxeoController.getContentPath();
        SynchronizationCommand nuxeoCommand = new SynchronizationCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, cmsPath, parentPath, map);
        nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
    }
}

