/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.event.edition.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import java.beans.PropertyEditor;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.model.CalendarCommonEventForm;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.event.edition.portlet.model.validation.CalendarEventEditionFormValidator;
import org.osivia.services.calendar.event.edition.portlet.service.CalendarEventEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form"})
public class CalendarEventEditionController
extends CMSPortlet
implements PortletConfigAware {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private CalendarEventEditionService service;
    @Autowired
    private CalendarEventEditionFormValidator formValidator;
    private final Log log = LogFactory.getLog(this.getClass());

    public void setPortletConfig(PortletConfig portletConfig) {
        try {
            super.init(portletConfig);
        }
        catch (PortletException e) {
            this.log.error((Object)e);
        }
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="options") CalendarEditionOptions options) throws PortletException {
        String portletTitle = options.getPortletTitle();
        response.setTitle(portletTitle);
        return "view";
    }

    @ActionMapping(name="save", params={"upload-attachments"})
    public void uploadAttachments(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") CalendarCommonEventForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.uploadAttachments(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"delete-attachment"})
    public void deleteAttachment(ActionRequest request, ActionResponse response, @RequestParam(value="delete-attachment") Integer index, @ModelAttribute(value="form") CalendarCommonEventForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deleteAttachment(portalControllerContext, form, index.intValue());
    }

    @ActionMapping(name="save", params={"restore-attachment"})
    public void restoreAttachment(ActionRequest request, ActionResponse response, @RequestParam(value="restore-attachment") Integer index, @ModelAttribute(value="form") CalendarCommonEventForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.restoreAttachment(portalControllerContext, form, index.intValue());
    }

    @ActionMapping(name="save", params={"save"})
    public void save(ActionRequest request, ActionResponse response, @ModelAttribute(value="options") CalendarEditionOptions options, @ModelAttribute(value="form") @Validated CalendarCommonEventForm form, BindingResult result, SessionStatus status) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            this.service.save(portalControllerContext, options, form);
            status.setComplete();
        }
    }

    @ActionMapping(value="cancel")
    public void cancel(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.cancel(portalControllerContext);
    }

    @ResourceMapping(value="editor")
    public void getEditor(ResourceRequest request, ResourceResponse response, @RequestParam(name="editorId") String editorId) throws PortletException, IOException {
        super.serveResourceEditor(request, response, editorId);
    }

    @ModelAttribute(value="options")
    public CalendarEditionOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getEditionOptions(portalControllerContext);
    }

    @ModelAttribute(value="form")
    public CalendarCommonEventForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.setDisallowedFields(new String[]{"calendarColor", "startDate", "endDate"});
        binder.addValidators(new Validator[]{this.formValidator});
        binder.registerCustomEditor(CalendarColor.class, (PropertyEditor)this.service.getCalendarColorPropertyEditor());
    }

    @ExceptionHandler(value={MultipartException.class})
    String handleFileException(Throwable ex, RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String uploadMaxSize = StringUtils.defaultIfBlank((String)System.getProperty("osivia.agenda.max.upload.size"), (String)"10");
        request.setAttribute("uploadMaxSize", (Object)uploadMaxSize.toString());
        return "upload-error";
    }
}

