/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.service.generator;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.portlet.PortletException;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.DailyEvent;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.model.events.PlanningCalendarEventHeader;
import org.osivia.services.calendar.view.portlet.model.events.PlanningCalendarEventsData;
import org.osivia.services.calendar.view.portlet.service.CalendarViewService;
import org.osivia.services.calendar.view.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planningCalendarGenerator")
public class PlanningCalendarGeneratorImpl
extends CalendarGeneratorImpl {
    @Autowired
    private CalendarViewService calendarService;

    public PlanningCalendarGeneratorImpl() {
        this.periodType = PeriodTypes.PLANNING;
    }

    @Override
    protected EventsData generateSpecializedEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData, List<Event> events) throws PortletException {
        boolean compact = this.calendarService.isCompact(portalControllerContext);
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.getBundleFactory().getBundle(locale);
        DateFormat timeFormat = SimpleDateFormat.getTimeInstance(3, locale);
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        Calendar startCalendar = GregorianCalendar.getInstance(locale);
        startCalendar.setTimeZone(timeZone);
        Calendar endCalendar = GregorianCalendar.getInstance(locale);
        endCalendar.setTimeZone(timeZone);
        SortedMap<Object, ArrayList<DailyEvent>> planningEvents = new TreeMap();
        for (Event event : events) {
            startCalendar.setTime(event.getStartDate());
            endCalendar.setTime(event.getEndDate());
            boolean begin = true;
            while (begin || startCalendar.before(endCalendar)) {
                Date currentDate = DateUtils.truncate((Date)startCalendar.getTime(), (int)5);
                if (!currentDate.before(calendarData.getStartDate())) {
                    DailyEvent planningEvent = new DailyEvent(event, currentDate);
                    planningEvent.setBegin(begin);
                    boolean end = DateUtils.isSameDay((Calendar)startCalendar, (Calendar)endCalendar);
                    planningEvent.setEnd(end);
                    StringBuilder builder = new StringBuilder();
                    if (event.isAllDay() || !begin && !end) {
                        builder.append(bundle.getString("CALENDAR_EVENT_ALL_DAY"));
                    } else {
                        if (begin) {
                            builder.append(timeFormat.format(event.getStartDate()));
                            if (end) {
                                builder.append(" - ");
                            }
                        }
                        if (end) {
                            builder.append(timeFormat.format(event.getEndDate()));
                        }
                    }
                    planningEvent.setTime(builder.toString());
                    PlanningCalendarEventHeader header = new PlanningCalendarEventHeader(startCalendar.getTime());
                    header.setDayOfMonth(String.valueOf(startCalendar.get(5)));
                    header.setDayOfWeek(startCalendar.getDisplayName(7, 2, locale));
                    builder = new StringBuilder();
                    builder.append(startCalendar.getDisplayName(2, 2, locale));
                    builder.append(" ");
                    builder.append(startCalendar.get(1));
                    header.setMonth(builder.toString());
                    ArrayList<DailyEvent> dailyEvents = (ArrayList<DailyEvent>)planningEvents.get(header);
                    if (dailyEvents == null) {
                        dailyEvents = new ArrayList<DailyEvent>();
                        planningEvents.put(header, dailyEvents);
                    }
                    dailyEvents.add(planningEvent);
                }
                startCalendar.add(5, 1);
                startCalendar = DateUtils.truncate((Calendar)startCalendar, (int)5);
                begin = false;
            }
        }
        PlanningCalendarEventsData eventsData = new PlanningCalendarEventsData();
        if (compact && planningEvents.size() > 5) {
            Set keySet = planningEvents.keySet();
            PlanningCalendarEventHeader[] keys = keySet.toArray(new PlanningCalendarEventHeader[keySet.size()]);
            PlanningCalendarEventHeader key = keys[5];
            planningEvents = planningEvents.headMap(key);
            PlanningCalendarEventHeader lastKey = (PlanningCalendarEventHeader)planningEvents.lastKey();
            eventsData.setLastDate(lastKey.getDate());
        }
        eventsData.setMappedEvents(planningEvents);
        return eventsData;
    }
}

