/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.common.service;

import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.common.model.CalendarOptions;
import org.osivia.services.calendar.common.repository.CalendarRepository;
import org.osivia.services.calendar.common.service.CalendarService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="common-service")
public class CalendarServiceImpl
implements CalendarService {
    protected static final String TEMPORARY_FILE_SUFFIX = ".tmp";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="common-repository")
    private CalendarRepository repository;

    public CalendarOptions getOptions(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarOptions options = (CalendarOptions)this.applicationContext.getBean("options", CalendarOptions.class);
        if (!options.isLoaded()) {
            options.setLoaded(true);
        }
        return options;
    }

    public CalendarEditionOptions getEditionOptions(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarEditionOptions options = (CalendarEditionOptions)this.applicationContext.getBean("edition-options", CalendarEditionOptions.class);
        if (!options.isLoaded()) {
            PortletRequest request = portalControllerContext.getRequest();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            boolean creation = BooleanUtils.toBoolean((String)window.getProperty("osivia.calendar.creation"));
            options.setCreation(creation);
            Document document = this.repository.getCurrentDocument(portalControllerContext);
            if (creation) {
                String parentPath = document.getPath();
                options.setParentPath(parentPath);
            } else {
                options.setDocument(document);
            }
            String portletTitle = this.getPortletTitle(portalControllerContext, creation);
            options.setPortletTitle(portletTitle);
            options.setLoaded(true);
        }
        return options;
    }

    protected String getPortletTitle(PortalControllerContext portalControllerContext, boolean creation) throws PortletException {
        return null;
    }
}

