/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.event.edition.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.services.calendar.common.model.Attachment;
import org.osivia.services.calendar.common.model.Attachments;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.common.model.CalendarEventDates;
import org.osivia.services.calendar.common.model.ICalendarColor;
import org.osivia.services.calendar.common.service.CalendarServiceImpl;
import org.osivia.services.calendar.event.edition.portlet.model.CalendarEventEditionForm;
import org.osivia.services.calendar.event.edition.portlet.repository.CalendarEventEditionRepository;
import org.osivia.services.calendar.event.edition.portlet.service.CalendarEventEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CalendarEventEditionServiceImpl
extends CalendarServiceImpl
implements CalendarEventEditionService {
    private static final String PORTLET_TITLE_KEY_PREFIX = "CALENDAR_EVENT_PORTLET_TITLE_";
    private static final String CREATION_PORTLET_TITLE_KEY = "CALENDAR_EVENT_PORTLET_TITLE_CREATION";
    private static final String EDITION_PORTLET_TITLE_KEY = "CALENDAR_EVENT_PORTLET_TITLE_EDITION";
    private static final String DATE_FORMAT_SEPARATOR = " ";
    private static final String ATTACHMENT_TEMPORARY_FILE_PREFIX = "attachment-";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CalendarEventEditionRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private DocumentDAO dao;
    private final Log log = LogFactory.getLog(this.getClass());
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private final DateFormat dateTimeFormat;

    public CalendarEventEditionServiceImpl() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.dateTimeFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    }

    protected String getPortletTitle(PortalControllerContext portalControllerContext, boolean creation) throws PortletException {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        String key = creation ? CREATION_PORTLET_TITLE_KEY : EDITION_PORTLET_TITLE_KEY;
        return bundle.getString(key);
    }

    public CalendarEventEditionForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarEditionOptions options = this.getEditionOptions(portalControllerContext);
        CalendarEventEditionForm form = (CalendarEventEditionForm)this.applicationContext.getBean(CalendarEventEditionForm.class);
        Document document = options.getDocument();
        CalendarColor calendarColor = this.repository.getCalendarColor(portalControllerContext, options);
        form.setCalendarColor(calendarColor);
        String title = this.repository.getTitle(portalControllerContext, document);
        form.setTitle(title);
        boolean allDay = this.repository.isAllDay(portalControllerContext, document);
        form.setAllDay(allDay);
        CalendarEventDates dates = this.repository.getDates(portalControllerContext, document, allDay);
        form.setDates(dates);
        this.updateFormDates(form);
        String location = this.repository.getLocation(portalControllerContext, document);
        form.setLocation(location);
        ICalendarColor color = this.repository.getColor(portalControllerContext, document, calendarColor);
        form.setColor(color);
        String description = this.repository.getDescription(portalControllerContext, document);
        form.setDescription(description);
        Attachments attachments = this.repository.getAttachments(portalControllerContext, document);
        form.setAttachments(attachments);
        return form;
    }

    public void uploadAttachments(PortalControllerContext portalControllerContext, CalendarEventEditionForm form) throws PortletException, IOException {
        Attachments attachments = form.getAttachments();
        ArrayList<Attachment> files = attachments.getFiles();
        if (files == null) {
            files = new ArrayList<Attachment>();
            attachments.setFiles(files);
        }
        for (MultipartFile multipartFile : attachments.getUpload()) {
            MimeType mimeType;
            Attachment file = (Attachment)this.applicationContext.getBean(Attachment.class);
            File temporaryFile = file.getTemporaryFile();
            if (temporaryFile != null) {
                temporaryFile.delete();
            }
            temporaryFile = File.createTempFile(ATTACHMENT_TEMPORARY_FILE_PREFIX, ".tmp");
            temporaryFile.deleteOnExit();
            multipartFile.transferTo(temporaryFile);
            file.setTemporaryFile(temporaryFile);
            file.setTemporaryFileName(multipartFile.getOriginalFilename());
            try {
                mimeType = new MimeType(multipartFile.getContentType());
            }
            catch (MimeTypeParseException e) {
                mimeType = null;
            }
            file.setTemporaryMimeType(mimeType);
            String icon = this.dao.getIcon(mimeType);
            file.setIcon(icon);
            files.add(file);
        }
    }

    public void deleteAttachment(PortalControllerContext portalControllerContext, CalendarEventEditionForm form, int index) throws PortletException, IOException {
        List files = form.getAttachments().getFiles();
        Attachment file = (Attachment)files.get(index);
        file.setDeleted(true);
    }

    public void restoreAttachment(PortalControllerContext portalControllerContext, CalendarEventEditionForm form, int index) throws PortletException, IOException {
        List files = form.getAttachments().getFiles();
        Attachment file = (Attachment)files.get(index);
        file.setDeleted(false);
    }

    public void save(PortalControllerContext portalControllerContext, CalendarEditionOptions options, CalendarEventEditionForm form) throws PortletException, IOException {
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        this.updateFormDates(form);
        this.repository.save(portalControllerContext, options, form);
        String redirectionUrl = this.getRedirectionUrl(portalControllerContext, true);
        response.sendRedirect(redirectionUrl);
    }

    public void cancel(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        String redirectionUrl = this.getRedirectionUrl(portalControllerContext, false);
        response.sendRedirect(redirectionUrl);
    }

    private void updateFormDates(CalendarEventEditionForm form) {
        CalendarEventDates dates = form.getDates();
        try {
            Date endDate;
            Date startDate = form.isAllDay() ? this.parseDate(dates.getStartDate()) : this.parseDateTime(dates.getStartDate(), dates.getStartTime());
            form.setStartDate(startDate);
            if (form.isAllDay()) {
                endDate = this.parseDate(dates.getEndDate());
                endDate = DateUtils.addDays((Date)endDate, (int)1);
            } else {
                endDate = this.parseDateTime(dates.getEndDate(), dates.getEndTime());
            }
            form.setEndDate(endDate);
        }
        catch (ParseException e) {
            this.log.error((Object)"Error when parsing event dates", (Throwable)e);
        }
    }

    private Date parseDate(String date) throws ParseException {
        StringBuilder source = new StringBuilder();
        source.append(StringUtils.trimToEmpty((String)date));
        return this.dateFormat.parse(source.toString());
    }

    private Date parseDateTime(String date, String time) throws ParseException {
        StringBuilder source = new StringBuilder();
        source.append(StringUtils.trimToEmpty((String)date));
        source.append(DATE_FORMAT_SEPARATOR);
        source.append(StringUtils.trimToEmpty((String)time));
        return this.dateTimeFormat.parse(source.toString());
    }

    private String getRedirectionUrl(PortalControllerContext portalControllerContext, boolean refresh) throws PortletException {
        return this.portalUrlFactory.getBackURL(portalControllerContext, false, refresh);
    }
}

