/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.document.creation.portlet.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.InputStream;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.StreamBlob;

public class UploadFileCommand
implements INuxeoCommand {
    private final InputStream inputStream;
    private final String filename;
    private final String mimeType;
    private final String parentId;

    public UploadFileCommand(InputStream inputStream, String filename, String mimeType, String parentId) {
        this.inputStream = inputStream;
        this.filename = filename;
        this.mimeType = mimeType;
        this.parentId = parentId;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StreamBlob blob = new StreamBlob(this.inputStream, this.filename, this.mimeType);
        OperationRequest operationRequest = nuxeoSession.newRequest("FileManager.Import").setInput((OperationInput)blob);
        operationRequest.setContextProperty("currentDocument", (Object)this.parentId);
        return operationRequest.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" : ");
        builder.append(this.parentId);
        builder.append(" : ");
        builder.append(this.filename);
        builder.append(" : ");
        builder.append(this.inputStream);
        builder.append(" : ");
        builder.append(System.currentTimeMillis());
        return builder.toString();
    }
}

