/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CheckTitleAvailabilityCommand
implements INuxeoCommand {
    private final String parentId;
    private final String title;

    public CheckTitleAvailabilityCommand(String parentId, String title) {
        this.parentId = parentId;
        this.title = title;
    }

    public Boolean execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:parentId = '").append(this.parentId).append("' ");
        clause.append("AND dc:title ILIKE '").append(StringUtils.replace((String)this.title, (String)"'", (String)"\\'")).append("' ");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        Documents results = (Documents)request.execute();
        return results.isEmpty();
    }

    public String getId() {
        return null;
    }
}

