/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.portlet.PortletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.edition.portlet.model.FileEditionForm;
import org.osivia.services.edition.portlet.repository.FileEditionRepositoryImpl;
import org.osivia.services.edition.portlet.repository.command.ImportZipCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;

@Repository
public class ZipExtractionRepositoryImpl
extends FileEditionRepositoryImpl {
    private static final String BINARY_PROPERTY = "file:content";
    private final Log log = LogFactory.getLog((String)"org.osivia.collaboration");
    @Value(value="#{systemProperties['osivia.filebrowser.zip.uploadsizelimit'] ?: null}")
    private String zipSizeLimit;
    @Value(value="#{systemProperties['osivia.filebrowser.zip.uploadweightlimit'] ?: null}")
    private String zipWeightLimit;
    @Autowired
    private ApplicationContext applicationContext;

    public boolean matches(String documentType, boolean creation) {
        return false;
    }

    public void customizeValidation(FileEditionForm form, Errors errors) {
        if (form.getTemporaryFile() == null) {
            errors.rejectValue("upload", "NotEmpty");
        } else {
            String originalFilename = form.getTemporaryFileName();
            if (!StringUtils.endsWithIgnoreCase((String)originalFilename, (String)".zip")) {
                errors.rejectValue("upload", "InvalidFileType", null);
            } else {
                try {
                    this.checkLimits(form, errors);
                }
                catch (IOException e) {
                    errors.rejectValue("upload", "InvalidFileType", null);
                }
            }
        }
    }

    protected Document create(NuxeoController nuxeoController, String parentPath, String type, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException {
        List<Blob> blobs = binaries.get(BINARY_PROPERTY);
        if (CollectionUtils.isEmpty(blobs)) {
            throw new PortletException("Empty file");
        }
        ImportZipCommand command = (ImportZipCommand)this.applicationContext.getBean(ImportZipCommand.class);
        command.setPath(parentPath);
        command.setBinary(blobs.get(0));
        return (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
    }

    private void checkLimits(FileEditionForm form, Errors errors) throws IOException {
        long startTime = new Date().getTime();
        int sizeLimit = 0;
        long weightLimit = 0L;
        if (this.zipSizeLimit != null) {
            sizeLimit = Integer.parseInt(this.zipSizeLimit.trim());
        }
        if (this.zipWeightLimit != null) {
            weightLimit = NumberUtils.toLong((String)this.zipWeightLimit.trim()) * 0x100000L;
        }
        int totalEntries = 0;
        File f = form.getTemporaryFile();
        long totalWeight = f.length();
        ZipFile zipFile = new ZipFile(f);
        totalEntries += zipFile.size();
        boolean nuxeoArchive = false;
        Enumeration<? extends ZipEntry> enu = zipFile.entries();
        while (enu.hasMoreElements()) {
            ZipEntry zipEntry = enu.nextElement();
            if (!zipEntry.getName().equals(".nuxeo-archive")) continue;
            nuxeoArchive = true;
            break;
        }
        zipFile.close();
        if (nuxeoArchive) {
            this.logWarn("W01", form.getRemoteUser(), startTime, "D\u00e9p\u00f4t d'un fichier zip nuxeo archive");
            errors.rejectValue("upload", "InvalidZipNuxeoArchive", null);
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
        long s = totalWeight / 0x100000L;
        long l = weightLimit / 0x100000L;
        if (sizeLimit > 0 && totalEntries > sizeLimit) {
            this.logWarn("W02", form.getRemoteUser(), startTime, "D\u00e9p\u00f4t d'un fichier zip contenant trop d'entr\u00e9es. " + totalEntries + " \u00e9l\u00e9ments et " + s + "Mo (limites " + sizeLimit + " et " + l + "Mo)");
            errors.rejectValue("upload", "InvalidZipTooManyEntries", (Object[])new String[]{Integer.toString(totalEntries), Integer.toString(sizeLimit)}, null);
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
        if (weightLimit > 0L && totalWeight > weightLimit) {
            this.logWarn("W03", form.getRemoteUser(), startTime, "D\u00e9p\u00f4t d'un fichier zip trop volumineux. " + totalEntries + " \u00e9l\u00e9ments et " + s + "Mo (limites " + sizeLimit + " et " + l + "Mo)");
            errors.rejectValue("upload", "InvalidZipTooBig", (Object[])new String[]{Long.toString(s), Long.toString(l)}, null);
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
        this.log("I02", form.getRemoteUser(), startTime, "D\u00e9p\u00f4t d'un fichier zip contenant " + totalEntries + " \u00e9l\u00e9ments et " + s + "Mo (limites " + sizeLimit + " et " + l + "Mo)");
    }

    private void log(String code, String owner, long startTime, String message) {
        long stopTime = System.currentTimeMillis();
        long elapsedTime = stopTime - startTime;
        this.log.info((Object)(code + " " + owner + " FileBrowserService " + elapsedTime + " " + message));
    }

    private void logWarn(String code, String owner, long startTime, String message) {
        long stopTime = System.currentTimeMillis();
        long elapsedTime = stopTime - startTime;
        this.log.warn((Object)(code + " " + owner + " FileBrowserService " + elapsedTime + " " + message));
    }
}

