/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.edition.portlet.model.AbstractDocumentEditionForm;
import org.osivia.services.edition.portlet.model.DocumentEditionWindowProperties;
import org.osivia.services.edition.portlet.repository.DocumentEditionRepository;
import org.osivia.services.edition.portlet.repository.ZipExtractionRepositoryImpl;
import org.osivia.services.edition.portlet.service.DocumentEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;

@Service
public class DocumentEditionServiceImpl
implements DocumentEditionService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;

    public DocumentEditionWindowProperties getWindowProperties(PortalControllerContext portalControllerContext) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        DocumentEditionWindowProperties properties = (DocumentEditionWindowProperties)this.applicationContext.getBean(DocumentEditionWindowProperties.class);
        String documentPath = window.getProperty("osivia.document.edition.path");
        properties.setDocumentPath(documentPath);
        String parentDocumentPath = window.getProperty("osivia.document.edition.parent-path");
        properties.setParentDocumentPath(parentDocumentPath);
        String documentType = window.getProperty("osivia.document.edition.document-type");
        properties.setDocumentType(documentType);
        String extractArchive = window.getProperty("osivia.document.edition.extract-archive");
        properties.setExtractArchive(BooleanUtils.toBoolean((String)extractArchive));
        return properties;
    }

    public AbstractDocumentEditionForm getForm(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        DocumentEditionWindowProperties windowProperties = this.getWindowProperties(portalControllerContext);
        if (StringUtils.isEmpty((String)windowProperties.getDocumentPath()) && (StringUtils.isEmpty((String)windowProperties.getParentDocumentPath()) || StringUtils.isEmpty((String)windowProperties.getDocumentType()))) {
            throw new PortletException("Invalid window properties.");
        }
        String name = this.getRepositoryName(portalControllerContext, windowProperties);
        if (StringUtils.isEmpty((String)name)) {
            throw new PortletException("Unable to find portlet repository name.");
        }
        DocumentEditionRepository repository = this.getRepository(name);
        AbstractDocumentEditionForm form = repository.getForm(portalControllerContext, windowProperties);
        form.setWindowProperties(windowProperties);
        form.setName(name);
        String path = windowProperties.getDocumentPath();
        form.setPath(path);
        boolean creation = StringUtils.isEmpty((String)path);
        form.setCreation(creation);
        form.setRemoteUser(portalControllerContext.getRequest().getRemoteUser());
        return form;
    }

    public DocumentEditionRepository<?> getRepository(String name) {
        return (DocumentEditionRepository)this.applicationContext.getBean(name, DocumentEditionRepository.class);
    }

    public String getViewPath(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        PortletRequest request = portalControllerContext.getRequest();
        RenderResponse response = (RenderResponse)portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        AbstractDocumentEditionForm form = this.getForm(portalControllerContext);
        String title = form.getWindowProperties().isExtractArchive() ? bundle.getString("DOCUMENT_EDITION_TITLE_IMPORT") : (form.isCreation() ? bundle.getString("DOCUMENT_EDITION_TITLE_CREATE") : bundle.getString("DOCUMENT_EDITION_TITLE_EDIT"));
        response.setTitle(title);
        DocumentEditionRepository repository = this.getRepository(form.getName());
        return repository.getViewPath(portalControllerContext);
    }

    public void upload(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        DocumentEditionRepository repository = this.getRepository(form.getName());
        repository.upload(portalControllerContext, form);
    }

    public void restore(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        DocumentEditionRepository repository = this.getRepository(form.getName());
        repository.restore(portalControllerContext, form);
    }

    public void validate(AbstractDocumentEditionForm form, Errors errors) {
        DocumentEditionRepository repository = this.getRepository(form.getName());
        repository.validate(form, errors);
    }

    public void save(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortletRequest request = portalControllerContext.getRequest();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        DocumentEditionRepository repository = this.getRepository(form.getName());
        repository.save(portalControllerContext, form);
        String message = form.isCreation() ? bundle.getString("DOCUMENT_EDITION_MESSAGE_CREATION_SUCCESS") : bundle.getString("DOCUMENT_EDITION_MESSAGE_EDITION_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        this.redirect(portalControllerContext);
    }

    public void cancel(PortalControllerContext portalControllerContext) throws IOException {
        this.redirect(portalControllerContext);
    }

    private void redirect(PortalControllerContext portalControllerContext) throws IOException {
        PortletResponse portletResponse = portalControllerContext.getResponse();
        if (portletResponse instanceof ActionResponse) {
            ActionResponse actionResponse = (ActionResponse)portletResponse;
            DocumentEditionWindowProperties windowProperties = this.getWindowProperties(portalControllerContext);
            String redirectionPath = StringUtils.defaultIfEmpty((String)windowProperties.getDocumentPath(), (String)windowProperties.getParentDocumentPath());
            String redirectionUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, redirectionPath, null, null, "refreshPageAndNavigation", null, null, null, null);
            actionResponse.sendRedirect(redirectionUrl);
        }
    }

    private String getRepositoryName(PortalControllerContext portalControllerContext, DocumentEditionWindowProperties windowProperties) throws PortletException {
        String repositoryName;
        if (windowProperties.isExtractArchive()) {
            String[] names = this.applicationContext.getBeanNamesForType(ZipExtractionRepositoryImpl.class);
            repositoryName = ArrayUtils.getLength((Object)names) == 1 ? names[0] : null;
        } else {
            boolean creation;
            String documentType;
            if (StringUtils.isEmpty((String)windowProperties.getDocumentPath())) {
                documentType = windowProperties.getDocumentType();
                creation = true;
            } else {
                DocumentEditionRepository defaultRepository = this.applicationContext.getBeansOfType(DocumentEditionRepository.class).values().stream().findFirst().orElse(null);
                NuxeoDocumentContext documentContext = defaultRepository == null ? null : defaultRepository.getDocumentContext(portalControllerContext, windowProperties.getDocumentPath());
                documentType = documentContext == null || documentContext.getDocumentType() == null ? null : documentContext.getDocumentType().getName();
                creation = false;
            }
            repositoryName = this.applicationContext.getBeansOfType(DocumentEditionRepository.class).entrySet().stream().filter(item -> ((DocumentEditionRepository)item.getValue()).matches(documentType, creation)).map(Map.Entry::getKey).findFirst().orElse(null);
        }
        return repositoryName;
    }
}

