/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import java.io.File;
import java.io.IOException;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.osivia.services.edition.portlet.model.UploadTemporaryFile;
import org.osivia.services.edition.portlet.repository.DocumentEditionCommonRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.multipart.MultipartFile;

public abstract class DocumentEditionCommonRepositoryImpl<T>
implements DocumentEditionCommonRepository<T> {
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void deleteTemporaryFile(UploadTemporaryFile temporaryFile) {
        if (temporaryFile != null && temporaryFile.getFile() != null && !temporaryFile.getFile().delete()) {
            temporaryFile.getFile().deleteOnExit();
        }
    }

    @Override
    public UploadTemporaryFile createTemporaryFile(MultipartFile multipartFile) throws IOException {
        MimeType mimeType;
        File file = File.createTempFile("uploaded-file-", ".tmp");
        file.deleteOnExit();
        multipartFile.transferTo(file);
        try {
            mimeType = new MimeType(multipartFile.getContentType());
        }
        catch (MimeTypeParseException e) {
            mimeType = null;
        }
        UploadTemporaryFile temporaryFile = (UploadTemporaryFile)this.applicationContext.getBean(UploadTemporaryFile.class);
        temporaryFile.setFile(file);
        temporaryFile.setFileName(multipartFile.getOriginalFilename());
        temporaryFile.setMimeType(mimeType);
        return temporaryFile;
    }
}

