/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.DocumentEditionWindowProperties;
import org.osivia.services.edition.portlet.model.FileEditionForm;
import org.osivia.services.edition.portlet.repository.AbstractDocumentEditionRepositoryImpl;
import org.osivia.services.edition.portlet.repository.command.ImportFileCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.springframework.web.multipart.MultipartFile;

@Repository(value="File")
public class FileEditionRepositoryImpl
extends AbstractDocumentEditionRepositoryImpl<FileEditionForm> {
    private static final String BINARY_PROPERTY = "file:content";
    private static final String BINARY_NAME_PROPERTY = "file:content/name";
    private final Map<String, String> requiredPrimaryTypes = new ConcurrentHashMap<String, String>();
    @Autowired
    private ApplicationContext applicationContext;

    public FileEditionRepositoryImpl() {
        this.requiredPrimaryTypes.put("Picture", "image");
        this.requiredPrimaryTypes.put("Audio", "audio");
        this.requiredPrimaryTypes.put("Video", "video");
    }

    @Override
    public FileEditionForm getForm(PortalControllerContext portalControllerContext, DocumentEditionWindowProperties windowProperties) throws PortletException, IOException {
        return super.getForm(portalControllerContext, windowProperties, FileEditionForm.class);
    }

    @Override
    protected void customizeForm(PortalControllerContext portalControllerContext, Document document, FileEditionForm form) {
        String requiredPrimaryType = this.requiredPrimaryTypes.get(document.getType());
        form.setRequiredPrimaryType(requiredPrimaryType);
    }

    @Override
    public String getViewPath(PortalControllerContext portalControllerContext) {
        return "file";
    }

    @Override
    public void validate(FileEditionForm form, Errors errors) {
        super.validate(form, errors);
        if (form.isCreation()) {
            if (form.getTemporaryFile() == null) {
                errors.rejectValue("upload", "NotEmpty");
            }
        } else if (form.getTemporaryFile() != null && StringUtils.isNotEmpty((String)form.getRequiredPrimaryType())) {
            MimeType mimeType = form.getTemporaryFileMimeType();
            if (mimeType == null) {
                errors.rejectValue("upload", "UnknownFileType");
            } else if (!StringUtils.equals((String)form.getRequiredPrimaryType(), (String)mimeType.getPrimaryType())) {
                errors.rejectValue("upload", "InvalidFileType");
            }
        }
    }

    @Override
    public void upload(PortalControllerContext portalControllerContext, FileEditionForm form) throws IOException {
        MimeType mimeType;
        if (form.getTemporaryFile() != null) {
            form.getTemporaryFile().delete();
        }
        MultipartFile upload = form.getUpload();
        File temporaryFile = File.createTempFile("document-edition-file-", ".tmp");
        temporaryFile.deleteOnExit();
        upload.transferTo(temporaryFile);
        form.setTemporaryFile(temporaryFile);
        form.setTemporaryFileName(upload.getOriginalFilename());
        try {
            mimeType = new MimeType(upload.getContentType());
        }
        catch (MimeTypeParseException e) {
            mimeType = null;
        }
        form.setTemporaryFileMimeType(mimeType);
        if (StringUtils.isBlank((String)form.getTitle())) {
            form.setTitle(form.getTemporaryFileName());
        }
    }

    @Override
    public void restore(PortalControllerContext portalControllerContext, FileEditionForm form) {
        if (form.getTemporaryFile() != null) {
            form.getTemporaryFile().delete();
        }
        form.setTemporaryFile(null);
        form.setTemporaryFileName(null);
        form.setTemporaryFileMimeType(null);
    }

    @Override
    protected void customizeProperties(PortalControllerContext portalControllerContext, FileEditionForm form, PropertyMap properties, Map<String, Blob> binaries) {
        if (form.getTemporaryFile() == null) {
            properties.set(BINARY_NAME_PROPERTY, form.getTitle());
        } else {
            File file = form.getTemporaryFile();
            String name = form.getTitle();
            String contentType = form.getTemporaryFileMimeType() == null ? null : form.getTemporaryFileMimeType().toString();
            FileBlob blob = new FileBlob(file, name, contentType);
            binaries.put(BINARY_PROPERTY, (Blob)blob);
        }
    }

    @Override
    protected Document create(NuxeoController nuxeoController, String parentPath, String type, PropertyMap properties, Map<String, Blob> binaries) throws PortletException {
        Blob binary = binaries.get(BINARY_PROPERTY);
        if (binary == null) {
            throw new PortletException("Empty file");
        }
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ImportFileCommand.class, new Object[]{parentPath, binary});
        Document document = (Document)nuxeoController.executeNuxeoCommand(command);
        return document;
    }
}

