/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.PortletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.AbstractDocumentEditionForm;
import org.osivia.services.edition.portlet.model.DocumentEditionWindowProperties;
import org.osivia.services.edition.portlet.model.FileEditionForm;
import org.osivia.services.edition.portlet.model.TemporaryFile;
import org.osivia.services.edition.portlet.repository.AbstractDocumentEditionRepositoryImpl;
import org.osivia.services.edition.portlet.repository.command.ImportFileCommand;
import org.osivia.services.edition.portlet.service.DocumentEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.springframework.web.multipart.MultipartFile;

@Repository(value="File")
public class FileEditionRepositoryImpl
extends AbstractDocumentEditionRepositoryImpl<FileEditionForm> {
    private static final String BINARY_PROPERTY = "file:content";
    private static final String BINARY_NAME_PROPERTY = "file:content/name";
    private final Map<String, String> requiredPrimaryTypes = new ConcurrentHashMap();
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DocumentEditionService service;

    public FileEditionRepositoryImpl() {
        this.requiredPrimaryTypes.put("Picture", "image");
        this.requiredPrimaryTypes.put("Audio", "audio");
        this.requiredPrimaryTypes.put("Video", "video");
    }

    public FileEditionForm getForm(PortalControllerContext portalControllerContext, DocumentEditionWindowProperties windowProperties) throws PortletException, IOException {
        FileEditionForm form = (FileEditionForm)super.getForm(portalControllerContext, windowProperties, FileEditionForm.class);
        boolean multiple = StringUtils.isEmpty((String)windowProperties.getDocumentPath()) && windowProperties.isMultipleFiles();
        form.setMultiple(multiple);
        return form;
    }

    protected void customizeForm(PortalControllerContext portalControllerContext, Document document, FileEditionForm form) {
        String requiredPrimaryType = (String)this.requiredPrimaryTypes.get(document.getType());
        form.setRequiredPrimaryType(requiredPrimaryType);
    }

    public String getViewPath(PortalControllerContext portalControllerContext) {
        return "file";
    }

    public void validate(FileEditionForm form, Errors errors) {
        if (form.isMultiple()) {
            if (CollectionUtils.isEmpty((Collection)form.getTemporaryFiles())) {
                errors.rejectValue("uploads", "NotEmpty");
            }
        } else if (form.isCreation()) {
            super.validate((AbstractDocumentEditionForm)form, errors);
            if (form.getTemporaryFile() == null) {
                errors.rejectValue("upload", "NotEmpty");
            }
        } else {
            super.validate((AbstractDocumentEditionForm)form, errors);
            if (form.getTemporaryFile() != null && form.getTemporaryFile().getFile() != null && StringUtils.isNotEmpty((String)form.getRequiredPrimaryType())) {
                MimeType mimeType = form.getTemporaryFile().getMimeType();
                if (mimeType == null) {
                    errors.rejectValue("upload", "UnknownFileType");
                } else if (!StringUtils.equals((String)form.getRequiredPrimaryType(), (String)mimeType.getPrimaryType())) {
                    errors.rejectValue("upload", "InvalidFileType");
                }
            }
        }
    }

    public void upload(PortalControllerContext portalControllerContext, FileEditionForm form) throws IOException {
        if (form.isMultiple()) {
            List uploads;
            if (CollectionUtils.isNotEmpty((Collection)form.getTemporaryFiles())) {
                for (TemporaryFile temporaryFile : form.getTemporaryFiles()) {
                    if (temporaryFile.getFile() == null) continue;
                    temporaryFile.getFile().delete();
                }
                form.setTemporaryFiles(null);
            }
            if (CollectionUtils.isNotEmpty((Collection)(uploads = form.getUploads()))) {
                ArrayList<TemporaryFile> temporaryFiles = new ArrayList<TemporaryFile>(uploads.size());
                form.setTemporaryFiles(temporaryFiles);
                for (MultipartFile upload : uploads) {
                    TemporaryFile temporaryFile = this.createTemporaryFile(upload);
                    temporaryFiles.add(temporaryFile);
                }
            }
        } else {
            if (form.getTemporaryFile() != null && form.getTemporaryFile().getFile() != null) {
                form.getTemporaryFile().getFile().delete();
            }
            MultipartFile upload = form.getUpload();
            TemporaryFile temporaryFile = this.createTemporaryFile(upload);
            form.setTemporaryFile(temporaryFile);
            if (StringUtils.isBlank((String)form.getTitle())) {
                form.setTitle(temporaryFile.getName());
            }
        }
    }

    private TemporaryFile createTemporaryFile(MultipartFile upload) throws IOException {
        MimeType mimeType;
        File file = File.createTempFile("document-edition-file-", ".tmp");
        file.deleteOnExit();
        upload.transferTo(file);
        try {
            mimeType = new MimeType(upload.getContentType());
        }
        catch (MimeTypeParseException e) {
            mimeType = null;
        }
        TemporaryFile temporaryFile = (TemporaryFile)this.applicationContext.getBean(TemporaryFile.class);
        temporaryFile.setFile(file);
        temporaryFile.setName(upload.getOriginalFilename());
        temporaryFile.setMimeType(mimeType);
        return temporaryFile;
    }

    public void restore(PortalControllerContext portalControllerContext, FileEditionForm form) {
        if (form.getTemporaryFile() != null && form.getTemporaryFile().getFile() != null) {
            form.getTemporaryFile().getFile().delete();
        }
        form.setTemporaryFile(null);
    }

    public void save(PortalControllerContext portalControllerContext, FileEditionForm form) throws PortletException, IOException {
        if (form.isMultiple()) {
            if (CollectionUtils.isNotEmpty((Collection)form.getTemporaryFiles())) {
                for (TemporaryFile temporaryFile : form.getTemporaryFiles()) {
                    FileEditionForm singleFileForm = (FileEditionForm)this.applicationContext.getBean(FileEditionForm.class);
                    singleFileForm.setCreation(true);
                    singleFileForm.setTitle(temporaryFile.getName());
                    singleFileForm.setTemporaryFile(temporaryFile);
                    super.save(portalControllerContext, (AbstractDocumentEditionForm)singleFileForm);
                }
                DocumentEditionWindowProperties windowProperties = this.service.getWindowProperties(portalControllerContext);
                String parentPath = windowProperties.getParentDocumentPath();
                form.setParentPath(parentPath);
            }
        } else {
            super.save(portalControllerContext, (AbstractDocumentEditionForm)form);
        }
    }

    protected void customizeProperties(PortalControllerContext portalControllerContext, FileEditionForm form, PropertyMap properties, Map<String, Blob> binaries) {
        if (form.getTemporaryFile() == null || form.getTemporaryFile().getFile() == null) {
            properties.set(BINARY_NAME_PROPERTY, form.getTitle());
        } else {
            File file = form.getTemporaryFile().getFile();
            String name = form.getTitle();
            String contentType = form.getTemporaryFile().getMimeType() == null ? null : form.getTemporaryFile().getMimeType().toString();
            FileBlob blob = new FileBlob(file, name, contentType);
            binaries.put(BINARY_PROPERTY, (Blob)blob);
        }
    }

    protected Document create(NuxeoController nuxeoController, String parentPath, String type, PropertyMap properties, Map<String, Blob> binaries) throws PortletException {
        Blob binary = binaries.get(BINARY_PROPERTY);
        if (binary == null) {
            throw new PortletException("Empty file");
        }
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ImportFileCommand.class, new Object[]{parentPath, binary});
        Document document = (Document)nuxeoController.executeNuxeoCommand(command);
        return document;
    }
}

