/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.tracker.portlet.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;

public class DownloadsTrackerServlet
extends HttpServlet {
    public static final String DOWNLOAD_ID_SESSION_PARAMETER = "osivia.download.id";
    private static final long serialVersionUID = 1L;
    private static final int BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = request.getParameter(DOWNLOAD_ID_SESSION_PARAMETER);
        if (id != null) {
            HttpSession session = request.getSession();
            String path = (String)session.getAttribute(id);
            InputStream input = null;
            String filename = null;
            int length = -1;
            if (StringUtils.startsWith((String)path, (String)"/")) {
                File file = new File(path);
                if (file.exists()) {
                    input = new FileInputStream(file);
                    filename = file.getName();
                    length = Long.valueOf(file.length()).intValue();
                }
            } else {
                URL url = new URL(path);
                input = url.openStream();
                File file = new File(url.getFile());
                filename = file.getName();
                length = url.openConnection().getContentLength();
            }
            if (input != null && filename != null) {
                response.setContentType(this.getServletContext().getMimeType(filename));
                response.setContentLength(length);
                response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                response.setBufferSize(8192);
                ServletOutputStream output = response.getOutputStream();
                try {
                    this.stream(input, (OutputStream)output);
                }
                finally {
                    input.close();
                    output.close();
                }
            }
            session.removeAttribute(id);
        }
    }

    private void stream(InputStream input, OutputStream output) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
        output.flush();
    }
}

