/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.tracker.portlet.service;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.UUID;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.tracker.portlet.model.ConfigurationVO;
import org.osivia.services.tracker.portlet.model.UserInformationsVO;
import org.osivia.services.tracker.portlet.service.IDownloadsTrackerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Service;

@Service
public class DownloadsTrackerServiceImpl
implements IDownloadsTrackerService {
    private static final String LOGGER_NAME = "downloads-tracker";
    private static final String LOGGER_APPENDER_NAME = "downloads-tracker-file-appender";
    private static final String LOG_DIRECTORY_PROPERTY = "jboss.server.log.dir";
    private static final String USER_SESSION_ATTRIBUTE = "osivia.download-tracker.user";
    private static final String DOWNLOAD_TARGET_WINDOW_PROPERTY = "osivia.downloads-tracker.target";
    private static final String DOWNLOAD_LINK_DISPLAY_WINDOW_PROPERTY = "osivia.downloads-tracker.link-display";
    private static final String DOWNLOAD_ENTITLED_WINDOW_PROPERTY = "osivia.downloads-tracker.entitled";
    @Autowired
    private LdapTemplate ldapTemplate;
    private final Logger logger = this.declareTrackerLogger();
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");

    private Logger declareTrackerLogger() {
        Logger logger = Logger.getLogger((String)LOGGER_NAME);
        logger.setAdditivity(false);
        logger.removeAllAppenders();
        FileAppender appender = new FileAppender();
        appender.setName(LOGGER_APPENDER_NAME);
        appender.setFile(System.getProperty(LOG_DIRECTORY_PROPERTY) + "/tracker.csv");
        appender.setLayout((Layout)new PatternLayout("%d{dd/MM/yy;HH:mm:ss};%c;%m%n"));
        appender.setThreshold((Priority)Level.INFO);
        appender.setAppend(true);
        appender.activateOptions();
        logger.addAppender((Appender)appender);
        return logger;
    }

    public ConfigurationVO getConfiguration(PortalControllerContext portalControllerContext) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String target = window.getProperty(DOWNLOAD_TARGET_WINDOW_PROPERTY);
        String display = window.getProperty(DOWNLOAD_LINK_DISPLAY_WINDOW_PROPERTY);
        String entitled = window.getProperty(DOWNLOAD_ENTITLED_WINDOW_PROPERTY);
        ConfigurationVO configuration = new ConfigurationVO();
        configuration.setTarget(StringUtils.trimToEmpty((String)target));
        configuration.setDisplay(StringUtils.trimToEmpty((String)display));
        configuration.setEntitled(StringUtils.trimToEmpty((String)entitled));
        if (StringUtils.isNotBlank((String)target)) {
            if (StringUtils.isBlank((String)display)) {
                File file = new File(target);
                configuration.setLink(file.getName());
            } else {
                configuration.setLink(display);
            }
        }
        return configuration;
    }

    public UserInformationsVO getUserInformations(PortalControllerContext portalControllerContext) {
        UserInformationsVO informations;
        PortletRequest request = portalControllerContext.getRequest();
        HttpServletRequest clientRequest = (HttpServletRequest)request.getAttribute("osivia.httpRequest");
        Principal principal = request.getUserPrincipal();
        if (principal == null) {
            PortletSession session = request.getPortletSession();
            informations = (UserInformationsVO)session.getAttribute(USER_SESSION_ATTRIBUTE, 1);
            if (informations == null) {
                informations = new UserInformationsVO();
                informations.setKnown(false);
            } else {
                informations.setKnown(true);
            }
        } else {
            ContainerCriteria query = LdapQueryBuilder.query().where("uid").is(principal.getName());
            informations = (UserInformationsVO)this.ldapTemplate.findOne((LdapQuery)query, UserInformationsVO.class);
            informations.setKnown(true);
        }
        String remoteAddress = clientRequest.getHeader("X-FORWARDED-FOR");
        if (remoteAddress == null) {
            remoteAddress = clientRequest.getRemoteAddr();
        }
        informations.setRemoteAddress(remoteAddress);
        return informations;
    }

    public void serveDownload(PortalControllerContext portalControllerContext, ConfigurationVO configuration, UserInformationsVO informations) throws IOException {
        this.track(configuration, informations);
        PortletRequest request = portalControllerContext.getRequest();
        ResourceResponse response = (ResourceResponse)portalControllerContext.getResponse();
        String id = StringEscapeUtils.escapeHtml((String)UUID.randomUUID().toString());
        request.getPortletSession().setAttribute(id, (Object)configuration.getTarget(), 1);
        response.setProperty("portlet.http-status-code", String.valueOf(302));
        StringBuilder servletLocation = new StringBuilder();
        servletLocation.append(request.getContextPath());
        servletLocation.append("/servlet/download?");
        servletLocation.append("osivia.download.id");
        servletLocation.append("=");
        servletLocation.append(id);
        response.setProperty("Location", servletLocation.toString());
        response.getPortletOutputStream().close();
    }

    public void saveUserInformations(PortalControllerContext portalControllerContext, UserInformationsVO informations) {
        PortletRequest request = portalControllerContext.getRequest();
        PortletSession session = request.getPortletSession();
        session.setAttribute(USER_SESSION_ATTRIBUTE, (Object)informations, 1);
    }

    public void saveConfiguration(PortalControllerContext portalControllerContext, ConfigurationVO configuration) {
        String target = configuration.getTarget();
        String display = configuration.getDisplay();
        String entitled = configuration.getEntitled();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        window.setProperty(DOWNLOAD_TARGET_WINDOW_PROPERTY, target);
        window.setProperty(DOWNLOAD_LINK_DISPLAY_WINDOW_PROPERTY, display);
        window.setProperty(DOWNLOAD_ENTITLED_WINDOW_PROPERTY, entitled);
    }

    private void track(ConfigurationVO configuration, UserInformationsVO informations) {
        StringBuilder message = new StringBuilder();
        message.append(configuration.getTarget()).append(";");
        message.append(StringUtils.defaultIfBlank((String)informations.getName(), (String)"Unknown")).append(";");
        message.append(StringUtils.trimToEmpty((String)informations.getMail())).append(";");
        message.append(StringUtils.trimToEmpty((String)informations.getTelephoneNumber())).append(";");
        message.append(StringUtils.trimToEmpty((String)informations.getOrganization())).append(";");
        message.append(StringUtils.trimToEmpty((String)informations.getEmployeeType())).append(";");
        message.append(informations.getRemoteAddress());
        this.logger.info((Object)message.toString());
    }

    public String getCollectPopupURL(PortalControllerContext portalControllerContext) {
        if (portalControllerContext.getResponse() instanceof MimeResponse) {
            MimeResponse reponse = (MimeResponse)portalControllerContext.getResponse();
            PortletURL collectPortletURL = reponse.createRenderURL();
            collectPortletURL.setParameter("phase", "collect");
            String collectURL = this.portalUrlFactory.adaptPortalUrlToPopup(portalControllerContext, collectPortletURL.toString(), 0);
            return collectURL;
        }
        return null;
    }

    public void setCallbackURL(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        if (portalControllerContext.getResponse() instanceof MimeResponse) {
            MimeResponse response = (MimeResponse)portalControllerContext.getResponse();
            PortletURL callbackPortletURL = response.createActionURL();
            callbackPortletURL.setParameter("action", "callback");
            String callbackURL = this.portalUrlFactory.adaptPortalUrlToPopup(portalControllerContext, callbackPortletURL.toString(), 2);
            request.setAttribute("osivia.popupCallbackUrl", (Object)callbackURL);
        }
    }
}

