<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="internationalization" prefix="is"%>

<%@ page contentType="text/html" isELIgnored="false"%>


<portlet:defineObjects />

<portlet:actionURL name="collect" var="collectActionURL">
    <portlet:param name="phase" value="collect" />
</portlet:actionURL>


<div class="fancybox-center-content no-ajax-link">
    <form:form commandName="informations" action="${collectActionURL}" method="post" class="fancybox-form">
        <div class="fancybox-table">
            <!-- Name -->
            <div class="fancybox-table-row">
                <div class="fancybox-table-cell label">
                    <form:label path="name">
                        <is:getProperty key="LABEL_NAME" />
                    </form:label>
                </div>
                <div class="fancybox-table-cell">
                    <form:input path="name" />
                </div>
            </div>
            
            <!-- Mail -->
            <div class="fancybox-table-row">                
                <div class="fancybox-table-cell label">
                    <form:label path="mail">
                        <is:getProperty key="LABEL_MAIL" />
                    </form:label>
                </div>
                <div class="fancybox-table-cell">
                    <form:input path="mail" />
                </div>
            </div>
            
            <!-- Telephone number -->
            <div class="fancybox-table-row">
                <div class="fancybox-table-cell label">
                    <form:label path="telephoneNumber">
                        <is:getProperty key="LABEL_TELEPHONE_NUMBER" />
                    </form:label>
                </div>
                <div class="fancybox-table-cell">
                    <form:input path="telephoneNumber" />
                </div>
            </div>
            
            <!-- Organization -->
            <div class="fancybox-table-row">
                <div class="fancybox-table-cell label">
                    <form:label path="organization">
                        <is:getProperty key="LABEL_ORGANIZATION" />
                    </form:label>
                </div>
                <div class="fancybox-table-cell">
                    <form:input path="organization" />
                </div>
            </div>
            
            <!-- Employee type -->
            <div class="fancybox-table-row">
                <div class="fancybox-table-cell label">
                    <form:label path="employeeType">
                        <is:getProperty key="LABEL_EMPLOYEE_TYPE" />
                    </form:label>
                </div>
                <div class="fancybox-table-cell">
                    <form:input path="employeeType" />
                </div>
            </div>
        </div>
        
        <!-- Known user indicator -->
        <input type="hidden" name="known" value="true" />

        <div class="fancybox-center-content">
            <input type="submit" value='<is:getProperty key="DOWNLOAD_ACCESS" />' />
            <input type="button" value='<is:getProperty key="CANCEL" />' onclick="closeFancybox()" />
        </div>
    </form:form>
</div>
