/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.link.portlet.configuration;

import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.web.IWebIdService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Configuration
@ComponentScan(basePackages={"org.osivia.services.editor.link.portlet"})
public class EditorLinkConfiguration {
    @Bean
    public InternalResourceViewResolver getViewResolver() {
        InternalResourceViewResolver viewResolver = new InternalResourceViewResolver();
        viewResolver.setCache(true);
        viewResolver.setViewClass(JstlView.class);
        viewResolver.setPrefix("/WEB-INF/jsp/link/");
        viewResolver.setSuffix(".jsp");
        return viewResolver;
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("Resource");
        return messageSource;
    }

    @Bean
    public IBundleFactory getBundleFactory() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        return internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    @Bean
    public IWebIdService getWebIdService() {
        return (IWebIdService)Locator.findMBean(IWebIdService.class, (String)"osivia:service=webIdService");
    }

    @Bean
    public INuxeoService getNuxeoService() {
        return (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    }

    @Bean
    public DocumentDAO getDocumentDao() {
        return DocumentDAO.getInstance();
    }
}

