/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.link.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.math.NumberUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.editor.link.portlet.model.EditorLinkForm;
import org.osivia.services.editor.link.portlet.model.FilterType;
import org.osivia.services.editor.link.portlet.model.UrlType;
import org.osivia.services.editor.link.portlet.model.validator.EditorLinkFormValidator;
import org.osivia.services.editor.link.portlet.service.EditorLinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"filterTypes"})
public class EditorLinkController
extends CMSPortlet
implements PortletConfigAware,
PortletContextAware {
    private PortletConfig portletConfig;
    private PortletContext portletContext;
    @Autowired
    private EditorLinkService service;
    @Autowired
    private EditorLinkFormValidator validator;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ActionMapping(value="submit")
    public void submit(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") @Validated EditorLinkForm form, BindingResult result) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            this.service.save(portalControllerContext, form);
        }
    }

    @ActionMapping(value="unlink")
    public void unlink(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") EditorLinkForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.unlink(portalControllerContext, form);
    }

    @ResourceMapping(value="search")
    public void search(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="page", required=false) String page) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        JSONObject results = this.service.searchDocuments(portalControllerContext, filter, NumberUtils.toInt((String)page, (int)1));
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(results.toString());
        printWriter.close();
    }

    @ResourceMapping(value="filters")
    public void getFilters(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        response.setContentType("text/html");
        String path = this.service.resolveViewPath(portalControllerContext, "filters");
        PortletRequestDispatcher dispatcher = this.portletContext.getRequestDispatcher(path);
        dispatcher.include((PortletRequest)request, (PortletResponse)response);
    }

    @ModelAttribute(value="form")
    public EditorLinkForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.validator});
        binder.setDisallowedFields(new String[]{"done", "url", "onlyText"});
    }

    @ModelAttribute(value="urlTypes")
    public List<UrlType> getUrlTypes(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getUrlTypes(portalControllerContext);
    }

    @ModelAttribute(value="filterTypes")
    public List<FilterType> getFilterTypes(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getFilterTypes(portalControllerContext);
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

