/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.image.portlet.model.validation;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.commons.lang.StringUtils;
import org.osivia.services.editor.image.portlet.model.EditorImageSourceAttachedForm;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.MultipartFile;

@Component
public class EditorImageSourceAttachedFormValidator
implements Validator {
    public boolean supports(Class<?> clazz) {
        return EditorImageSourceAttachedForm.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        EditorImageSourceAttachedForm attachedForm = (EditorImageSourceAttachedForm)target;
        MultipartFile upload = attachedForm.getUpload();
        if (upload != null) {
            MimeType mimeType;
            try {
                mimeType = new MimeType(upload.getContentType());
            }
            catch (MimeTypeParseException e) {
                mimeType = null;
            }
            if (mimeType == null || !StringUtils.equals((String)"image", (String)mimeType.getPrimaryType())) {
                errors.rejectValue("upload", "invalid");
            }
        }
    }
}

