/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.image.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.services.editor.common.service.CommonServiceImpl;
import org.osivia.services.editor.image.portlet.model.AttachedImage;
import org.osivia.services.editor.image.portlet.model.EditorImageForm;
import org.osivia.services.editor.image.portlet.model.EditorImageSourceAttachedForm;
import org.osivia.services.editor.image.portlet.model.EditorImageSourceDocumentForm;
import org.osivia.services.editor.image.portlet.model.ImageSourceType;
import org.osivia.services.editor.image.portlet.model.SearchScope;
import org.osivia.services.editor.image.portlet.repository.EditorImageRepository;
import org.osivia.services.editor.image.portlet.service.EditorImageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class EditorImageServiceImpl
extends CommonServiceImpl
implements EditorImageService {
    private static final String ATTACHED_IMAGE_URL_REGEX = "/nuxeo/nxfile/default/attachedImages/(?<property>[^/]+)/(?<index>[0-9]+)/file.*";
    private final Pattern attachedImageUrlPattern = Pattern.compile("/nuxeo/nxfile/default/attachedImages/(?<property>[^/]+)/(?<index>[0-9]+)/file.*");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private EditorImageRepository repository;
    @Autowired
    private DocumentDAO documentDao;

    public EditorImageForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        EditorImageForm form = (EditorImageForm)this.applicationContext.getBean(EditorImageForm.class);
        if (!form.isLoaded()) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
            String path = window.getProperty("osivia.editor.path");
            Document document = this.repository.getDocument(portalControllerContext, path);
            boolean attachments = document.getProperties().getList("ttc:images") != null;
            String url = window.getProperty("osivia.editor.src");
            form.setUrl(url);
            String alt = window.getProperty("osivia.editor.alt");
            form.setAlt(alt);
            Integer height = NumberUtils.toInt((String)window.getProperty("osivia.editor.height"));
            if (height < 1) {
                height = null;
            }
            form.setHeight(height);
            Integer width = NumberUtils.toInt((String)window.getProperty("osivia.editor.width"));
            if (width < 1) {
                width = null;
            }
            form.setWidth(width);
            ArrayList<ImageSourceType> availableSourceTypes = new ArrayList<ImageSourceType>();
            if (attachments) {
                availableSourceTypes.add(ImageSourceType.ATTACHED);
            }
            availableSourceTypes.add(ImageSourceType.DOCUMENT);
            form.setAvailableSourceTypes(availableSourceTypes);
            form.setLoaded(true);
        }
        return form;
    }

    public void save(PortalControllerContext portalControllerContext, EditorImageForm form) {
        form.setDone(true);
    }

    public EditorImageSourceAttachedForm getAttachedForm(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String path = window.getProperty("osivia.editor.path");
        EditorImageSourceAttachedForm attachedForm = (EditorImageSourceAttachedForm)this.applicationContext.getBean(EditorImageSourceAttachedForm.class);
        SortedSet attachedImages = this.repository.getAttachedImages(portalControllerContext, path);
        attachedForm.setAttachedImages(attachedImages);
        return attachedForm;
    }

    public void addAttachedImage(PortalControllerContext portalControllerContext, EditorImageSourceAttachedForm attachedForm) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String path = window.getProperty("osivia.editor.path");
        File temporaryFile = File.createTempFile("attached-image-", ".tmp");
        attachedForm.getUpload().transferTo(temporaryFile);
        String fileName = attachedForm.getUpload().getOriginalFilename();
        String contentType = attachedForm.getUpload().getContentType();
        this.repository.addAttachedImage(portalControllerContext, path, temporaryFile, fileName, contentType);
        if (!temporaryFile.delete()) {
            temporaryFile.deleteOnExit();
        }
        int index = CollectionUtils.isEmpty((Collection)attachedForm.getAttachedImages()) ? 0 : attachedForm.getAttachedImages().size();
        SortedSet attachedImages = this.repository.getAttachedImages(portalControllerContext, path);
        attachedForm.setAttachedImages(attachedImages);
        this.selectAttachedImage(portalControllerContext, attachedForm, index);
    }

    public void selectAttachedImage(PortalControllerContext portalControllerContext, EditorImageSourceAttachedForm attachedForm, int index) throws PortletException {
        EditorImageForm form = this.getForm(portalControllerContext);
        AttachedImage attachedImage = this.getAttachedImage(attachedForm.getAttachedImages(), index);
        String url = attachedImage == null ? null : this.repository.getAttachedImageUrl(portalControllerContext, attachedImage);
        form.setUrl(url);
    }

    public void deleteAttachedImage(PortalControllerContext portalControllerContext, EditorImageSourceAttachedForm attachedForm, int index) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String path = window.getProperty("osivia.editor.path");
        SortedSet attachedImages = attachedForm.getAttachedImages();
        AttachedImage attachedImage = this.getAttachedImage(attachedImages, index);
        if (attachedImage != null) {
            this.repository.deleteAttachedImage(portalControllerContext, path, index);
            attachedImages.remove(attachedImage);
        }
    }

    private AttachedImage getAttachedImage(SortedSet<AttachedImage> attachedImages, int index) {
        AttachedImage result = null;
        if (CollectionUtils.isNotEmpty(attachedImages)) {
            Iterator iterator = attachedImages.iterator();
            while (result == null && iterator.hasNext()) {
                AttachedImage item = (AttachedImage)iterator.next();
                if (index != item.getIndex()) continue;
                result = item;
            }
        }
        return result;
    }

    public EditorImageSourceDocumentForm getDocumentForm(PortalControllerContext portalControllerContext) {
        EditorImageSourceDocumentForm form = (EditorImageSourceDocumentForm)this.applicationContext.getBean(EditorImageSourceDocumentForm.class);
        form.setScope(SearchScope.DEFAULT);
        form.setAvailableScopes(Arrays.asList(SearchScope.values()));
        return form;
    }

    public void filterDocuments(PortalControllerContext portalControllerContext, EditorImageSourceDocumentForm documentForm) {
    }

    public void serveSearchResults(PortalControllerContext portalControllerContext, String filter, String scope) throws PortletException, IOException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        String jspPath = this.resolveViewPath(portalControllerContext, "search-results");
        List results = this.search(portalControllerContext, filter, SearchScope.fromId((String)scope));
        request.setAttribute("results", (Object)results);
        PortletRequestDispatcher dispatcher = portletContext.getRequestDispatcher(jspPath);
        dispatcher.include(request, response);
    }

    private List<DocumentDTO> search(PortalControllerContext portalControllerContext, String filter, SearchScope scope) throws PortletException {
        ArrayList<DocumentDTO> documents;
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String basePath = window.getProperty("osivia.editor.basePath");
        List nuxeoDocuments = this.repository.search(portalControllerContext, basePath, filter, scope);
        if (CollectionUtils.isEmpty((Collection)nuxeoDocuments)) {
            documents = null;
        } else {
            documents = new ArrayList<DocumentDTO>(nuxeoDocuments.size());
            for (Document nuxeoDocument : nuxeoDocuments) {
                DocumentDTO document = this.documentDao.toDTO(nuxeoDocument);
                documents.add(document);
            }
        }
        return documents;
    }

    public void selectDocument(PortalControllerContext portalControllerContext, String path) throws PortletException {
        EditorImageForm form = this.getForm(portalControllerContext);
        String url = this.repository.getImageDocumentUrl(portalControllerContext, path);
        form.setUrl(url);
    }

    public void serveImagePreview(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        CMSBinaryContent binaryContent;
        ResourceRequest request = (ResourceRequest)portalControllerContext.getRequest();
        ResourceResponse response = (ResourceResponse)portalControllerContext.getResponse();
        String source = request.getParameter("src");
        Matcher attachedImageUrlMatcher = this.attachedImageUrlPattern.matcher(source);
        if (StringUtils.startsWith((String)source, (String)"/nuxeo/web/")) {
            String webId = StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)source, (String)"?"), (String)"/");
            Object[] parameters = StringUtils.split((String)StringUtils.substringAfter((String)source, (String)"?"), (String)"&");
            String content = "Original";
            if (ArrayUtils.isNotEmpty((Object[])parameters)) {
                for (Object parameter : parameters) {
                    String[] split = StringUtils.split((String)parameter, (String)"=");
                    if (ArrayUtils.getLength((Object)split) != 2 || !StringUtils.equals((String)"content", (String)split[0])) continue;
                    content = split[1];
                }
            }
            binaryContent = this.repository.getImageDocumentPreviewBinaryContent(portalControllerContext, webId, content);
        } else if (attachedImageUrlMatcher.matches()) {
            int index = NumberUtils.toInt((String)attachedImageUrlMatcher.group("index"));
            binaryContent = this.repository.getAttachedImagePreviewBinaryContent(portalControllerContext, index);
        } else {
            throw new FileNotFoundException("Unknown source: " + source);
        }
        response.setContentType(binaryContent.getMimeType());
        response.setContentLength(binaryContent.getFileSize().intValue());
        response.getCacheControl().setExpirationTime(0);
        FileInputStream inputStream = new FileInputStream(binaryContent.getFile());
        OutputStream outputStream = response.getPortletOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }
}

