/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.link.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.FileMimeType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.editor.common.service.CommonServiceImpl;
import org.osivia.services.editor.link.portlet.model.EditorLinkForm;
import org.osivia.services.editor.link.portlet.model.FilterType;
import org.osivia.services.editor.link.portlet.model.UrlType;
import org.osivia.services.editor.link.portlet.model.comparator.FilterTypeComparator;
import org.osivia.services.editor.link.portlet.repository.EditorLinkRepository;
import org.osivia.services.editor.link.portlet.service.EditorLinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class EditorLinkServiceImpl
extends CommonServiceImpl
implements EditorLinkService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private EditorLinkRepository repository;
    @Autowired
    private FilterTypeComparator filterTypeComparator;
    @Autowired
    private IBundleFactory bundleFactory;

    public void save(PortalControllerContext portalControllerContext, EditorLinkForm form) throws PortletException {
        if (UrlType.MANUAL.equals((Object)form.getUrlType())) {
            form.setUrl(form.getManualUrl());
            if (StringUtils.isBlank((String)form.getText())) {
                form.setText(form.getManualUrl());
            }
        } else if (UrlType.DOCUMENT.equals((Object)form.getUrlType())) {
            String webId = form.getDocumentWebId();
            String url = this.repository.getDocumentUrl(portalControllerContext, webId);
            form.setUrl(url);
            DocumentDTO document = this.repository.getDocumentDto(portalControllerContext, webId);
            form.setDocument(document);
            if (StringUtils.isBlank((String)form.getText())) {
                form.setText(document.getTitle());
            }
        }
        form.setDone(true);
    }

    public void unlink(PortalControllerContext portalControllerContext, EditorLinkForm form) throws PortletException {
        form.setUrl("");
        form.setDone(true);
    }

    public JSONObject searchDocuments(PortalControllerContext portalControllerContext, String filter, int page) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        String basePath = window.getProperty("osivia.editor.basePath");
        PaginableDocuments documents = this.repository.searchDocuments(portalControllerContext, basePath, filter, page - 1);
        int total = documents.getTotalSize();
        ArrayList<JSONObject> objects = new ArrayList<JSONObject>(Math.min(10, total));
        for (Document document : documents) {
            JSONObject object = new JSONObject();
            Map properties = this.repository.getDocumentProperties(portalControllerContext, document);
            for (Map.Entry entry : properties.entrySet()) {
                object.put(entry.getKey(), entry.getValue());
            }
            objects.add(object);
        }
        JSONObject results = new JSONObject();
        JSONArray items = new JSONArray();
        if (page == 1 && CollectionUtils.isNotEmpty(objects)) {
            String message = total == 0 ? bundle.getString("SELECT2_NO_RESULT") : (total == 1 ? bundle.getString("SELECT2_ONE_RESULT") : bundle.getString("SELECT2_MULTIPLE_RESULTS", new Object[]{total}));
            JSONObject object = new JSONObject();
            object.put((Object)"message", (Object)message);
            items.add((Object)object);
        }
        for (JSONObject object : objects) {
            items.add((Object)object);
        }
        results.put((Object)"page", (Object)page);
        results.put((Object)"pageSize", (Object)10);
        results.put((Object)"items", (Object)items);
        results.put((Object)"total", (Object)total);
        return results;
    }

    public EditorLinkForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String url = window.getProperty("osivia.editor.url");
        String text = window.getProperty("osivia.editor.text");
        String title = window.getProperty("osivia.editor.title");
        boolean onlyText = BooleanUtils.toBoolean((String)window.getProperty("osivia.editor.onlyText"));
        return this.repository.createForm(portalControllerContext, url, text, title, onlyText);
    }

    public List<UrlType> getUrlTypes(PortalControllerContext portalControllerContext) throws PortletException {
        return Arrays.asList(UrlType.values());
    }

    public List<FilterType> getFilterTypes(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        FilterType filterType;
        PortletRequest request = portalControllerContext.getRequest();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        Collection documentTypes = this.repository.getDocumentTypes(portalControllerContext);
        Map fileMimeTypes = this.repository.getFileMimeTypes(portalControllerContext);
        ArrayList<FilterType> filterTypes = new ArrayList<FilterType>(documentTypes.size() + fileMimeTypes.size());
        FilterType all = (FilterType)this.applicationContext.getBean(FilterType.class);
        all.setName("");
        all.setDisplayName(bundle.getString("FILTER_TYPE_ALL"));
        all.setLevel(1);
        filterTypes.add(all);
        for (DocumentType documentType : documentTypes) {
            if (documentType.isFile() && !StringUtils.equals((String)"File", (String)documentType.getName())) continue;
            filterType = (FilterType)this.applicationContext.getBean(FilterType.class);
            all.setName(documentType.getName());
            all.setIcon(documentType.getIcon());
            all.setDisplayName(bundle.getString("FILTER_TYPE_" + StringUtils.upperCase((String)documentType.getName())));
            all.setLevel(1);
            filterTypes.add(filterType);
        }
        for (FileMimeType fileDocumentType : fileMimeTypes.values()) {
            filterType = (FilterType)this.applicationContext.getBean(FilterType.class);
            all.setName(fileDocumentType.getMimeType().getBaseType());
            all.setIcon(fileDocumentType.getIcon());
            all.setDisplayName(fileDocumentType.getDescription());
            all.setLevel(2);
            filterTypes.add(filterType);
        }
        Collections.sort(filterTypes, this.filterTypeComparator);
        return filterTypes;
    }
}

