package org.osivia.services.email;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

/**
 * admin portlet controller.
 * 
 */
@Controller
@RequestMapping(value = "ADMIN")
public class SendEMailAdminController {

    /** Admin JSP path. */
    private static final String ADMIN_PATH = "admin";
        
    /** Name window property. */
	static final String MAIL_CONFIG_PROPERTY = "osivia.services.mail.to";
	/** Name window property. */
	static final String SUBJECT_CONFIG_PROPERTY = "osivia.services.mail.subject";
    /** Name request attribute. */
	static final String MAIL_ATTRIBUTE = "contactMail";
	static final String SUBJECT_ATTRIBUTE = "contactSubject";

    /**
     * Default constructor.
     */
    public SendEMailAdminController() {
        super();
    }


    /**
     * Admin page render mapping.
     *
     * @param request render request
     * @param response render response
     * @return admin page path
     * @throws PortletException
     */
    @RenderMapping
    public String admin(RenderRequest request, RenderResponse response) throws PortletException {
        // Current window
        PortalWindow window = WindowFactory.getWindow(request);

		String mail = window.getProperty(MAIL_CONFIG_PROPERTY);
		if (StringUtils.isNotBlank(mail)) {
			request.setAttribute(MAIL_ATTRIBUTE, mail);
        }

		String subject = window.getProperty(SUBJECT_CONFIG_PROPERTY);
		if (StringUtils.isNotBlank(subject)) {
			request.setAttribute(SUBJECT_ATTRIBUTE, subject);
        }

		
        return ADMIN_PATH;
    }


	/**
	 * Save action.
	 * 
	 * @param request
	 *            action request
	 * @param response
	 *            action response
	 * @param contactMail
	 *            name
	 * @throws PortletException
	 */
	@ActionMapping(value = "save")
	public void save(ActionRequest request, ActionResponse response, @RequestParam(value = MAIL_ATTRIBUTE, required = true) String contactMail,
			@RequestParam(value = SUBJECT_ATTRIBUTE, required = true) String subjectMail)
			throws PortletException {
		// Current window
		PortalWindow window = WindowFactory.getWindow(request);
		window.setProperty(MAIL_CONFIG_PROPERTY, contactMail);
		window.setProperty(SUBJECT_CONFIG_PROPERTY, subjectMail);

		response.setWindowState(WindowState.NORMAL);
		response.setPortletMode(PortletMode.VIEW);
	}

}
