package org.osivia.services.email;

import java.util.Date;
import java.util.Properties;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.Constants;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

import com.sun.mail.smtp.SMTPTransport;

/**
 * 
 */
@Controller
@RequestMapping(value = "VIEW")
public class SendEMailController extends GenericPortlet implements PortletContextAware, PortletConfigAware {

	public final static Log log = LogFactory.getLog(SendEMailController.class);

    /** Mail from (parameter). */
	static final String MAILFROM_PROPERTY = "osivia.services.mail.from";
	
	
    /** View JSP path. */
    private static final String VIEW_PATH = "view";


	private static final String NOT_CONFIGURED = "notConfiguredYet";

	private static final String MAIL_OK = "mailok";

    /** Portlet context. */
    private PortletContext portletContext;
    /** Portlet config. */
    private PortletConfig portletConfig;

    /** Bundle factory. */
    private IBundleFactory bundleFactory;

	@Autowired
	private SendEMailValidator validator;

    /**
     * Default constructor.
     */
    public SendEMailController() {
        super();
    }


    /**
     * Portlet initialization.
     *
     * @throws PortletException
     */
    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);

        // Bundle factory
        IInternationalizationService internationalizationService = (IInternationalizationService) this.portletContext
                .getAttribute(Constants.INTERNATIONALIZATION_SERVICE_NAME);
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }


    /**
     * Portlet destroy.
     */
    @PreDestroy
    public void preDestroy() {
        super.destroy();
    }


    /**
     * View page render mapping.
     *
     * @param request render request
     * @param response render response
     * @return view page path
     * @throws PortletException
     */
	@RenderMapping
	public String view(RenderRequest request, RenderResponse response) throws PortletException {

		PortalWindow window = WindowFactory.getWindow(request);

		String mail = window.getProperty(SendEMailAdminController.MAIL_CONFIG_PROPERTY);
		if (StringUtils.isBlank(mail)) {

			return NOT_CONFIGURED;
		}
		return VIEW_PATH;
	}

	@ActionMapping(params = "action=envoiMail")
	public void envoiMail(@ModelAttribute SendEMailForm form, BindingResult result, ActionRequest request, ActionResponse response) throws PortletException {

		validator.validate(form, result);

		if (!result.hasErrors()) {

			// Récupération des propriétés systemes (configurés dans le
			// portal.properties).
			Properties props = System.getProperties();

			Session mailSession = Session.getInstance(props, null);

			// Nouveau message
			final MimeMessage msg = new MimeMessage(mailSession);

			// -- Set the FROM and TO fields --
			try {
				msg.setFrom(new InternetAddress(form.getSrcMail()));
				
				InternetAddress adress[] = new InternetAddress[1];
				adress[0] = new InternetAddress(form.getSrcMail());
				msg.setReplyTo(adress);

				String mailDestinataire = form.getDestMail();

				msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(mailDestinataire, false));
				
				msg.setSubject(form.getSubject(), "UTF-8");

				Multipart mp = new MimeMultipart();
				MimeBodyPart htmlPart = new MimeBodyPart();
				String message = form.getMessage().replaceAll("(\r\n|\n\r|\r|\n)", "<br />");
				htmlPart.setContent(message, "text/html; charset=UTF-8");
				mp.addBodyPart(htmlPart);

				msg.setContent(mp);

				msg.setSentDate(new Date());

				SMTPTransport t = (SMTPTransport) mailSession.getTransport();

				t.connect();
				t.sendMessage(msg, msg.getAllRecipients());
				t.close();
			} catch (AddressException e) {
				log.error("erreur envoi mail", e);
				throw new PortletException("erreur envoi mail",e);
			} catch (MessagingException e) {
				log.error("erreur envoi mail", e);
				throw new PortletException("erreur envoi mail",e);
			}
			
			response.setRenderParameter("action", MAIL_OK);
		}

	}

	@RenderMapping(params = "action=mailok")
	public String mailOk() {
		return MAIL_OK;
	}

    /**
     * {@inheritDoc}
     */
    @Override
    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

	@ModelAttribute
	public SendEMailForm getForm(PortletRequest request) {
		
		SendEMailForm form = new SendEMailForm();
		
		// Paramétrage du formulaire
		PortalWindow window = WindowFactory.getWindow(request);
		
		if(window.getProperty(MAILFROM_PROPERTY) != null) {

			form.setSrcMail(window.getProperty(MAILFROM_PROPERTY));
			form.setShowSrcMail(false);
		}
		
		
		form.setDestMail(window.getProperty(SendEMailAdminController.MAIL_CONFIG_PROPERTY));
		
		if(window.getProperty(SendEMailAdminController.SUBJECT_CONFIG_PROPERTY) != null) {
			form.setSubject(window.getProperty(SendEMailAdminController.SUBJECT_CONFIG_PROPERTY));
			form.setSubjectEditable(false);
		}
		
		
		return form;
	}
}
