package org.osivia.services.email;

import java.util.regex.Pattern;

import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class SendEMailValidator implements Validator {

	@Override
	public boolean supports(Class<?> arg0) {
		if (arg0 == SendEMailForm.class) {
			return true;
		} else
			return false;

	}

	@Override
	public void validate(Object arg0, Errors errors) {

		SendEMailForm form = (SendEMailForm) arg0;

		ValidationUtils.rejectIfEmptyOrWhitespace(errors, "srcMail", "NotEmpty.field");

		String email = form.getSrcMail();

		boolean emailValide = Pattern.matches("^[\\w.-]+@[\\w.-]+\\.[a-zA-Z]{2,6}$", email);
		if (!emailValide) {
			errors.rejectValue("srcMail", "Email.Invalide");
		}
	}

}
