/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.email;

import com.sun.mail.smtp.SMTPTransport;
import java.util.Date;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.email.SendEMailForm;
import org.osivia.services.email.SendEMailValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class SendEMailController
extends GenericPortlet
implements PortletContextAware,
PortletConfigAware {
    public static final Log log = LogFactory.getLog(SendEMailController.class);
    static final String MAILFROM_PROPERTY = "osivia.services.mail.from";
    private static final String VIEW_PATH = "view";
    private static final String NOT_CONFIGURED = "notConfiguredYet";
    private static final String MAIL_OK = "mailok";
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    private IBundleFactory bundleFactory;
    @Autowired
    private SendEMailValidator validator;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
        IInternationalizationService internationalizationService = (IInternationalizationService)this.portletContext.getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    @PreDestroy
    public void preDestroy() {
        super.destroy();
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String mail = window.getProperty("osivia.services.mail.to");
        if (StringUtils.isBlank((String)mail)) {
            return NOT_CONFIGURED;
        }
        return VIEW_PATH;
    }

    @ActionMapping(params={"action=envoiMail"})
    public void envoiMail(@ModelAttribute SendEMailForm form, BindingResult result, ActionRequest request, ActionResponse response) throws PortletException {
        this.validator.validate((Object)form, (Errors)result);
        if (!result.hasErrors()) {
            Properties props = System.getProperties();
            Session mailSession = Session.getInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(mailSession);
            try {
                msg.setFrom((Address)new InternetAddress(form.getSrcMail()));
                InternetAddress[] adress = new InternetAddress[]{new InternetAddress(form.getSrcMail())};
                msg.setReplyTo((Address[])adress);
                String mailDestinataire = form.getDestMail();
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mailDestinataire, (boolean)false));
                msg.setSubject(form.getSubject(), "UTF-8");
                MimeMultipart mp = new MimeMultipart();
                MimeBodyPart htmlPart = new MimeBodyPart();
                String message = form.getMessage().replaceAll("(\r\n|\n\r|\r|\n)", "<br />");
                htmlPart.setContent((Object)message, "text/html; charset=UTF-8");
                mp.addBodyPart((BodyPart)htmlPart);
                msg.setContent((Multipart)mp);
                msg.setSentDate(new Date());
                SMTPTransport t = (SMTPTransport)mailSession.getTransport();
                t.connect();
                t.sendMessage((Message)msg, msg.getAllRecipients());
                t.close();
            }
            catch (AddressException e) {
                log.error((Object)"erreur envoi mail", (Throwable)e);
                throw new PortletException("erreur envoi mail", (Throwable)e);
            }
            catch (MessagingException e) {
                log.error((Object)"erreur envoi mail", (Throwable)e);
                throw new PortletException("erreur envoi mail", (Throwable)e);
            }
            response.setRenderParameter("action", MAIL_OK);
        }
    }

    @RenderMapping(params={"action=mailok"})
    public String mailOk() {
        return MAIL_OK;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    @ModelAttribute
    public SendEMailForm getForm(PortletRequest request) {
        SendEMailForm form = new SendEMailForm();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if (window.getProperty(MAILFROM_PROPERTY) != null) {
            form.setSrcMail(window.getProperty(MAILFROM_PROPERTY));
            form.setShowSrcMail(false);
        }
        form.setDestMail(window.getProperty("osivia.services.mail.to"));
        if (window.getProperty("osivia.services.mail.subject") != null) {
            form.setSubject(window.getProperty("osivia.services.mail.subject"));
            form.setSubjectEditable(false);
        }
        return form;
    }
}

