/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.Comment;
import fr.toutatice.portail.cms.nuxeo.api.domain.ThreadPost;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.services.forum.portlets.model.ThreadPostReplyForm;
import org.osivia.services.forum.portlets.model.ThreadVO;
import org.osivia.services.forum.portlets.service.IForumService;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ForumServiceImpl
implements IForumService {
    private static final String DOCUMENT_REQUEST_ATTRIBUTE = "osivia.forum.document";

    public Document getDocument(NuxeoController nuxeoController) throws PortletException {
        try {
            Document document = (Document)nuxeoController.getRequest().getAttribute(DOCUMENT_REQUEST_ATTRIBUTE);
            if (document == null) {
                PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
                String pathProperty = window.getProperty("osivia.cms.uri");
                document = nuxeoController.fetchDocument(pathProperty);
                nuxeoController.getRequest().setAttribute(DOCUMENT_REQUEST_ATTRIBUTE, (Object)document);
            }
            return document;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public ThreadVO getThread(NuxeoController nuxeoController) throws PortletException {
        Document document = this.getDocument(nuxeoController);
        Locale locale = nuxeoController.getRequest().getLocale();
        return this.toViewObject(nuxeoController, document, locale);
    }

    public List<ThreadPost> getThreadPosts(NuxeoController nuxeoController) throws PortletException {
        try {
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            Document document = this.getDocument(nuxeoController);
            INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
            return commentsService.getForumThreadPosts(cmsContext, document);
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void serveAvatar(NuxeoController nuxeoController, String user) throws PortletException, IOException {
        ResourceResponse response = (ResourceResponse)nuxeoController.getResponse();
        PortletContext portletContext = nuxeoController.getPortletCtx();
        String path = portletContext.getRealPath("/style/images/guest.png");
        File file = new File(path);
        byte[] data = FileUtils.readFileToByteArray((File)file);
        String type = portletContext.getMimeType(file.getName());
        response.setContentType(type);
        int length = Long.valueOf(file.length()).intValue();
        response.setContentLength(length);
        response.getPortletOutputStream().write(data);
    }

    public void addThreadPost(NuxeoController nuxeoController, List<ThreadPost> posts, ThreadPostReplyForm replyForm, String parentId) throws PortletException {
        try {
            ThreadPost post = this.toBusinessObject(replyForm);
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            Document document = this.getDocument(nuxeoController);
            INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
            commentsService.addDocumentComment(cmsContext, document, (Comment)post, parentId);
            posts.clear();
            posts.addAll(this.getThreadPosts(nuxeoController));
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void deleteThreadPost(NuxeoController nuxeoController, List<ThreadPost> posts, String id) throws PortletException {
        try {
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            Document document = this.getDocument(nuxeoController);
            INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
            commentsService.deleteDocumentComment(cmsContext, document, id);
            this.deleteThreadPostFromModel(posts, id);
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private boolean deleteThreadPostFromModel(List<? extends Comment> posts, String id) {
        boolean deleted = false;
        for (Comment comment : posts) {
            if (id.equals(comment.getId())) {
                deleted = posts.remove(comment);
                break;
            }
            if (comment.getChildren() == null || !(deleted = this.deleteThreadPostFromModel(comment.getChildren(), id))) continue;
            break;
        }
        return deleted;
    }

    private ThreadVO toViewObject(NuxeoController nuxeoController, Document document, Locale locale) throws PortletException {
        try {
            ThreadVO vo = new ThreadVO();
            vo.setTitle(document.getTitle());
            vo.setDescription(StringUtils.replace((String)document.getString("dc:description"), (String)SystemUtils.LINE_SEPARATOR, (String)"<br />"));
            vo.setAuthor(document.getString("dc:creator"));
            vo.setMessage(document.getString("ttcth:message"));
            Date creationDate = document.getDate("dc:created");
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3, locale);
            String formattedDate = dateFormat.format(creationDate);
            vo.setCreationDate(formattedDate);
            boolean isCommentable = this.isThreadCommentable(nuxeoController, document);
            vo.setCommentable(isCommentable);
            return vo;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private ThreadPost toBusinessObject(ThreadPostReplyForm replyForm) throws PortletException {
        try {
            ThreadPost post = new ThreadPost();
            BeanUtils.copyProperties((Object)post, (Object)replyForm);
            MultipartFile attachmentMultipart = replyForm.getAttachment();
            if (attachmentMultipart != null && attachmentMultipart.getSize() > 0L) {
                File attachment = File.createTempFile("attachment", null);
                attachment.deleteOnExit();
                attachmentMultipart.transferTo(attachment);
                post.setAttachment(attachment);
                post.setFilename(attachmentMultipart.getOriginalFilename());
            } else {
                post.setAttachment(null);
            }
            return post;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public boolean isThreadCommentable(NuxeoController nuxeoController, Document document) throws CMSException {
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSPublicationInfos publicationInfos = cmsService.getPublicationInfos(nuxeoController.getCMSCtx(), document.getPath());
        return publicationInfos.isEditableByUser();
    }
}

