<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="internationalization" prefix="is"%>


<div class="reply-input">
    <portlet:actionURL name="add" var="addActionURL">
        <c:if test="${not empty parentId}">
            <portlet:param name="parentId" value="${parentId}" />
        </c:if>
    </portlet:actionURL>

    <form:form name="add" commandName="replyForm" method="post" action="${addActionURL}" enctype="multipart/form-data">
        <fieldset>
            <legend>
                <c:choose>
                    <c:when test="${root}">
                        <is:getProperty key="ADD_POST" />
                    </c:when>
                    
                    <c:otherwise>
                        <is:getProperty key="REPLY" />
                    </c:otherwise>
                </c:choose>
            </legend>

            <div class="osivia-portal-table">
                <div class="reply-title osivia-portal-row">
                    <div class="osivia-portal-cell label">
                        <form:label path="title">
                            <is:getProperty key="TITLE" />
                        </form:label>
                    </div>
                    <div class="osivia-portal-cell">
                        <form:input path="title" />
                    </div>
                </div>

                <div class="reply-content osivia-portal-row">
                    <div class="osivia-portal-cell label">
                        <form:label path="content">
                            <is:getProperty key="CONTENT" />
                        </form:label>
                    </div>
                    <div class="osivia-portal-cell">
                        <form:textarea path="content" cols="150" rows="5" />
                    </div>
                </div>

                <div class="reply-attachment osivia-portal-row">
                    <div class="osivia-portal-cell label">
                        <form:label path="attachment">
                            <is:getProperty key="ATTACHMENT" />
                        </form:label>
                    </div>
                    <div class="osivia-portal-cell">
                        <form:input type="file" path="attachment" />
                    </div>
                </div>
            </div>

            <div class="reply-buttons">
                <input type="submit" value='<is:getProperty key="REPLY" />' />
                <input type="button" value='<is:getProperty key="CANCEL" />' onclick="closeReplyInput()" />
            </div>
        </fieldset>
    </form:form>
</div>