<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="osivia-portal" prefix="op"%>
<%@ taglib uri="internationalization" prefix="is"%>

<%@ page contentType="text/html" isELIgnored="false"%>


<portlet:defineObjects />

<portlet:actionURL name="delete" var="deleteActionURL" />


<c:set var="namespace" scope="request">
    <portlet:namespace />
</c:set>


<script type="text/javascript">
	function toggleReplyInput(link, title, root) {
		var post;
		if (root) {
			post = document.getElementById("${namespace}-reply-form");
		} else {
			post = $JQry(link).parents(".post-content")[0];
		}
		var input = $JQry(post).find(".reply-input");
		var hidden = (input.css("display") == "none");

		closeReplyInput();
		
		if (hidden) {
			var inputTitle = input.find(".reply-title").find("input")[0];
			inputTitle.value = "Re: " + title;

			var inputContent = input.find(".reply-content").find("textarea")[0];
			inputContent.value = "";

			input.toggle("fast");
		}
	}
	
	
	function closeReplyInput() {
		$JQry(".reply-input").toggle(false);
	}
	

	function selectCommentToDelete(id) {
		var formulaire = document.getElementById("${namespace}-delete-form");
		formulaire.action = "${deleteActionURL}&id=" + id;
		return false;
	}
</script>


<div class="forum">
    <div class="forum-content">
        <div class="post-header">
            <div class="post-header-content">
                <div class="author">${thread.author}</div>
                <div class="creation-date">${thread.creationDate}</div>
                <div class="title">${thread.title}</div>
                - ${thread.description}
            </div>
        </div>
    
        <div class="avatar">
            <portlet:resourceURL id="avatar" var="avatarResourceURL">
                <portlet:param name="user" value="${thread.author}" />
            </portlet:resourceURL>
        
            <img src="${avatarResourceURL}" alt="">
        </div>
    
        <div class="description content"><c:out value="${thread.message}" escapeXml="false" /></div>
    </div>

    <div class="posts">
        <c:forEach var="child" items="${posts}">
            <c:set var="post" value="${child}" scope="request" />
            <jsp:include page="display-post.jsp" />
        </c:forEach>
    </div>

    <c:if test="${not empty posts and thread.commentable}">
        <div class="actions">
            <div class="reply">
                <a class="portlet-menuitem" onclick="toggleReplyInput(this, '${op:escapeJavaScript(thread.title)}', true)"><is:getProperty key="ADD_POST" /></a>
            </div>
        </div>
    </c:if> 

    <div id="${namespace}-reply-form">
        <c:set var="root" value="true" scope="request" />
        <c:remove var="parentId" scope="request" />        
        <jsp:include page="reply-form.jsp" />
    </div>
</div>


<div class="fancybox-content">
    <div id="${namespace}-delete-fancybox">
        <form id="${namespace}-delete-form" action="${deleteActionURL}" method="post" class="fancybox-form">
            <div class="fancybox-center-content">
                <p><is:getProperty key="COMMENT_SUPPRESSION_CONFIRM_MESSAGE" /></p>
            </div>
            <div class="fancybox-center-content">
                <input type="submit" value='<is:getProperty key="YES" />' onclick="selectCommentToDelete" />
                <input type="button" value='<is:getProperty key="NO" />' onclick="closeFancybox()" />
            </div>
        </form>
    </div>
</div>
