/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONArray;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.services.procedure.portlet.model.Action;
import org.osivia.services.procedure.portlet.model.AddField;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.FilePath;
import org.osivia.services.procedure.portlet.model.Filter;
import org.osivia.services.procedure.portlet.model.Form;
import org.osivia.services.procedure.portlet.model.ProcedureInstance;
import org.osivia.services.procedure.portlet.model.ProcedureModel;
import org.osivia.services.procedure.portlet.model.ProcedureObject;
import org.osivia.services.procedure.portlet.model.Step;
import org.osivia.services.procedure.portlet.model.Variable;
import org.osivia.services.procedure.portlet.service.IProcedureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;
import org.springframework.web.portlet.multipart.MultipartActionRequest;

@Controller
@SessionAttributes(value={"form"})
@RequestMapping(value={"VIEW"})
public class ProcedurePortletController
extends CMSPortlet
implements PortletContextAware,
PortletConfigAware {
    private static final String CREATE_VIEW = "editProcedure";
    private static final String EDIT_VIEW = "editStep";
    private static final String VIEW_PROCEDURE = "viewProcedure";
    private static final String VIEW_ENDSTEP = "endStep";
    private static final String VIEW_ACTION = "editAction";
    private static final String LIST_VIEW = "list";
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    @Autowired
    private IProcedureService procedureService;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String defaultView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        if (StringUtils.equals((String)this.getAction((PortletRequest)request), (String)"adminproc")) {
            return CREATE_VIEW;
        }
        if (StringUtils.equals((String)this.getAction((PortletRequest)request), (String)"adminprocstep")) {
            return EDIT_VIEW;
        }
        if (this.getPath((PortletRequest)request) != null) {
            return VIEW_PROCEDURE;
        }
        return LIST_VIEW;
    }

    @RenderMapping(params={"action=editProcedure"})
    public String editProcedureView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        return CREATE_VIEW;
    }

    @RenderMapping(params={"action=editStep"})
    public String editStepView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        request.setAttribute("activeTab", (Object)request.getParameter("activeTab"));
        request.setAttribute("activeFormTab", (Object)request.getParameter("activeFormTab"));
        return EDIT_VIEW;
    }

    @RenderMapping(params={"action=editAction"})
    public String endStepView(RenderRequest request, RenderResponse response, @RequestParam(value="editAction", required=false) String editAction) throws PortletException, CMSException {
        request.setAttribute("activeTab", (Object)request.getParameter("activeTab"));
        return VIEW_ACTION;
    }

    @RenderMapping(params={"action=viewProcedure"})
    public String viewProcedure(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        return VIEW_PROCEDURE;
    }

    @RenderMapping(params={"action=endStep"})
    public String endStepView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        String closeUrl;
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        try {
            closeUrl = this.portalUrlFactory.getDestroyCurrentPageUrl(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        request.setAttribute("closeUrl", (Object)closeUrl);
        return VIEW_ENDSTEP;
    }

    @ModelAttribute(value="form")
    public Form getForm(PortletRequest request, PortletResponse response, @RequestParam(value="selectedStep", required=false) String selectedStep) throws PortletException {
        Form form;
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        if (StringUtils.isNotEmpty((String)this.getPath(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.PROCEDUREMODEL.getName())) {
            ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, this.getPath(request));
            form = new Form(procedureModel);
            if (StringUtils.isNotEmpty((String)selectedStep)) {
                form.setSelectedStep(selectedStep);
            } else {
                form.setSelectedStep("0");
            }
            if (!StringUtils.equals((String)this.getAction(request), (String)"adminproc") && !StringUtils.equals((String)this.getAction(request), (String)"adminprocstep")) {
                this.procedureService.updateVocabulariesWithValues(nuxeoController, form);
            }
        } else if (StringUtils.isNotEmpty((String)this.getPath(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.PROCEDUREINSTANCE.getName())) {
            ProcedureInstance procedureInstance = this.procedureService.retrieveProcedureInstanceByPath(nuxeoController, this.getPath(request));
            ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, procedureInstance.getProcedureModelWebId());
            form = new Form(procedureModel, procedureInstance);
            this.procedureService.updateFormWithObjectsValues(nuxeoController, form);
            this.procedureService.updateVocabulariesWithValues(nuxeoController, form);
        } else {
            form = new Form();
        }
        return form;
    }

    @ModelAttribute(value="procedureList")
    public List<ProcedureModel> getListProcedureModel(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        return this.procedureService.listProcedures(nuxeoController, this.getPortalUrlFactory(), this.getProcedurePath(request));
    }

    @ModelAttribute(value="addUrl")
    public String getAddUrl(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        String procedurePath = this.getProcedurePath(request);
        return this.procedureService.getAddUrl(nuxeoController, this.getPortalUrlFactory(), procedurePath);
    }

    @ModelAttribute(value="listeFiltres")
    public List<FormFilter> getListeFiltres(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        Map formsFilters = nuxeoController.getNuxeoCMSService().getCMSCustomizer().getFormsFilters();
        ArrayList<FormFilter> listeFiltres = new ArrayList<FormFilter>(formsFilters.size());
        for (Map.Entry entryFilter : formsFilters.entrySet()) {
            listeFiltres.add((FormFilter)entryFilter.getValue());
        }
        return listeFiltres;
    }

    @ModelAttribute(value="webIdPrefix")
    public String getWebIdPrefix(PortletRequest request, PortletResponse response) {
        return "procedure_";
    }

    @ResourceMapping(value="groupSearch")
    public void getProfils(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter) throws PortletException {
        ArrayList<Map> listeProfils = new ArrayList<Map>();
        listeProfils.add(this.buildProfilEntry("demo-group"));
        listeProfils.add(this.buildProfilEntry("personnel-tous"));
        listeProfils.add(this.buildProfilEntry("Administrators"));
        listeProfils.add(this.buildProfilEntry("SuperAdministrators"));
        listeProfils.add(this.buildProfilEntry("Metro2020Enseignants"));
        listeProfils.add(this.buildProfilEntry("Metro2020Inspecteurs"));
        listeProfils.add(this.buildProfilEntry("Metro2020SEMTCARpersonnels"));
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), listeProfils);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private Map<String, String> buildProfilEntry(String entryName) {
        HashMap<String, String> superAdministrators = new HashMap<String, String>(2);
        superAdministrators.put("cn", entryName);
        superAdministrators.put("displayName", entryName);
        return superAdministrators;
    }

    @ResourceMapping(value="stepSearch")
    public void getSteps(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="filter", required=false) String filter) throws PortletException {
        ArrayList listeSteps = new ArrayList();
        List steps = form.getProcedureModel().getSteps();
        for (Step step : steps) {
            if (filter != null && (!StringUtils.contains((String)step.getStepName(), (String)filter) || !StringUtils.contains((String)step.getReference(), (String)filter))) continue;
            HashMap<String, String> demoGroup = new HashMap<String, String>(2);
            demoGroup.put("id", step.getReference());
            demoGroup.put("text", step.getStepName());
            listeSteps.add(demoGroup);
        }
        HashMap<String, String> demoGroup = new HashMap<String, String>(2);
        demoGroup.put("id", VIEW_ENDSTEP);
        demoGroup.put("text", "Terminer la proc\u00e9dure");
        listeSteps.add(demoGroup);
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), listeSteps);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ResourceMapping(value="fieldSearch")
    public void getFields(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="filter", required=false) String filter) throws PortletException {
        ArrayList<Object> listeVar = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)filter)) {
            boolean exactMatch = false;
            for (Map.Entry entryVar : form.getProcedureModel().getVariables().entrySet()) {
                if (StringUtils.equals((String)((Variable)entryVar.getValue()).getName(), (String)filter)) {
                    listeVar.add(0, entryVar.getValue());
                    exactMatch = true;
                    continue;
                }
                if (!StringUtils.contains((String)((Variable)entryVar.getValue()).getName(), (String)filter) && !StringUtils.contains((String)((Variable)entryVar.getValue()).getLabel(), (String)filter)) continue;
                listeVar.add(entryVar.getValue());
            }
            if (!exactMatch) {
                listeVar.add(0, new Variable(StringUtils.deleteWhitespace((String)filter), null, null, null));
            }
        } else {
            listeVar.addAll(form.getProcedureModel().getVariables().values());
        }
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), listeVar);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ResourceMapping(value="vocabularySearch")
    public void getVocabulary(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="vocabularyName", required=true) String vocabularyName) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        nuxeoController.setCacheTimeOut(TimeUnit.HOURS.toMillis(1L));
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        try {
            JSONArray values = this.procedureService.getVocabularyValues(nuxeoController, filter, vocabularyName);
            PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
            printWriter.write(values.toString());
            printWriter.close();
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
        catch (PortletException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ActionMapping(value="editProcedure", params={"launchProcedure"})
    public void launchProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        form.setProcedureInstance(new ProcedureInstance());
        form.getProcedureInstance().setProcedureModelWebId(form.getProcedureModel().getCurrentWebId());
        response.setRenderParameter("action", VIEW_PROCEDURE);
    }

    @ActionMapping(value="editProcedure", params={"changeMode"})
    public void changeModeProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        form.setAdvancedMode(!form.isAdvancedMode());
        response.setRenderParameter("action", CREATE_VIEW);
    }

    @ActionMapping(value="editStep", params={"changeMode"})
    public void changeModeStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        form.setAdvancedMode(!form.isAdvancedMode());
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="actionProcedure", params={"proceedProcedure"})
    public void proceedProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="actionId") String actionId, SessionStatus sessionStatus) throws PortletException, IOException {
        if (request instanceof MultipartActionRequest) {
            MultipartActionRequest multipartActionRequest = (MultipartActionRequest)request;
            for (Field field : form.getTheCurrentStep().getFields()) {
                this.setMultipartFile(field, multipartActionRequest, form);
            }
        }
        try {
            NuxeoController nuxeoController;
            Map globalVariablesValues = form.getProcedureInstance().getGlobalVariablesValues();
            if (StringUtils.isNotEmpty((String)this.getPath((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.PROCEDUREMODEL.getName())) {
                nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
                PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
                String currentWebId = form.getProcedureModel().getCurrentWebId();
                String fetchWebId = StringUtils.removeStart((String)currentWebId, (String)"procedure_");
                nuxeoController.getNuxeoCMSService().getFormsService().start(portalControllerContext, fetchWebId, actionId, globalVariablesValues);
                response.setRenderParameter("action", VIEW_ENDSTEP);
                sessionStatus.setComplete();
            } else if (StringUtils.isNotEmpty((String)this.getPath((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.PROCEDUREINSTANCE.getName())) {
                nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
                PropertyMap taskProperties = form.getProcedureInstance().getTaskDoc();
                PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
                nuxeoController.getNuxeoCMSService().getFormsService().proceed(portalControllerContext, taskProperties, actionId, globalVariablesValues);
                response.setRenderParameter("action", VIEW_ENDSTEP);
                sessionStatus.setComplete();
            } else {
                response.setRenderParameter("action", VIEW_PROCEDURE);
            }
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        catch (FormFilterException e) {
            form.setFilterMessage(e.getMessage());
            request.setAttribute("filterMessage", (Object)e.getMessage());
            response.setRenderParameter("action", VIEW_PROCEDURE);
        }
    }

    @ActionMapping(value="editProcedure", params={"saveProcedure"})
    public void saveProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException, IOException {
        String path = this.getPath((PortletRequest)request);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        if (StringUtils.isNotEmpty((String)path)) {
            this.addAllFieldsToSet(form);
            this.addAllFiltersToSet(form);
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
        } else {
            ProcedureModel procedureModel = this.procedureService.createProcedure(nuxeoController, form.getProcedureModel(), this.getProcedurePath((PortletRequest)request));
        }
        String redirectUrl = nuxeoController.getPortalUrlFactory().getBackURL(nuxeoController.getPortalCtx(), false);
        response.sendRedirect(redirectUrl);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editProcedure", params={"deleteProcedure"})
    public void deleteProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.procedureService.deleteProcedure(nuxeoController, form.getProcedureModel());
        String redirectUrl = this.getPortalUrlFactory().getBackURL(nuxeoController.getPortalCtx(), false);
        response.sendRedirect(redirectUrl);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editProcedure", params={"addStep"})
    public void addStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException, IOException {
        Integer newIndex = form.getProcedureModel().getSteps().size();
        String path = this.getPath((PortletRequest)request);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        if (StringUtils.isNotEmpty((String)path)) {
            form.getProcedureModel().getSteps().add(new Step(newIndex));
            form.setSelectedStep(String.valueOf(newIndex));
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", EDIT_VIEW);
        } else {
            ProcedureModel createdProcedure = this.procedureService.createProcedure(nuxeoController, form.getProcedureModel(), this.getProcedurePath((PortletRequest)request));
            createdProcedure.getSteps().add(new Step(newIndex));
            this.procedureService.updateProcedure(nuxeoController, createdProcedure);
            String redirectUrl = nuxeoController.getLink(createdProcedure.getOriginalDocument(), "adminprocstep").getUrl();
            response.sendRedirect(redirectUrl);
        }
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editProcedure", params={"addObject"})
    public void addObject(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException, IOException {
        String path = this.getPath((PortletRequest)request);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        if (StringUtils.isNotEmpty((String)path)) {
            form.getProcedureModel().getProcedureObjects().add(new ProcedureObject());
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", CREATE_VIEW);
        } else {
            ProcedureModel createdProcedure = this.procedureService.createProcedure(nuxeoController, form.getProcedureModel(), this.getProcedurePath((PortletRequest)request));
            createdProcedure.getProcedureObjects().add(new ProcedureObject());
            this.procedureService.updateProcedure(nuxeoController, createdProcedure);
            String redirectUrl = nuxeoController.getLink(createdProcedure.getOriginalDocument(), "adminproc").getUrl();
            response.sendRedirect(redirectUrl);
        }
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editProcedure", params={"deleteObject"})
    public void deleteObject(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedObject", required=false) String selectedObject, SessionStatus sessionStatus) throws PortletException, IOException {
        form.getProcedureModel().getProcedureObjects().remove(Integer.valueOf(selectedObject));
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
        response.setRenderParameter("action", CREATE_VIEW);
        sessionStatus.setComplete();
    }

    private String getPath(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty("osivia.services.procedure.webid");
        return path;
    }

    private String getDocType(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty("osivia.doctype");
        return path;
    }

    private String getAction(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty("osivia.procedure.admin");
        return path;
    }

    private String getProcedurePath(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        return window.getProperty("osivia.services.procedure.procedurePath");
    }

    @ActionMapping(value="editProcedure", params={"editStep"})
    public void editStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException, IOException {
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="editStep", params={"cancelStep"})
    public void cancelStep(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", CREATE_VIEW);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editStep", params={"saveStep"})
    public void saveStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        this.updateStartingStep(form);
        form.getProcedureModel().getSteps().set(form.getTheSelectedStep().getIndex(), form.getTheSelectedStep());
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
        response.setRenderParameter("action", CREATE_VIEW);
        sessionStatus.setComplete();
    }

    private void addAllFiltersToSet(Form form) {
        for (Step step : form.getProcedureModel().getSteps()) {
            for (Action action : step.getActions()) {
                HashSet filtersList = new HashSet();
                this.addAllFiltersToSet(filtersList, action.getFilters());
                action.setFiltersList(filtersList);
            }
        }
    }

    private void addAllFiltersToSet(Set<Filter> filtersList, List<Filter> filters) {
        filtersList.addAll(filters);
        for (Filter filter : filters) {
            if (filter.getFilters() == null) continue;
            this.addAllFiltersToSet(filtersList, filter.getFilters());
        }
    }

    private void addAllFieldsToSet(Form form) {
        for (Step step : form.getProcedureModel().getSteps()) {
            HashSet fieldsSet = new HashSet();
            this.addAllFieldsToSet(fieldsSet, step.getFields());
            step.setFieldsSet(fieldsSet);
        }
    }

    private void addAllFieldsToSet(Set<Field> fieldsSet, List<Field> fields) {
        fieldsSet.addAll(fields);
        for (Field field : fields) {
            if (field.getFields() == null) continue;
            this.addAllFieldsToSet(fieldsSet, field.getFields());
        }
    }

    private void updateStartingStep(Form form) {
        if (!StringUtils.equals((String)form.getTheSelectedStep().getReference(), (String)form.getTheSelectedStep().getOldReference()) && StringUtils.equals((String)form.getProcedureModel().getStartingStep(), (String)form.getTheSelectedStep().getOldReference())) {
            form.getProcedureModel().setStartingStep(form.getTheSelectedStep().getReference());
        }
    }

    @ActionMapping(value="editStep", params={"deleteStep"})
    public void deleteStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        form.getProcedureModel().getSteps().remove(Integer.valueOf(form.getSelectedStep()));
        form.getProcedureModel().updateStepsIndexes();
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
        response.setRenderParameter("action", CREATE_VIEW);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editProcedure", params={"deleteStep"})
    public void deleteStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedStep", required=false) String selectedStep, SessionStatus sessionStatus) throws PortletException {
        form.getProcedureModel().getSteps().remove(Integer.valueOf(selectedStep));
        form.getProcedureModel().updateStepsIndexes();
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
        response.setRenderParameter("action", CREATE_VIEW);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editProcedure", params={"duplicateStep"})
    public void duplicateStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedStep", required=false) String selectedStep, SessionStatus sessionStatus) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        Integer newIndex = form.getProcedureModel().getSteps().size();
        Step copiedStep = (Step)form.getProcedureModel().getSteps().get(Integer.valueOf(selectedStep));
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        form.getProcedureModel().getSteps().add(new Step(newIndex, copiedStep));
        form.setSelectedStep(String.valueOf(newIndex));
        this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
        response.setRenderParameter("action", EDIT_VIEW);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editStep", params={"editField"})
    public void editField(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        String[] path = form.getSelectedField().getPath().split(",");
        Field editedField = this.getFieldByPath(form.getTheSelectedStep().getFields(), path);
        if (editedField != null) {
            form.getProcedureModel().getVariables().put(editedField.getName(), new Variable(editedField));
        }
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("activeFormTab", "edit");
        response.setRenderParameter("action", EDIT_VIEW);
    }

    private Field getFieldByPath(List<Field> fields, String[] path) {
        Integer index = Integer.parseInt(path[0]);
        if (path.length == 1 && fields != null) {
            ListIterator<Field> listIterator = fields.listIterator();
            while (listIterator.hasNext()) {
                Field field = listIterator.next();
                String[] pathArray = StringUtils.split((String)field.getPath(), (char)',');
                if (pathArray.length <= 0 || Integer.parseInt(pathArray[pathArray.length - 1]) != index) continue;
                return field;
            }
        } else {
            Field nestedField = fields.get(index);
            path = (String[])ArrayUtils.remove((Object[])path, (int)0);
            return this.getFieldByPath(nestedField.getFields(), path);
        }
        return null;
    }

    @ActionMapping(value="editStep", params={"addField"})
    public void addField(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        AddField addField = form.getNewField();
        Field field = new Field(form.getTheSelectedStep().getNextPath(), addField, false);
        form.getProcedureModel().getVariables().put(addField.getVariableName(), new Variable(addField));
        this.updateProcedureWithForm(request, response, form, field);
    }

    @ActionMapping(value="editStep", params={"addFieldSet"})
    public void addFieldSet(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        Field field = new Field(form.getTheSelectedStep().getNextPath(), form.getNewFieldSet(), true);
        this.updateProcedureWithForm(request, response, form, field);
    }

    private void updateProcedureWithForm(ActionRequest request, ActionResponse response, Form form, Field field) throws PortletException {
        field.setPath(String.valueOf(form.getTheSelectedStep().getFields().size()));
        form.getTheSelectedStep().getFields().add(field);
        form.setNewField(new AddField());
        form.setNewFieldSet(new AddField());
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="editStep", params={"updateForm"})
    public void updateFormStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        HashMap allFieldsMap = new HashMap();
        this.addAllFields(allFieldsMap, form.getTheSelectedStep().getFields());
        this.rebuildStep(allFieldsMap, form.getTheSelectedStep());
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("action", EDIT_VIEW);
    }

    private void rebuildStep(Map<String, List<Field>> allFieldsMap, Step step) {
        ArrayList<Field> baseFields = new ArrayList<Field>();
        List<Field> fieldList = allFieldsMap.get("");
        if (fieldList != null) {
            baseFields.addAll(fieldList);
            Collections.sort(baseFields);
        }
        this.rebuildFields(allFieldsMap, baseFields);
        step.setFields(baseFields);
    }

    private void rebuildFields(Map<String, List<Field>> allFieldsMap, List<Field> fields) {
        if (fields != null) {
            for (Field field : fields) {
                field.setFields(allFieldsMap.get(field.getPath()));
                this.rebuildFields(allFieldsMap, field.getFields());
            }
        }
    }

    private void addAllFields(Map<String, List<Field>> allFieldsMap, List<Field> fields) {
        if (fields != null) {
            for (Field field : fields) {
                if (field.getPath() == null) continue;
                String parentPath = field.getPath().length() > 1 ? StringUtils.substringBeforeLast((String)field.getPath(), (String)",") : "";
                List<Field> parentFields = allFieldsMap.get(parentPath);
                if (parentFields == null) {
                    parentFields = new ArrayList<Field>();
                }
                parentFields.add(field);
                Collections.sort(parentFields);
                allFieldsMap.put(parentPath, parentFields);
                this.addAllFields(allFieldsMap, field.getFields());
            }
        }
    }

    @ActionMapping(value="editStep", params={"editButton"})
    public void editAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedButton") String index) throws PortletException {
        form.setSelectedAction(index);
        response.setRenderParameter("action", VIEW_ACTION);
    }

    @ActionMapping(value="editStep", params={"addButton"})
    public void addButton(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        form.getTheSelectedStep().getActions().add(new Action());
        response.setRenderParameter("activeTab", "action");
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="editStep", params={"deleteButton"})
    public void deleteButton(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedButton") String index) throws PortletException {
        form.getTheSelectedStep().getActions().remove(Integer.valueOf(index));
        response.setRenderParameter("activeTab", "action");
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="editStep", params={"selectField"})
    public void fillEditFieldTab(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFieldPath") String selectedFieldPath) {
        Field fieldByFieldPath = this.getFieldByFieldPath(form.getTheSelectedStep().getFields(), selectedFieldPath);
        form.setSelectedField(fieldByFieldPath);
        response.setRenderParameter("action", EDIT_VIEW);
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("activeFormTab", "edit");
    }

    private Field getFieldByFieldPath(List<Field> fields, String selectedFieldPath) {
        if (fields != null) {
            for (Field field : fields) {
                if (StringUtils.equals((String)field.getPath(), (String)selectedFieldPath)) {
                    return field;
                }
                Field fieldByPath = this.getFieldByFieldPath(field.getFields(), selectedFieldPath);
                if (fieldByPath == null) continue;
                return fieldByPath;
            }
        }
        return null;
    }

    @ActionMapping(value="editAction", params={"addFilter"})
    public void addFilter(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFilterId") String filterId) throws PortletException {
        int newPath;
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        Map formsFilters = nuxeoController.getNuxeoCMSService().getCMSCustomizer().getFormsFilters();
        FormFilter selectedFilter = (FormFilter)formsFilters.get(filterId);
        if (form.getTheSelectedAction().getFilters().isEmpty()) {
            newPath = 0;
        } else {
            String lastPath = ((Filter)form.getTheSelectedAction().getFilters().get(form.getTheSelectedAction().getFilters().size() - 1)).getFilterPath();
            newPath = Integer.parseInt(lastPath) + 1;
        }
        Filter newFilter = new Filter(selectedFilter, String.valueOf(newPath));
        form.getTheSelectedAction().getFilters().add(newFilter);
        response.setRenderParameter("action", VIEW_ACTION);
    }

    @ActionMapping(value="editAction", params={"deleteFilter"})
    public void deleteFilter(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        if (this.removeFilterByFilterPath(form.getTheSelectedAction().getFilters(), form.getSelectedFilter().getFilterPath())) {
            this.updateFiltersPath(form.getTheSelectedAction().getFilters(), "");
        }
        form.setSelectedFilter(null);
        response.setRenderParameter("action", VIEW_ACTION);
    }

    @ActionMapping(value="editAction", params={"cancelAction"})
    public void cancelAction(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", EDIT_VIEW);
        response.setRenderParameter("activeTab", "action");
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editAction", params={"cancelAction=toStep"})
    public void cancelActionToEditStep(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", EDIT_VIEW);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editAction", params={"cancelAction=toProc"})
    public void cancelActionToEditProcedure(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", CREATE_VIEW);
        sessionStatus.setComplete();
    }

    private void updateFiltersPath(List<Filter> filters, String currentPath) {
        if (filters != null) {
            for (int i = 0; i < filters.size(); ++i) {
                String newPath = currentPath.length() > 0 ? currentPath.concat(",").concat(String.valueOf(i)) : String.valueOf(i);
                filters.get(i).updateFilterPath(newPath);
                this.updateFiltersPath(filters.get(i).getFilters(), newPath);
            }
        }
    }

    private boolean removeFilterByFilterPath(List<Filter> filters, String filterPath) {
        if (filters != null) {
            ListIterator<Filter> filtersI = filters.listIterator();
            while (filtersI.hasNext()) {
                Filter filter = filtersI.next();
                if (StringUtils.equals((String)filter.getFilterPath(), (String)filterPath)) {
                    filtersI.remove();
                    return true;
                }
                if (!this.removeFilterByFilterPath(filter.getFilters(), filterPath)) continue;
                return true;
            }
        }
        return false;
    }

    @ActionMapping(value="editAction", params={"editFilter"})
    public void editFilter(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        this.updateFilterByFilterPath(form.getTheSelectedAction().getFilters(), form.getSelectedFilter());
        response.setRenderParameter("action", VIEW_ACTION);
        response.setRenderParameter("activeTab", "edit");
    }

    @ActionMapping(value="editAction", params={"selectFilter"})
    public void fillEditTab(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFilterPath") String selectedFilterPath) {
        Filter filterByFilterPath = this.getFilterByFilterPath(form.getTheSelectedAction().getFilters(), selectedFilterPath);
        form.setSelectedFilter(filterByFilterPath);
        response.setRenderParameter("action", VIEW_ACTION);
        response.setRenderParameter("activeTab", "edit");
    }

    private Filter getFilterByFilterPath(List<Filter> filtersList, String selectedFilterPath) {
        if (filtersList != null) {
            for (Filter filter : filtersList) {
                if (StringUtils.equals((String)filter.getFilterPath(), (String)selectedFilterPath)) {
                    return filter;
                }
                Filter filterbyId = this.getFilterByFilterPath(filter.getFilters(), selectedFilterPath);
                if (filterbyId == null) continue;
                return filterbyId;
            }
        }
        return null;
    }

    private void updateFilterByFilterPath(List<Filter> filtersList, Filter filterUpdate) {
        if (filtersList != null) {
            for (Filter filter : filtersList) {
                if (StringUtils.equals((String)filter.getFilterPath(), (String)filterUpdate.getFilterPath())) {
                    filter.updateFilter(filterUpdate);
                    return;
                }
                this.updateFilterByFilterPath(filter.getFilters(), filterUpdate);
            }
        }
    }

    @ActionMapping(value="editAction", params={"saveAction"})
    public void saveAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
        response.setRenderParameter("action", EDIT_VIEW);
        response.setRenderParameter("activeTab", "action");
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editAction", params={"updateForm"})
    public void updateFormAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        HashMap allFiltersMap = new HashMap();
        this.addAllFilters(allFiltersMap, form.getTheSelectedAction().getFilters());
        this.rebuildAction(allFiltersMap, form.getTheSelectedAction());
        form.setSelectedFilter(null);
        response.setRenderParameter("action", VIEW_ACTION);
    }

    private void addAllFilters(Map<String, List<Filter>> allFiltersMap, List<Filter> filters) {
        if (filters != null) {
            for (Filter filter : filters) {
                if (filter.getFilterPath() == null) continue;
                String parentPath = filter.getFilterPath().length() > 1 ? StringUtils.substringBeforeLast((String)filter.getFilterPath(), (String)",") : "";
                List<Filter> parentFilters = allFiltersMap.get(parentPath);
                if (parentFilters == null) {
                    parentFilters = new ArrayList<Filter>();
                }
                filter.setFilterInstanceId(filter.getFilterId().concat(filter.getFilterPath()));
                parentFilters.add(filter);
                Collections.sort(parentFilters);
                allFiltersMap.put(parentPath, parentFilters);
                this.addAllFilters(allFiltersMap, filter.getFilters());
            }
        }
    }

    private void rebuildAction(Map<String, List<Filter>> allFiltersMap, Action action) {
        ArrayList<Filter> baseFilters = new ArrayList<Filter>();
        List<Filter> filtersList = allFiltersMap.get("");
        if (filtersList != null) {
            baseFilters.addAll(filtersList);
            Collections.sort(baseFilters);
        }
        this.rebuildFilters(allFiltersMap, baseFilters);
        action.setFilters(baseFilters);
    }

    private void rebuildFilters(Map<String, List<Filter>> allFiltersMap, List<Filter> baseFilters) {
        if (baseFilters != null) {
            for (Filter filter : baseFilters) {
                filter.setFilters(allFiltersMap.get(filter.getFilterPath()));
                this.rebuildFilters(allFiltersMap, filter.getFilters());
            }
        }
    }

    @ActionMapping(value="editStep", params={"deleteField"})
    public void deleteField(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        String[] path = form.getSelectedField().getPath().split(",");
        this.removeFieldByPath(form.getTheSelectedStep().getFields(), path);
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("action", EDIT_VIEW);
    }

    private void removeFieldByPath(List<Field> fields, String[] path) {
        Integer index = Integer.parseInt(path[0]);
        if (path.length == 1 && fields != null) {
            ListIterator<Field> listIterator = fields.listIterator();
            while (listIterator.hasNext()) {
                Field field = listIterator.next();
                String[] pathArray = StringUtils.split((String)field.getPath(), (char)',');
                if (pathArray.length <= 0 || Integer.parseInt(pathArray[pathArray.length - 1]) != index) continue;
                listIterator.remove();
            }
        } else {
            Field nestedField = fields.get(index);
            path = (String[])ArrayUtils.remove((Object[])path, (int)0);
            this.removeFieldByPath(nestedField.getFields(), path);
        }
    }

    private void setMultipartFile(Field field, MultipartActionRequest multipartActionRequest, Form form) {
        if (!field.isFieldSet()) {
            MultipartFile multipartFile;
            if (field.isInput() && (multipartFile = (MultipartFile)multipartActionRequest.getFileMap().get("file:" + field.getName())) != null && multipartFile.getSize() > 0L) {
                FilePath filePath = new FilePath();
                filePath.setFile(multipartFile);
                filePath.setVariableName(field.getName());
                filePath.setFileName(String.valueOf(multipartFile.getOriginalFilename()));
                form.getProcedureInstance().getFilesPath().put(filePath.getVariableName(), filePath);
            }
        } else {
            for (Field nestedField : field.getFields()) {
                this.setMultipartFile(nestedField, multipartActionRequest, form);
            }
        }
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}

