/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.service.impl;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import net.sf.json.JSONArray;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.services.procedure.portlet.adapter.ProcedureJSONAdapter;
import org.osivia.services.procedure.portlet.command.CreateDocumentCommand;
import org.osivia.services.procedure.portlet.command.DeleteDocumentCommand;
import org.osivia.services.procedure.portlet.command.ListModelsContainerCommand;
import org.osivia.services.procedure.portlet.command.ListProceduresModelsCommand;
import org.osivia.services.procedure.portlet.command.LoadVocabularyCommand;
import org.osivia.services.procedure.portlet.command.RetrieveDocumentByWebIdCommand;
import org.osivia.services.procedure.portlet.command.UpdateDocumentCommand;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.FilePath;
import org.osivia.services.procedure.portlet.model.Form;
import org.osivia.services.procedure.portlet.model.ObjetMetier;
import org.osivia.services.procedure.portlet.model.ProcedureInstance;
import org.osivia.services.procedure.portlet.model.ProcedureModel;
import org.osivia.services.procedure.portlet.model.ProcedureObjectInstance;
import org.osivia.services.procedure.portlet.model.Variable;
import org.osivia.services.procedure.portlet.model.VariableTypesEnum;
import org.osivia.services.procedure.portlet.service.IProcedureService;
import org.osivia.services.procedure.portlet.util.ObjetMetierUtil;
import org.osivia.services.procedure.portlet.util.VocabularySelect2Util;
import org.springframework.stereotype.Service;

@Service
public class ProcedureServiceImpl
implements IProcedureService {
    public ProcedureModel createProcedure(NuxeoController nuxeoController, ProcedureModel procedureModel, String Procedurepath) throws PortletException {
        ListModelsContainerCommand command;
        try {
            command = new ListModelsContainerCommand(Procedurepath);
            Document container = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            command = new CreateDocumentCommand(container, procedureModel.getName(), "procedure_" + procedureModel.getNewWebId(), DocumentTypeEnum.PROCEDUREMODEL);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        Document procedureModelInstance = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        return new ProcedureModel(procedureModelInstance, nuxeoController);
    }

    public ProcedureModel retrieveProcedureByWebId(NuxeoController nuxeoController, String path) throws PortletException {
        Document document = null;
        ProcedureModel procedureModel = null;
        try {
            RetrieveDocumentByWebIdCommand command = new RetrieveDocumentByWebIdCommand(path);
            document = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            procedureModel = new ProcedureModel(document, nuxeoController);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return procedureModel;
    }

    public ProcedureModel updateProcedure(NuxeoController nuxeoController, ProcedureModel procedureModel) throws PortletException {
        RetrieveDocumentByWebIdCommand command;
        try {
            command = new RetrieveDocumentByWebIdCommand(procedureModel.getCurrentWebId());
            Document currentDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            PropertyMap propMap = new PropertyMap();
            propMap.set("dc:title", procedureModel.getName());
            propMap.set("ttc:webid", "procedure_" + procedureModel.getNewWebId());
            propMap.set("pcd:steps", ProcedureJSONAdapter.getInstance().toJSON((Object)procedureModel.getSteps()));
            propMap.set("pcd:globalVariablesDefinitions", ProcedureJSONAdapter.getInstance().toJSON(procedureModel.getVariables().values()));
            propMap.set("pcd:startingStep", procedureModel.getStartingStep());
            propMap.set("pcd:procedureObjects", ProcedureJSONAdapter.getInstance().toJSON((Object)procedureModel.getProcedureObjects()));
            command = new UpdateDocumentCommand(currentDocument, propMap);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        Document procedureModelInstance = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        return new ProcedureModel(procedureModelInstance, nuxeoController);
    }

    public void deleteProcedure(NuxeoController nuxeoController, ProcedureModel procedureModel) throws PortletException {
        try {
            RetrieveDocumentByWebIdCommand command = new RetrieveDocumentByWebIdCommand(procedureModel.getCurrentWebId());
            Document currentDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            command = new DeleteDocumentCommand(currentDocument);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public ProcedureInstance retrieveProcedureInstanceByPath(NuxeoController nuxeoController, String path) throws PortletException {
        ProcedureInstance procedureInstance = null;
        try {
            RetrieveDocumentByWebIdCommand command = new RetrieveDocumentByWebIdCommand(path);
            Document currentDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            procedureInstance = new ProcedureInstance(currentDocument);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return procedureInstance;
    }

    public List<ProcedureModel> listProcedures(NuxeoController nuxeoController, IPortalUrlFactory portalUrlFactory, String Procedurepath) throws PortletException {
        Documents documentList;
        ArrayList<ProcedureModel> procedureModels = new ArrayList<ProcedureModel>();
        try {
            ListModelsContainerCommand command = new ListModelsContainerCommand(Procedurepath);
            documentList = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            Document modelsContainer = documentList.get(0);
            command = new ListProceduresModelsCommand(modelsContainer.getPath());
            documentList = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        for (Document document : documentList) {
            ProcedureModel procedureModel = new ProcedureModel(document, nuxeoController);
            try {
                procedureModel.setUrl(this.getEditUrl(nuxeoController, portalUrlFactory, procedureModel, Procedurepath));
            }
            catch (PortalException e) {
                new PortletException((Throwable)e);
            }
            procedureModels.add(procedureModel);
        }
        return procedureModels;
    }

    private String getEditUrl(NuxeoController nuxeoController, IPortalUrlFactory portalUrlFactory, ProcedureModel procedureModel, String Procedurepath) throws PortalException {
        Map windowProperties = this.getWindowProperties(Procedurepath);
        windowProperties.put("osivia.services.procedure.webid", procedureModel.getCurrentWebId());
        windowProperties.put("osivia.title", "\u00c9diter une procedure");
        return portalUrlFactory.getStartPortletUrl(nuxeoController.getPortalCtx(), "osivia-services-procedure-portletInstance", windowProperties, PortalUrlType.DEFAULT);
    }

    private Map<String, String> getWindowProperties(String procedurePath) throws PortalException {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.doctype", DocumentTypeEnum.PROCEDUREMODEL.getName());
        windowProperties.put("osivia.services.procedure.procedurePath", procedurePath);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "true");
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.procedure.admin", "adminproc");
        return windowProperties;
    }

    public String getAddUrl(NuxeoController nuxeoController, IPortalUrlFactory portalUrlFactory, String procedurePath) throws PortletException {
        try {
            Map windowProperties = this.getWindowProperties(procedurePath);
            windowProperties.put("osivia.title", "Cr\u00e9er une procedure");
            return portalUrlFactory.getStartPortletUrl(nuxeoController.getPortalCtx(), "osivia-services-procedure-portletInstance", windowProperties, PortalUrlType.DEFAULT);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void updateFormWithObjectsValues(NuxeoController nuxeoController, Form form) throws PortletException {
        HashMap ojMap = new HashMap();
        for (Field field : form.getTheCurrentStep().getFields()) {
            this.updateFormWithObjectsValues(field, ojMap, nuxeoController, form);
        }
    }

    private void updateFormWithObjectsValues(Field field, Map<String, ObjetMetier> ojMap, NuxeoController nuxeoController, Form form) throws PortletException {
        if (!field.isFieldSet()) {
            if (ObjetMetierUtil.isObject((String)field.getName()) && form.getProcedureInstance().getProcedureObjects().containsKey(ObjetMetierUtil.getObjectName((String)field.getName()))) {
                ObjetMetier objetMetier;
                if (ojMap.containsKey(field.getName())) {
                    objetMetier = ojMap.get(field.getName());
                } else {
                    RetrieveDocumentByWebIdCommand command;
                    try {
                        command = new RetrieveDocumentByWebIdCommand(((ProcedureObjectInstance)form.getProcedureInstance().getProcedureObjects().get(ObjetMetierUtil.getObjectName((String)field.getName()))).getProcedureObjectid());
                    }
                    catch (Exception e) {
                        throw new PortletException((Throwable)e);
                    }
                    Document objetMetierDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
                    nuxeoController.setDisplayLiveVersion("1");
                    String downloadLink = nuxeoController.createFileLink(objetMetierDocument, "file:content");
                    FilePath filePath = new FilePath();
                    filePath.setDownloadLink(downloadLink);
                    filePath.setFileName(objetMetierDocument.getString("file:filename"));
                    objetMetier = new ObjetMetier(objetMetierDocument, filePath);
                    ojMap.put(field.getName(), objetMetier);
                }
                if (ObjetMetierUtil.isContent((String)field.getName())) {
                    if (form.getProcedureInstance().getFilesPath().containsKey(field.getName())) {
                        ((FilePath)form.getProcedureInstance().getFilesPath().get(field.getName())).setDownloadLink(objetMetier.getFilePath().getDownloadLink());
                    } else {
                        form.getProcedureInstance().getFilesPath().put(field.getName(), objetMetier.getFilePath());
                    }
                } else {
                    form.getProcedureInstance().getGlobalVariablesValues().put(field.getName(), objetMetier.getProperties().getString(ObjetMetierUtil.getObjectProperty((String)field.getName())));
                }
            }
        } else {
            for (Field nestedField : field.getFields()) {
                this.updateFormWithObjectsValues(nestedField, ojMap, nuxeoController, form);
            }
        }
    }

    public void updateVocabulariesWithValues(NuxeoController nuxeoController, Form form) throws PortletException {
        Map variables = form.getProcedureModel().getVariables();
        for (Map.Entry entryV : variables.entrySet()) {
            if (!VariableTypesEnum.CHECKBOXVOCAB.equals((Object)((Variable)entryV.getValue()).getType()) && !VariableTypesEnum.RADIOVOCAB.equals((Object)((Variable)entryV.getValue()).getType())) continue;
            ArrayList<String> varOptions = new ArrayList<String>();
            VocabularyEntry vocabularyEntry = VocabularyHelper.getVocabularyEntry((NuxeoController)nuxeoController, (String)((String)((Variable)entryV.getValue()).getVarOptions().get(0)));
            for (VocabularyEntry entry : vocabularyEntry.getChildren().values()) {
                varOptions.add(entry.getLabel());
            }
            ((Variable)entryV.getValue()).setVarOptions(varOptions);
        }
    }

    public JSONArray getVocabularyValues(NuxeoController nuxeoController, String filter, String vocabularyName) throws PortletException {
        JSONArray values = new JSONArray();
        LoadVocabularyCommand command = new LoadVocabularyCommand(vocabularyName);
        Object object = nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                String content = IOUtils.toString((InputStream)blob.getStream(), (String)"UTF-8");
                JSONArray array = JSONArray.fromObject((Object)content);
                values = VocabularySelect2Util.parse((JSONArray)array, (String)filter);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return values;
    }
}

