<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>


<portlet:defineObjects />

<!-- Datepicker language -->
<c:set var="datepickerLanguage" value="${fn:toLowerCase(pageContext.response.locale.language)}" />
<c:if test="${'en' ne datepickerLanguage}">
    <script type="text/javascript" src="/osivia-portal-custom-web-assets/components/jquery-ui/i18n/datepicker-${datepickerLanguage}.js"></script>
</c:if>

<c:if test="${form.advancedMode}">
    <portlet:resourceURL id="groupSearch" var="groupSearchUrl" ></portlet:resourceURL>
</c:if>

<portlet:resourceURL id="fieldSearch" var="fieldSearchUrl" ></portlet:resourceURL>

<c:if test="${!form.advancedMode}">
    <portlet:resourceURL id="stepSearch" var="stepSearchUrl" ></portlet:resourceURL>
</c:if>

<portlet:actionURL name="editStep" var="editStepUrl">
</portlet:actionURL>

<div class="content-navbar">
    <!-- Breadcrumb -->
    <div class="content-navbar-breadcrumb">
        <div id="breadcrumb">
        	<div class="">
				<nav>
				    <ol class="breadcrumb hidden-xs">
			            <li>
				            <portlet:actionURL name="editStep" var="cancelStepUrl">
				            	<portlet:param name="cancelStep" value="toProc"/>
							</portlet:actionURL>
							<a href="${cancelStepUrl}">dition d'une procdure</a>
			            </li>
			            <li><a>dition d'une tape</a></li>
				    </ol>
				</nav>
			</div>
		</div>
    </div>
</div>


<form:form modelAttribute="form" action="${editStepUrl}" method="post" cssClass="form-horizontal" role="form">
    
    <ul class="nav nav-tabs" role="tablist">
        <li role="presentation" class="<c:if test="${empty activeTab or ('form' ne activeTab && 'action' ne activeTab)}">active</c:if>"><a href="#Identification" role="tab" data-toggle="tab" class="no-ajax-link">Identification</a></li>
        <li role="presentation" class="<c:if test="${'form' eq activeTab}">active</c:if>"><a href="#Formulaire" role="tab" data-toggle="tab" class="no-ajax-link">Formulaire</a></li>
        <li role="presentation" class="<c:if test="${'action' eq activeTab}">active</c:if>"><a href="#Actions" role="tab" data-toggle="tab" class="no-ajax-link">Actions</a></li>
        <c:if test="${form.advancedMode}">
            <li role="presentation"><a href="#Mtadonnes" role="tab" data-toggle="tab" class="no-ajax-link">Mtadonnes</a></li>
        </c:if>
    </ul>

    <div class="tab-content">
	    <div role="tabpanel" class="tab-pane <c:if test="${empty activeTab or ('form' ne activeTab && 'action' ne activeTab)}">active</c:if>" id="Identification">
	       <div class="form-group">
               <form:label path="theSelectedStep.stepName" cssClass="col-sm-2 control-label">Titre de l'tape</form:label>
               <div class="col-sm-10">
                   <form:input path="theSelectedStep.stepName" type="text" cssClass="form-control" />
               </div>
           </div>
           <div class="form-group">
               <form:label path="theSelectedStep.reference" cssClass="col-sm-2 control-label">Rference de l'tape</form:label>
               <div class="col-sm-10">
                   <form:input path="theSelectedStep.reference" type="text" cssClass="form-control" />
               </div>
           </div>
	    </div>
	    <div role="tabpanel" class="tab-pane <c:if test="${'form' eq activeTab}">active</c:if>" id="Formulaire">
	       <div class="row">
	           <div class="col-sm-4">
                   <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="<c:if test="${empty activeFormTab or 'edit' ne activeFormTab}">active</c:if>"><a href="#CreateField" role="tab" data-toggle="tab" class="no-ajax-link">Ajouter un champ</a></li>
                        <li role="presentation"><a href="#CreateFieldset" role="tab" data-toggle="tab" class="no-ajax-link">Ajouter un Fieldset</a></li>
		                <c:if test="${not empty form.selectedField}">
		                    <li role="presentation" class="<c:if test="${'edit' eq activeFormTab}">active</c:if>"><a href="#Edit" role="tab" data-toggle="tab" class="no-ajax-link">dition</a></li>
		                </c:if>
                   </ul>
                   <div class="tab-content">
                        <div role="tabpanel" class="tab-pane <c:if test="${empty activeFormTab or 'edit' ne activeFormTab}">active</c:if>" id="CreateField">
                            <div class="form-group">
	                            <form:label path="newField.variableName" cssClass="col-sm-3 control-label">Nom</form:label>
	                            <div class="col-sm-9">
	                                <form:select path="newField.variableName" class="fieldSelect-select2 form-control select2" cssStyle="width: 100%;" data-url="${fieldSearchUrl}">
                                    </form:select>
                                    <span class="help-block">Le nom ne doit pas contenir d'espace.</span>
	                            </div>
	                        </div>
	                        <div class="form-group">
	                            <form:label path="newField.label" cssClass="col-sm-3 control-label">Label</form:label>
	                            <div class="col-sm-9">
	                                <form:input path="newField.label" type="text" cssClass="form-control" placeholder="Label" />
	                                <span class="help-block">Le label tel qu'il apparatra  l'utilisateur.</span>
	                            </div>
	                        </div>
	                        <div class="form-group">
	                            <form:label path="newField.type" cssClass="col-sm-3 control-label">Type</form:label>
	                            <div class="col-sm-9">
	                                <form:select path="newField.type" cssClass="form-control">
	                                    <form:options/>
	                                </form:select>
	                            </div>
	                        </div>
	                        <div class="form-group">
	                            <form:label path="newField.varOptions" cssClass="col-sm-3 control-label">Options</form:label>
	                            <div class="col-sm-9">
	                                <form:input path="newField.varOptions" type="text" cssClass="form-control" placeholder="Options" />
	                            </div>
	                        </div>
	                        <div class="form-group">
	                           <div class="col-sm-offset-3 col-sm-3">
	                               <div class="checkbox">
	                                    <label>
	                                       <form:checkbox path="newField.input"/><span>Saisissable</span>
	                                    </label>
	                                </div>
	                            </div>
	                            <div class="col-sm-3">
                                   <div class="checkbox">
                                        <label>
                                            <form:checkbox path="newField.required"/><span>Requis</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        
                            <button type="submit" name="addField" class="btn btn-default pull-right">Ajouter</button>
                        
                        </div>
                        <div role="tabpanel" class="tab-pane" id="CreateFieldset">
                            <div class="form-group">
                                <form:label path="newFieldSet.variableName" cssClass="col-sm-3 control-label">Nom</form:label>
                                <div class="col-sm-9">
                                    <form:input path="newFieldSet.variableName" type="text" cssClass="form-control" placeholder="Nom" />
                                </div>
                            </div>
                            <div class="form-group">
                                <form:label path="newFieldSet.label" cssClass="col-sm-3 control-label">Label</form:label>
                                <div class="col-sm-9">
                                    <form:input path="newFieldSet.label" type="text" cssClass="form-control" placeholder="Label" />
                                </div>
                            </div>
                            <button type="submit" name="addFieldSet" class="btn btn-default pull-right">Ajouter</button>
                        
                        </div>
                        <c:if test="${not empty form.selectedField}">
                            <div role="tabpanel" class="tab-pane <c:if test="${'edit' eq activeFormTab}">active</c:if>" id="Edit">
                                <c:if test="${form.selectedField.fieldSet eq true}">
                                    <div class="form-group">
                                      <form:label path="selectedField.name" cssClass="col-sm-3 control-label">Nom</form:label>
                                      <div class="col-sm-9">
                                          <form:input path="selectedField.name" type="text" cssClass="form-control" placeholder="Nom" />
                                      </div>
                                     </div>
                                    <div class="form-group">
		                                  <form:label path="selectedField.label" cssClass="col-sm-3 control-label">Label</form:label>
		                                  <div class="col-sm-9">
		                                      <form:input path="selectedField.superLabel" type="text" cssClass="form-control" placeholder="Label" />
		                                  </div>
		                             </div>
		                             
                                </c:if>
                                <c:if test="${form.selectedField.fieldSet ne true}">
	                               <div class="form-group">
				                      <form:label path="selectedField.name" cssClass="col-sm-3 control-label">Nom</form:label>
				                      <div class="col-sm-9">
				                          <form:input path="selectedField.name" type="text" cssClass="form-control" placeholder="Nom" />
				                      </div>
			                         </div>
			                        <div class="form-group">
					                      <form:label path="selectedField.label" cssClass="col-sm-3 control-label">Label</form:label>
					                      <div class="col-sm-9">
					                          <form:input path="selectedField.label" type="text" cssClass="form-control" placeholder="Label" />
					                      </div>
				                     </div>
				                     <div class="form-group">
					                      <form:label path="selectedField.type" cssClass="col-sm-3 control-label">Type</form:label>
					                      <div class="col-sm-9">
					                          <form:select path="selectedField.type" cssClass="form-control">
					                              <form:options/>
					                          </form:select>
					                      </div>
				                     </div>
				                     <div class="form-group">
					                      <form:label path="selectedField.varOptions" cssClass="col-sm-3 control-label">Options</form:label>
					                      <div class="col-sm-9">
					                        <form:input path="selectedField.varOptions" type="text" cssClass="form-control" placeholder="Options" />
					                      </div>
					                  </div>
                                      <div class="form-group">
			                               <div class="col-sm-offset-3 col-sm-3">
			                                   <div class="checkbox">
			                                        <label>
			                                             <form:checkbox path="selectedField.input"/><span>Saisissable</span>
			                                        </label>
			                                    </div>
			                                </div>
			                                <div class="col-sm-3">
			                                   <div class="checkbox">
			                                        <label>
			                                             <form:checkbox path="selectedField.required"/><span>Requis</span>
			                                        </label>
			                                    </div>
			                                </div>
			                            </div>
                                </c:if>
			                  <div class="row">
		                            <div class="col-sm-1 pull-right">
		                               <button type="submit" name="deleteField" class="btn btn-default pull-right">
		                                    <i class="glyphicons glyphicons-bin"></i>
		                                </button>
		                            </div>
		                            <div class="col-sm-1 pull-right">
		                               <button type="submit" name="editField" class="btn btn-default pull-right">Modifier</button>
		                           </div>
		                       </div>
                            </div>
                        </c:if>
                   
                   </div>
	           </div>
	           
		       <div id="procedure-sortable" class="col-sm-8">
	               <ul class="procedure-sortable list-unstyled">
	                   <c:forEach var="field" items="${form.theSelectedStep.fields}" varStatus="status">
	                      <li class="form-group">
	                          <c:choose>
	                            <c:when test="${field.fieldSet eq true}">
	                              <c:set var="field" value="${field}" scope="request"/>
	                              <jsp:include page="editFields.jsp"/>
	                            </c:when>
	                            <c:otherwise>
	                              <c:set var="field" value="${field}" scope="request"/>
	                              <jsp:include page="editField.jsp"/>
	                            </c:otherwise>
	                          </c:choose>
	                      </li>
	                   </c:forEach>
	                   <form:input path="selectedStep" type="hidden" name="selectedStep"/>
	               </ul>
	           </div>
            </div>
	    </div>
	    <div role="tabpanel" class="tab-pane <c:if test="${'action' eq activeTab}">active</c:if>" id="Actions">
	       <ul class="list-unstyled">
	              <li class="form-group">
	                 <div class="col-sm-2">
	                     <label class="control-label">Label</label>
	                 </div>
	                 <div class="col-sm-4">
	                     <label class="control-label">Identifiant de l'action</label>
	                 </div>
	                 <div class="col-sm-4">
	                     <label class="control-label">tape cible</label>
	                 </div>
	              </li>
	              <c:forEach var="action" items="${form.theSelectedStep.actions}" varStatus="status">
	                  <li class="form-group">
	                      <div class="col-sm-2">
	                          <form:input path="theSelectedStep.actions[${status.index}].label" type="text" cssClass="form-control" placeholder="Label" />
	                      </div>
	                      <div class="col-sm-4">
	                          <form:input path="theSelectedStep.actions[${status.index}].actionId" type="text" cssClass="form-control" placeholder="actionId" />
	                      </div>
	                      <c:if test="${form.advancedMode}">
		                      <div class="col-sm-4">
		                          <form:input path="theSelectedStep.actions[${status.index}].stepReference" type="text" cssClass="form-control" placeholder="stepReference" />
		                      </div>
	                      </c:if>
	                      <c:if test="${!form.advancedMode}">
	                           <div class="col-sm-4">
			                        <form:select path="theSelectedStep.actions[${status.index}].stepReference" class="stepSelect-select2 form-control select2" cssStyle="width: 100%;" data-url="${stepSearchUrl}">
			                           <form:option value="${form.theSelectedStep.actions[status.index].stepReference}" />
			                        </form:select>
		                        </div>
	                       </c:if>
	                      
	                      <div class="btn-group col-sm-2">
	                          <button type="submit" name="editButton" class="btn btn-default" onclick="selector(this,'${status.index}','selectedButton')">
	                              <i class="glyphicons glyphicons-edit"></i>
	                          </button>
	                          <button type="submit" name="deleteButton" class="btn btn-default" onclick="selector(this,'${status.index}','selectedButton')">
	                              <i class="glyphicons glyphicons-remove-2"></i>
	                          </button>
	                      </div>
	                  </li>
	              </c:forEach>
	          </ul>
           <div class="form-group">
		       <div class="col-sm-1">
	               <button type="submit" name="addButton" class="btn btn-default">Ajouter une action</button>
	           </div>
           </div>
	    </div>
	    <c:if test="${form.advancedMode}">
		    <div role="tabpanel" class="tab-pane" id="Mtadonnes">
		       <div class="form-group">
		           <div class="col-sm-offset-2 col-sm-1">
			           <div class="checkbox">
		                    <label>
		                       <form:checkbox path="theSelectedStep.notifiable"/><span>notifiable</span>
		                    </label>
		                </div>
	                </div>
	                <div class="col-sm-1">
		                <div class="checkbox">
		                    <label>
		                       <form:checkbox path="theSelectedStep.acquitable"/><span>acquitable</span>
		                    </label>
		                </div>
	                </div>
		           <div class="col-sm-1">
			           <div class="checkbox">
			                <label>
			                      <form:checkbox path="theSelectedStep.closable"/><span>closable</span>
			                </label>
		                </div>
	                </div>
		       </div>
	           <div class="form-group">
	               <form:label path="theSelectedStep.actionIdClosable" cssClass="col-sm-2 control-label">actionIdClosable</form:label>
	               <div class="col-sm-10">
	                   <form:input path="theSelectedStep.actionIdClosable" type="text" cssClass="form-control" />
	               </div>
	           </div>
	           <div class="form-group">
	               <form:label path="theSelectedStep.stringMsg" cssClass="col-sm-2 control-label">stringMsg</form:label>
	               <div class="col-sm-10">
	                   <form:input path="theSelectedStep.stringMsg" type="text" cssClass="form-control" />
	               </div>
	           </div>
	           <div class="form-group">
	               <form:label path="theSelectedStep.actionIdYes" cssClass="col-sm-2 control-label">actionIdYes</form:label>
	               <div class="col-sm-10">
	                   <form:input path="theSelectedStep.actionIdYes" type="text" cssClass="form-control" />
	               </div>
	           </div>
	           <div class="form-group">
	               <form:label path="theSelectedStep.actionIdNo" cssClass="col-sm-2 control-label">actionIdNo</form:label>
	               <div class="col-sm-10">
	                   <form:input path="theSelectedStep.actionIdNo" type="text" cssClass="form-control" />
	               </div>
	           </div>
	           <div class="form-group">
	               <form:label path="theSelectedStep.actionIdDefault" cssClass="col-sm-2 control-label">actionIdDefault</form:label>
	               <div class="col-sm-10">
	                   <form:input path="theSelectedStep.actionIdDefault" cssClass="form-control" />
	               </div>
	           </div>
		       <ul class="list-unstyled">
	               <li class="form-group">
	                   <form:label path="theSelectedStep.groups" cssClass="col-sm-2 control-label">Groupes</form:label>
	                   <div class="col-sm-10">
	                       <form:select path="theSelectedStep.groups" multiple="multiple" class="groupSelect-select2 form-control select2" cssStyle="width: 100%;" data-url="${groupSearchUrl}">
	                           <form:options items="${form.theSelectedStep.groups}" />
	                       </form:select>
	                   </div>
	               </li>
	           </ul>
		    </div>
	    </c:if>
	</div>
    <hr>
    <div class="row">
        <div class="col-sm-1">
            <button type="submit" class="btn btn-default" name="cancelStep">Annuler</button>
        </div>
        <c:if test="${!form.advancedMode}">
            <div class="col-sm-1">
                <button type="submit" class="btn btn-info" name="changeMode">Mode avan</button>
            </div>
        </c:if>
        <c:if test="${form.advancedMode}">
            <div class="col-sm-1">
                <button type="submit" class="btn btn-info" name="changeMode">Mode simplifi</button>
            </div>
        </c:if>
        <div class="col-sm-1 pull-right">
            <button type="submit" class="btn btn-danger pull-right" name="deleteStep">Supprimer</button>
        </div>
        <div class="col-sm-1 pull-right">
            <button type="submit" class="btn btn-primary pull-right" name="saveStep">Sauvegarder</button>
        </div>
        <input type="submit" class="hidden" name="updateForm">
        <input type="submit" class="hidden" name="selectField">
    </div>
</form:form>