/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;
import org.osivia.services.procedure.portlet.model.NuxeoOperationEnum;

public class CreateDocumentCommand
implements INuxeoCommand {
    private Document path;
    private String name;
    private DocumentTypeEnum type;
    private String webId;
    private PropertyMap properties;

    public CreateDocumentCommand(Document path, String name, String webId, PropertyMap properties, DocumentTypeEnum type) {
        this.path = path;
        this.name = name;
        this.type = type;
        this.properties = properties;
        this.webId = webId;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest(NuxeoOperationEnum.CreateDocument.getId());
        request.setHeader("X-NXDocumentProperties", "*");
        request.setHeader("nx_es_sync", "true");
        request.setInput((OperationInput)this.path);
        this.properties.set("dc:title", this.name);
        this.properties.set("ttc:webid", this.webId);
        request.set("type", (Object)this.type.getName()).set("properties", (Object)this.properties);
        return request.execute();
    }

    public String getId() {
        return "CreateDocumentCommand/" + this.path + "/" + this.type + "/" + this.name + "/" + this.webId + "/" + this.properties;
    }
}

