/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.plugin;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import fr.toutatice.portail.cms.nuxeo.api.plugin.PluginModule;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.player.Player;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;
import org.osivia.services.procedure.portlet.model.ProcedureTypeEnum;

public class ProcedurePlayer
extends PluginModule
implements INuxeoPlayerModule {
    public ProcedurePlayer(PortletContext portletContext) {
        super(portletContext);
    }

    private Player getProcedureInstancePlayer(DocumentContext<Document> docCtx) {
        Document document = (Document)docCtx.getDoc();
        BasicPublicationInfos publicationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        String displayContext = publicationInfos.getDisplayContext();
        Map windowProperties = this.getProcedureWindowProperties(document);
        windowProperties.put("osivia.title", document.getTitle());
        windowProperties.put("osivia.procedure.admin", displayContext);
        Player linkProps = this.getProcedurePlayer(windowProperties);
        return linkProps;
    }

    private Map<String, String> getProcedureWindowProperties(Document document) {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.services.procedure.webid", document.getProperties().getString("ttc:webid"));
        windowProperties.put("osivia.doctype", document.getType());
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "true");
        windowProperties.put("osivia.ajaxLink", "1");
        return windowProperties;
    }

    private Player getProcedureModelPlayer(DocumentContext<Document> docCtx) {
        Document document = (Document)docCtx.getDoc();
        BasicPublicationInfos publicationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        String displayContext = publicationInfos.getDisplayContext();
        String procedureType = document.getProperties().getString("pcd:procedureType");
        if (StringUtils.equals((String)ProcedureTypeEnum.LIST.name(), (String)procedureType)) {
            if (StringUtils.equals((String)displayContext, (String)"adminlist") || StringUtils.equals((String)displayContext, (String)"listadditem")) {
                Map windowProperties = this.getProcedureWindowProperties(document);
                windowProperties.put("osivia.procedure.admin", displayContext);
                windowProperties.put("osivia.title", "\u00c9diter une liste");
                windowProperties.put("osivia.services.procedure.procType", procedureType);
                return this.getProcedurePlayer(windowProperties);
            }
            Map windowProperties = this.viewListWindowProperties(docCtx, document, publicationInfos);
            Player player = new Player();
            player.setWindowProperties(windowProperties);
            player.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
            return player;
        }
        Map windowProperties = this.getProcedureWindowProperties(document);
        if (StringUtils.equals((String)displayContext, (String)"adminproc") || StringUtils.equals((String)displayContext, (String)"adminprocstep")) {
            windowProperties.put("osivia.procedure.admin", displayContext);
            windowProperties.put("osivia.title", "\u00c9diter une proc\u00e9dure");
            return this.getProcedurePlayer(windowProperties);
        }
        windowProperties.put("osivia.title", document.getTitle());
        return this.getProcedurePlayer(windowProperties);
    }

    private Player getProcedurePlayer(Map<String, String> windowProperties) {
        Player player = new Player();
        player.setWindowProperties(windowProperties);
        player.setPortletInstance("osivia-services-procedure-portletInstance");
        return player;
    }

    private Map<String, String> viewListWindowProperties(DocumentContext<Document> docCtx, Document document, BasicPublicationInfos publicationInfos) {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", NuxeoController.createFolderRequest(docCtx, (boolean)false));
        windowProperties.put("osivia.cms.style", "listproc");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", publicationInfos.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", "1");
        windowProperties.put("osivia.document.metadata", String.valueOf(false));
        windowProperties.put("osivia.title", document.getTitle());
        windowProperties.put("osivia.useES", "true");
        if (docCtx.getDoc() != null) {
            windowProperties.put("osivia.createParentPath", ((Document)docCtx.getDoc()).getPath());
        }
        return windowProperties;
    }

    public Player getCMSPlayer(DocumentContext<Document> docCt) {
        Document doc = (Document)docCt.getDoc();
        String docType = doc.getType();
        if (StringUtils.equals((String)docType, (String)DocumentTypeEnum.PROCEDUREINSTANCE.getName())) {
            return this.getProcedureInstancePlayer(docCt);
        }
        if (StringUtils.equals((String)docType, (String)DocumentTypeEnum.PROCEDUREMODEL.getName())) {
            return this.getProcedureModelPlayer(docCt);
        }
        return null;
    }
}

