/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.formFilters;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterParameterType;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.services.procedure.formFilters.RecordFormFilter;
import org.osivia.services.procedure.formFilters.UpdateRecordCommand;

public class EditRecordFilter
extends RecordFormFilter {
    public static final String ID = "EditRecordFilter";
    private static final String LABEL_KEY = "EDIT_RECORD_FILTER_LABEL";
    private static final String DESCRIPTION_KEY = "EDIT_RECORD_FILTER_DESCRIPTION";
    private static final String NOTIFICATION_KEY = "RECORD_EDITED_NOTIFICATION";
    private final IBundleFactory bundleFactory;

    public EditRecordFilter() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public String getId() {
        return ID;
    }

    public String getLabelKey() {
        return LABEL_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public Map<String, FormFilterParameterType> getParameters() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public void execute(FormFilterContext context, FormFilterExecutor executor) throws FormFilterException {
        NuxeoController nuxeoController = new NuxeoController(context.getPortalControllerContext());
        String fetchPath = NuxeoController.webIdToFetchPath((String)context.getModelWebId());
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(fetchPath);
        Document recordFolder = documentContext.getDocument();
        PropertyMap properties = recordFolder.getProperties();
        PropertyList globalVariablesReferences = this.getGlobalVariablesReferences("formulaire", properties);
        PropertyMap updateProperties = new PropertyMap();
        HashMap variables = new HashMap();
        for (Object variableREfO : globalVariablesReferences.list()) {
            PropertyMap variableREfM = (PropertyMap)variableREfO;
            String variableName = variableREfM.getString("variableName");
            variables.put(variableName, context.getVariables().get(variableName));
        }
        updateProperties.set("rcd:globalVariablesValues", this.generateVariablesJSON(variables));
        updateProperties.set("rcd:procedureModelWebId", context.getModelWebId());
        Document editedRecord = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new UpdateRecordCommand(new DocRef((String)context.getVariables().get("rcdPath")), updateProperties));
        context.getVariables().put("_redirectCmsPath", editedRecord.getPath());
        context.getVariables().put("_notificationMessage", this.bundleFactory.getBundle(nuxeoController.getRequest().getLocale()).getString(NOTIFICATION_KEY));
    }
}

