/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.plugin;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import java.util.List;
import java.util.Map;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.services.procedure.formFilters.CreateRecordFilter;
import org.osivia.services.procedure.formFilters.DefineVariableFilter;
import org.osivia.services.procedure.formFilters.DeleteOnEndingFormFilter;
import org.osivia.services.procedure.formFilters.DeleteRecordFilter;
import org.osivia.services.procedure.formFilters.EditRecordFilter;
import org.osivia.services.procedure.formFilters.IfFilter;
import org.osivia.services.procedure.formFilters.SendMailFilter;
import org.osivia.services.procedure.formFilters.SetActorFormFilter;
import org.osivia.services.procedure.formFilters.SetAdditionalAuthorization;
import org.osivia.services.procedure.formFilters.SetInitiatorVariableFilter;
import org.osivia.services.procedure.formFilters.ThrowExceptionFilter;
import org.osivia.services.procedure.plugin.ProcedureMenubarModule;
import org.osivia.services.procedure.plugin.ProcedurePlayer;

public class ProcedurePlugin
extends AbstractPluginPortlet {
    private static final String CUSTOMIZER_NAME = "procedure.plugin";
    public static final String STYLE_VIEW_CONTAINER = "containerlist";
    public static final String STYLE_ADMIN = "adminproc";
    public static final String SCHEMAS_PROCEDUREINSTANCE = "dublincore, common, toutatice, procedure, procedureInstance";
    public static final String SCHEMAS_ADMIN = "dublincore, common, toutatice";
    private final IBundleFactory bundleFactory;

    public ProcedurePlugin() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    protected void customizeCMSProperties(CustomizationContext context) {
        this.updateDocTypes(context);
        this.updatePlayers(context);
        this.updateFormFilters(context);
        this.updateListTemplates(context);
        this.customizeMenubarModules(context);
    }

    private void updateListTemplates(CustomizationContext context) {
        Bundle bundle = this.bundleFactory.getBundle(context.getLocale());
        Map listTemplates = this.getListTemplates(context);
        ListTemplate container = new ListTemplate(STYLE_VIEW_CONTAINER, bundle.getString("LIST_TEMPLATE_CONTAINER"), SCHEMAS_ADMIN);
        listTemplates.put(container.getKey(), container);
    }

    private void updatePlayers(CustomizationContext context) {
        List modules = this.getPlayers(context);
        modules.add(0, new ProcedurePlayer(this.getPortletContext()));
    }

    private void updateDocTypes(CustomizationContext context) {
        Map docTypes = this.getDocTypes(context);
        DocumentType recordContainer = DocumentType.createNode((String)"RecordContainer");
        recordContainer.addSubtypes(new String[]{"RecordFolder"});
        recordContainer.setIcon("glyphicons glyphicons-flowchart");
        recordContainer.setNavigable(true);
        recordContainer.setPreventedCreation(true);
        docTypes.put(recordContainer.getName(), recordContainer);
        DocumentType recordFolder = DocumentType.createNode((String)"RecordFolder");
        recordFolder.addSubtypes(new String[]{"Record"});
        recordFolder.setIcon("glyphicons glyphicons-list-alt");
        recordFolder.setNavigable(true);
        recordFolder.setPreventedCreation(true);
        docTypes.put(recordFolder.getName(), recordFolder);
        DocumentType record = DocumentType.createLeaf((String)"Record");
        record.setIcon("glyphicons glyphicons-list");
        docTypes.put(record.getName(), record);
        DocumentType tasks = DocumentType.createLeaf((String)"TaskDoc");
        docTypes.put(tasks.getName(), tasks);
    }

    private void updateFormFilters(CustomizationContext context) {
        Map formFilters = this.getFormFilters(context);
        formFilters.put("IfFilter", new IfFilter());
        formFilters.put("DefineVarFilter", new DefineVariableFilter());
        formFilters.put("SendMailFilter", new SendMailFilter());
        formFilters.put("SET_ACTOR", new SetActorFormFilter());
        formFilters.put("ThrowExceptionFilter", new ThrowExceptionFilter());
        formFilters.put("DeleteOnEnding", new DeleteOnEndingFormFilter());
        formFilters.put("SET_ADDITIONAL_AUTHORIZATION", new SetAdditionalAuthorization());
        formFilters.put("SET_INITIATOR_VARIABLE", new SetInitiatorVariableFilter());
        formFilters.put("CreateRecordFilter", new CreateRecordFilter());
        formFilters.put("EditRecordFilter", new EditRecordFilter());
        formFilters.put("DeleteRecordFilter", new DeleteRecordFilter());
    }

    protected String getPluginName() {
        return CUSTOMIZER_NAME;
    }

    private void customizeMenubarModules(CustomizationContext context) {
        List modules = this.getMenubarModules(context);
        ProcedureMenubarModule mbModule = new ProcedureMenubarModule();
        modules.add(mbModule);
    }
}

