/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONArray;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Group;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.services.procedure.portlet.model.Action;
import org.osivia.services.procedure.portlet.model.AddField;
import org.osivia.services.procedure.portlet.model.Column;
import org.osivia.services.procedure.portlet.model.Dashboard;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.FilePath;
import org.osivia.services.procedure.portlet.model.Filter;
import org.osivia.services.procedure.portlet.model.Form;
import org.osivia.services.procedure.portlet.model.ProcedureInstance;
import org.osivia.services.procedure.portlet.model.ProcedureModel;
import org.osivia.services.procedure.portlet.model.ProcedureObject;
import org.osivia.services.procedure.portlet.model.ProcedureRepository;
import org.osivia.services.procedure.portlet.model.Record;
import org.osivia.services.procedure.portlet.model.Step;
import org.osivia.services.procedure.portlet.model.Variable;
import org.osivia.services.procedure.portlet.model.VariableTypesEnum;
import org.osivia.services.procedure.portlet.model.WebIdException;
import org.osivia.services.procedure.portlet.service.IProcedureService;
import org.osivia.services.procedure.portlet.util.VariableTypesEnumJsonSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;
import org.springframework.web.portlet.multipart.MultipartActionRequest;

@Controller
@SessionAttributes(value={"form"})
@RequestMapping(value={"VIEW"})
public class ProcedurePortletController
extends CMSPortlet
implements PortletContextAware,
PortletConfigAware {
    private static final String CREATE_VIEW = "editProcedure";
    private static final String EDIT_VIEW = "editStep";
    private static final String EDIT_RECORD_VIEW = "editRecord";
    private static final String DISPLAY_RECORD_VIEW = "displayRecord";
    private static final String EDIT_TDB = "editTdb";
    private static final String VIEW_PROCEDURE = "viewProcedure";
    private static final String VIEW_ENDSTEP = "endStep";
    private static final String VIEW_ACTION = "editAction";
    private static final String LIST_PROC_VIEW = "list";
    private static final String DETAIL_PROC = "detailProc";
    private static final String MANAGE_VIEW = "manageVariables";
    private static final String DASHBOARD_VIEW = "procedureDashboard";
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    @Autowired
    private IProcedureService procedureService;
    private GroupService groupService = (GroupService)DirServiceFactory.getService(GroupService.class);
    private final IBundleFactory bundleFactory;

    public ProcedurePortletController() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String defaultView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.defaultRenderAction(nuxeoController);
        if (StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.RECORDFOLDER.getDocType())) {
            if (StringUtils.equals((String)this.getAction((PortletRequest)request), (String)"adminrecord")) {
                return EDIT_RECORD_VIEW;
            }
            if (this.getWebId((PortletRequest)request) != null) {
                return VIEW_PROCEDURE;
            }
            return LIST_PROC_VIEW;
        }
        if (StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.RECORD.getDocType())) {
            if (StringUtils.isNotBlank((String)this.getAction((PortletRequest)request))) {
                return VIEW_PROCEDURE;
            }
            return DISPLAY_RECORD_VIEW;
        }
        if (StringUtils.isBlank((String)this.getDocType((PortletRequest)request)) && StringUtils.isNotBlank((String)this.getDashboardPath((PortletRequest)request))) {
            return DASHBOARD_VIEW;
        }
        if (StringUtils.equals((String)this.getAction((PortletRequest)request), (String)"adminproc")) {
            return CREATE_VIEW;
        }
        if (StringUtils.equals((String)this.getAction((PortletRequest)request), (String)"adminprocstep")) {
            return EDIT_VIEW;
        }
        if (StringUtils.equals((String)this.getAction((PortletRequest)request), (String)"detailproc")) {
            return DETAIL_PROC;
        }
        if (this.getWebId((PortletRequest)request) != null || this.getId((PortletRequest)request) != null) {
            return VIEW_PROCEDURE;
        }
        return LIST_PROC_VIEW;
    }

    @RenderMapping(params={"action=editProcedure"})
    public String editProcedureView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        return CREATE_VIEW;
    }

    @RenderMapping(params={"action=editStep"})
    public String editStepView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        request.setAttribute("activeTab", (Object)request.getParameter("activeTab"));
        request.setAttribute("activeFormTab", (Object)request.getParameter("activeFormTab"));
        return EDIT_VIEW;
    }

    @RenderMapping(params={"action=editTdb"})
    public String editTdbView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        return EDIT_TDB;
    }

    @RenderMapping(params={"action=editRecord"})
    public String editRecordView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        request.setAttribute("activeTab", (Object)request.getParameter("activeTab"));
        request.setAttribute("activeFormTab", (Object)request.getParameter("activeFormTab"));
        return EDIT_RECORD_VIEW;
    }

    @RenderMapping(params={"action=editAction"})
    public String endStepView(RenderRequest request, RenderResponse response, @RequestParam(value="editAction", required=false) String editAction) throws PortletException, CMSException {
        request.setAttribute("activeTab", (Object)request.getParameter("activeTab"));
        return VIEW_ACTION;
    }

    @RenderMapping(params={"action=viewProcedure"})
    public String viewProcedure(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        return VIEW_PROCEDURE;
    }

    @RenderMapping(params={"action=manageVariables"})
    public String viewManageVariables(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        return MANAGE_VIEW;
    }

    @RenderMapping(params={"action=endStep"})
    public String endStepView(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        String closeUrl = this.procedureService.getCloseUrl(portalControllerContext);
        request.setAttribute("closeUrl", (Object)closeUrl);
        return VIEW_ENDSTEP;
    }

    private void defaultRenderAction(NuxeoController nuxeoController) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        String dashboardPath = this.getDashboardPath(nuxeoController.getRequest());
        if (StringUtils.isNotBlank((String)nuxeoPath)) {
            nuxeoPath = nuxeoController.getComputedPath(nuxeoPath);
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(nuxeoPath);
            Document document = documentContext.getDocument();
            nuxeoController.setCurrentDoc(document);
            nuxeoController.insertContentMenuBarItems();
        } else if (StringUtils.isNotBlank((String)dashboardPath)) {
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(dashboardPath);
            Document document = documentContext.getDocument();
            nuxeoController.setCurrentDoc(document);
            nuxeoController.insertContentMenuBarItems();
        }
    }

    @ModelAttribute(value="form")
    public Form getForm(PortletRequest request, PortletResponse response, @RequestParam(value="selectedStep", required=false) String selectedStep) throws PortletException {
        Form form;
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        if (StringUtils.isNotEmpty((String)this.getWebId(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.PROCEDUREMODEL.getDocType())) {
            ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, this.getWebId(request));
            form = new Form(procedureModel);
            form.setSelectedStep(StringUtils.defaultIfBlank((String)selectedStep, (String)"0"));
            if (!StringUtils.equals((String)this.getAction(request), (String)"adminproc") && !StringUtils.equals((String)this.getAction(request), (String)"adminprocstep")) {
                try {
                    Map initVariables = nuxeoController.getNuxeoCMSService().getFormsService().init(nuxeoController.getPortalCtx(), procedureModel.getOriginalDocument(), null);
                    form.setProcedureInstance(new ProcedureInstance(initVariables));
                }
                catch (PortalException e) {
                    throw new PortletException((Throwable)e);
                }
                catch (FormFilterException e) {
                    this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), e.getMessage(), NotificationsType.ERROR);
                }
            }
            if (!StringUtils.equals((String)this.getAction(request), (String)"adminproc") && !StringUtils.equals((String)this.getAction(request), (String)"adminprocstep")) {
                this.procedureService.updateData(nuxeoController, form);
            }
        } else if (StringUtils.isNotEmpty((String)this.getWebId(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.PROCEDUREINSTANCE.getDocType())) {
            ProcedureInstance procedureInstance = this.procedureService.retrieveProcedureInstanceByWebId(nuxeoController, this.getWebId(request));
            ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, procedureInstance.getProcedureModelWebId());
            form = new Form(procedureModel, procedureInstance);
            this.procedureService.updateData(nuxeoController, form);
        } else if (StringUtils.isNotEmpty((String)this.getId(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.TASKDOC.getDocType())) {
            ProcedureInstance procedureInstance = this.procedureService.retrieveProcedureInstanceById(nuxeoController, this.getId(request));
            ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, procedureInstance.getProcedureModelWebId());
            form = new Form(procedureModel, procedureInstance);
            try {
                Map initVariables = nuxeoController.getNuxeoCMSService().getFormsService().init(nuxeoController.getPortalCtx(), procedureInstance.getOriginalDocument(), null);
                procedureInstance.getGlobalVariablesValues().putAll(initVariables);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
            catch (FormFilterException e) {
                this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), e.getMessage(), NotificationsType.ERROR);
            }
            this.procedureService.updateData(nuxeoController, form);
        } else if (StringUtils.isNotEmpty((String)this.getWebId(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.RECORDFOLDER.getDocType())) {
            if (StringUtils.equals((String)this.getAction(request), (String)"adminrecord")) {
                ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, this.getWebId(request));
                form = new Form(procedureModel);
            } else {
                ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, this.getWebId(request));
                form = new Form(procedureModel);
                try {
                    HashMap<String, String> variables = new HashMap<String, String>();
                    variables.put("pcd:startingStep", this.getAction(request));
                    Map initVariables = nuxeoController.getNuxeoCMSService().getFormsService().init(nuxeoController.getPortalCtx(), procedureModel.getOriginalDocument(), variables);
                    form.getProcedureModel().setStartingStep((String)initVariables.get("pcd:startingStep"));
                    form.setProcedureInstance(new ProcedureInstance(initVariables));
                }
                catch (PortalException e) {
                    throw new PortletException((Throwable)e);
                }
                catch (FormFilterException e) {
                    this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), e.getMessage(), NotificationsType.ERROR);
                }
                this.procedureService.updateData(nuxeoController, form);
            }
        } else if (StringUtils.isNotEmpty((String)this.getWebId(request)) && StringUtils.equals((String)this.getDocType(request), (String)DocumentTypeEnum.RECORD.getDocType())) {
            Record record = this.procedureService.retrieveRecordInstanceByWebId(nuxeoController, this.getWebId(request));
            ProcedureModel procedureModel = this.procedureService.retrieveProcedureByWebId(nuxeoController, record.getProcedureModelWebId());
            form = new Form(procedureModel, record);
            if (StringUtils.isNotBlank((String)this.getAction(request))) {
                try {
                    HashMap<String, String> variables = new HashMap<String, String>();
                    variables.put("pcd:startingStep", this.getAction(request));
                    variables.put("rcdPath", record.getOriginalDocument().getPath());
                    variables.put("rcdFolderPath", procedureModel.getOriginalDocument().getPath());
                    variables.putAll(record.getGlobalVariablesValues());
                    Map initVariables = nuxeoController.getNuxeoCMSService().getFormsService().init(nuxeoController.getPortalCtx(), procedureModel.getOriginalDocument(), variables);
                    form.getProcedureModel().setStartingStep((String)initVariables.get("pcd:startingStep"));
                    form.setProcedureInstance(new ProcedureInstance(initVariables));
                }
                catch (PortalException e) {
                    throw new PortletException((Throwable)e);
                }
                catch (FormFilterException e) {
                    this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), e.getMessage(), NotificationsType.ERROR);
                }
            }
            this.procedureService.updateData(nuxeoController, form);
        } else if (StringUtils.isNotBlank((String)this.getDashboardPath(request))) {
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(this.getDashboardPath(request));
            form = new Form(new ProcedureModel(documentContext.getDocument(), nuxeoController));
        } else {
            form = StringUtils.equals((String)this.getAction(request), (String)"adminproc") ? new Form() : (StringUtils.equals((String)this.getAction(request), (String)"adminrecord") ? new Form(ProcedureRepository.recordFolder()) : new Form());
        }
        if (response instanceof RenderResponse && form.getProcedureModel() != null) {
            ((RenderResponse)response).setTitle(form.getProcedureModel().getName());
        }
        return form;
    }

    @ModelAttribute(value="procedureList")
    public List<ProcedureModel> getListProcedureModel(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        String procedurePath = this.getProcedurePath(request);
        return procedurePath != null ? this.procedureService.listProcedures(nuxeoController, procedurePath) : null;
    }

    @ModelAttribute(value="editProcedureUrl")
    public String getEditProcedureUrl(PortletRequest request, PortletResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        String editProcedureUrl = null;
        if (form.getProcedureModel() != null && form.getProcedureModel().getOriginalDocument() != null) {
            try {
                CMSPublicationInfos publicationInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), form.getProcedureModel().getPath());
                if (publicationInfos.isEditableByUser()) {
                    editProcedureUrl = nuxeoController.getLink(form.getProcedureModel().getOriginalDocument(), "adminproc").getUrl();
                }
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return editProcedureUrl;
    }

    @ModelAttribute(value="linkProcedureUrl")
    public String getLinkProcedureUrl(PortletRequest request, PortletResponse response, @ModelAttribute(value="form") Form form) {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        return form.getProcedureModel() != null && form.getProcedureModel().getOriginalDocument() != null ? nuxeoController.getLink(form.getProcedureModel().getOriginalDocument()).getUrl() : null;
    }

    @ModelAttribute(value="addProcedureUrl")
    public String getAddProcedureUrl(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        String procedurePath = this.getProcedurePath(request);
        return this.procedureService.getAddUrl(nuxeoController, procedurePath, "adminproc", DocumentTypeEnum.PROCEDUREMODEL.getDocType());
    }

    @ModelAttribute(value="addRecordFolderUrl")
    public String getAddRecordFolderUrl(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        String procedurePath = this.getProcedurePath(request);
        return this.procedureService.getAddUrl(nuxeoController, procedurePath, "adminrecord", DocumentTypeEnum.RECORDFOLDER.getDocType());
    }

    @ModelAttribute(value="listeFiltres")
    public List<FormFilter> getListeFiltres(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        Map formsFilters = nuxeoController.getNuxeoCMSService().getCMSCustomizer().getFormsFilters();
        ArrayList<FormFilter> listeFiltres = new ArrayList<FormFilter>(formsFilters.size());
        for (Map.Entry entryFilter : formsFilters.entrySet()) {
            listeFiltres.add((FormFilter)entryFilter.getValue());
        }
        return listeFiltres;
    }

    @ModelAttribute(value="webIdPrefix")
    public String getWebIdPrefix(PortletRequest request, PortletResponse response) {
        return "procedure_";
    }

    @ResourceMapping(value="groupSearch")
    public void getProfils(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter) throws PortletException {
        Group searchGroup = this.groupService.getEmptyGroup();
        searchGroup.setCn(filter + "*");
        List groups = this.groupService.search(searchGroup);
        ArrayList<Map> listeProfils = new ArrayList<Map>(groups.size());
        for (Group group : groups) {
            listeProfils.add(this.buildProfilEntry(group));
        }
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), listeProfils);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private Map<String, String> buildProfilEntry(Group group) {
        HashMap<String, String> superAdministrators = new HashMap<String, String>(2);
        superAdministrators.put("cn", group.getCn());
        superAdministrators.put("displayName", group.getCn());
        return superAdministrators;
    }

    @ResourceMapping(value="stepSearch")
    public void getSteps(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="filter", required=false) String filter) throws PortletException {
        ArrayList listeSteps = new ArrayList();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        List steps = form.getProcedureModel().getSteps();
        for (Step step : steps) {
            if (filter != null && !StringUtils.contains((String)step.getStepName(), (String)filter) && !StringUtils.contains((String)step.getReference(), (String)filter)) continue;
            HashMap<String, String> demoGroup = new HashMap<String, String>(2);
            demoGroup.put("id", step.getReference());
            demoGroup.put("text", step.getStepName());
            listeSteps.add(demoGroup);
        }
        HashMap<String, String> demoGroup = new HashMap<String, String>(2);
        demoGroup.put("id", VIEW_ENDSTEP);
        demoGroup.put("text", bundle.getString("END_STEP"));
        listeSteps.add(demoGroup);
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), listeSteps);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ResourceMapping(value="fieldSearch")
    public void getFields(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="defaultVars", required=false) Boolean defaultVars) throws PortletException {
        ArrayList<Object> listeVar = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)filter)) {
            boolean exactMatch = false;
            for (Map.Entry entryVar : form.getProcedureModel().getVariables().entrySet()) {
                if (StringUtils.equalsIgnoreCase((String)((Variable)entryVar.getValue()).getName(), (String)filter)) {
                    listeVar.add(0, entryVar.getValue());
                    exactMatch = true;
                    continue;
                }
                if (!StringUtils.containsIgnoreCase((String)((Variable)entryVar.getValue()).getName(), (String)filter) && !StringUtils.containsIgnoreCase((String)((Variable)entryVar.getValue()).getLabel(), (String)filter)) continue;
                listeVar.add(entryVar.getValue());
            }
            if (!exactMatch && BooleanUtils.isNotTrue((Boolean)defaultVars)) {
                listeVar.add(0, new Variable(StringUtils.deleteWhitespace((String)filter), null, VariableTypesEnum.TEXT, null));
            }
        } else {
            listeVar.addAll(form.getProcedureModel().getVariables().values());
            if (StringUtils.equals((String)form.getProcedureModel().getProcedureType(), (String)DocumentTypeEnum.RECORDFOLDER.getDocType()) && BooleanUtils.isTrue((Boolean)defaultVars)) {
                listeVar.add(Variable.DC_CREATOR);
                listeVar.add(Variable.DC_CREATED);
                listeVar.add(Variable.DC_LAST_CONTRIBUTOR);
                listeVar.add(Variable.DC_MODIFIED);
            }
        }
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, null));
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            simpleModule.addSerializer(VariableTypesEnum.class, (JsonSerializer)new VariableTypesEnumJsonSerializer(bundle));
            mapper.registerModule((Module)simpleModule);
            mapper.writeValue(response.getPortletOutputStream(), listeVar);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ResourceMapping(value="modelSearch")
    public void getModels(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="filter", required=false) String filter) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        ArrayList listeProcedures = new ArrayList();
        List procedureModels = this.procedureService.retrieveProcedureModels(nuxeoController, this.getProcedurePath((PortletRequest)request), filter);
        for (ProcedureModel procedureModel : procedureModels) {
            HashMap<String, String> procedure = new HashMap<String, String>(2);
            procedure.put("id", procedureModel.getCurrentWebId());
            procedure.put("text", procedureModel.getName());
            listeProcedures.add(procedure);
        }
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), listeProcedures);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ResourceMapping(value="vocabularySearch")
    public void getVocabulary(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="vocabularyName", required=true) String vocabularyName) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        nuxeoController.setCacheTimeOut(TimeUnit.HOURS.toMillis(1L));
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        try {
            JSONArray values = this.procedureService.getVocabularyValues(nuxeoController, filter, vocabularyName);
            PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
            printWriter.write(values.toString());
            printWriter.close();
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
        catch (PortletException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ResourceMapping(value="formulaireSearch")
    public void getFormulaire(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        List results = this.procedureService.retrieveStepsByName(nuxeoController, filter);
        response.setContentType("application/json");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(response.getPortletOutputStream(), (Object)results);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ActionMapping(value="editProcedure", params={"changeMode"})
    public void changeModeProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        form.setAdvancedMode(!form.isAdvancedMode());
        response.setRenderParameter("action", CREATE_VIEW);
    }

    @ActionMapping(value="editStep", params={"changeMode"})
    public void changeModeStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        form.setAdvancedMode(!form.isAdvancedMode());
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="actionProcedure", params={"proceedProcedure"})
    public void proceedProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="actionId") String actionId, SessionStatus sessionStatus) throws PortletException {
        if (request instanceof MultipartActionRequest) {
            MultipartActionRequest multipartActionRequest = (MultipartActionRequest)request;
            for (Field field : form.getTheCurrentStep().getFields()) {
                this.setMultipartFile(field, multipartActionRequest, form);
            }
        }
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            PropertyMap taskProperties;
            PortalControllerContext portalControllerContext;
            Map globalVariablesValues = form.getProcedureInstance().getGlobalVariablesValues();
            if (StringUtils.isNotEmpty((String)this.getWebId((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.PROCEDUREMODEL.getDocType())) {
                portalControllerContext = nuxeoController.getPortalCtx();
                String currentWebId = form.getProcedureModel().getCurrentWebId();
                globalVariablesValues = nuxeoController.getNuxeoCMSService().getFormsService().start(portalControllerContext, currentWebId, actionId, globalVariablesValues);
                this.manageEndStep(nuxeoController, globalVariablesValues, form, sessionStatus);
            } else if (StringUtils.isNotEmpty((String)this.getWebId((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.PROCEDUREINSTANCE.getDocType())) {
                taskProperties = form.getProcedureInstance().getTaskDoc();
                PortalControllerContext portalControllerContext2 = nuxeoController.getPortalCtx();
                globalVariablesValues = nuxeoController.getNuxeoCMSService().getFormsService().proceed(portalControllerContext2, taskProperties, actionId, globalVariablesValues);
                this.manageEndStep(nuxeoController, globalVariablesValues, form, sessionStatus);
            } else if (StringUtils.isNotEmpty((String)this.getId((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.TASKDOC.getDocType())) {
                taskProperties = form.getProcedureInstance().getTaskDoc();
                PortalControllerContext portalControllerContext3 = nuxeoController.getPortalCtx();
                globalVariablesValues = nuxeoController.getNuxeoCMSService().getFormsService().proceed(portalControllerContext3, taskProperties, actionId, globalVariablesValues);
                this.manageEndStep(nuxeoController, globalVariablesValues, form, sessionStatus);
            } else if (StringUtils.isNotEmpty((String)this.getWebId((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.RECORDFOLDER.getDocType())) {
                portalControllerContext = nuxeoController.getPortalCtx();
                String currentWebId = form.getProcedureModel().getCurrentWebId();
                globalVariablesValues = nuxeoController.getNuxeoCMSService().getFormsService().start(portalControllerContext, currentWebId, actionId, globalVariablesValues);
                this.manageEndStep(nuxeoController, globalVariablesValues, form, sessionStatus);
            } else if (StringUtils.isNotEmpty((String)this.getWebId((PortletRequest)request)) && StringUtils.equals((String)this.getDocType((PortletRequest)request), (String)DocumentTypeEnum.RECORD.getDocType())) {
                portalControllerContext = nuxeoController.getPortalCtx();
                String currentWebId = form.getProcedureModel().getCurrentWebId();
                globalVariablesValues = nuxeoController.getNuxeoCMSService().getFormsService().start(portalControllerContext, currentWebId, actionId, globalVariablesValues);
                this.manageEndStep(nuxeoController, globalVariablesValues, form, sessionStatus);
            } else {
                response.setRenderParameter("action", VIEW_PROCEDURE);
            }
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        catch (FormFilterException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), e.getMessage(), NotificationsType.ERROR);
            request.setAttribute("filterMessage", (Object)e.getMessage());
            response.setRenderParameter("action", VIEW_PROCEDURE);
        }
    }

    private void manageEndStep(NuxeoController nuxeoController, Map<String, String> globalVariablesValues, Form form, SessionStatus sessionStatus) throws PortletException {
        ActionResponse response = (ActionResponse)nuxeoController.getResponse();
        String cmsPath = globalVariablesValues.get("_redirectCmsPath");
        String displayContext = globalVariablesValues.get("_displayContext");
        if (StringUtils.isNotBlank((String)cmsPath)) {
            String notificationMessage;
            String redirectUrl = nuxeoController.getPortalUrlFactory().getCMSUrl(nuxeoController.getPortalCtx(), null, cmsPath, new HashMap(), null, displayContext, nuxeoController.getHideMetaDatas(), nuxeoController.getScope(), nuxeoController.getDisplayLiveVersion(), null);
            try {
                response.sendRedirect(redirectUrl);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
            String string = notificationMessage = StringUtils.isNotBlank((String)globalVariablesValues.get("_notificationMessage")) ? globalVariablesValues.get("_notificationMessage") : form.getTheCurrentStep().getStringMsg();
            if (StringUtils.isNotBlank((String)notificationMessage)) {
                this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), notificationMessage, NotificationsType.SUCCESS);
            }
            sessionStatus.setComplete();
        } else {
            response.setRenderParameter("action", VIEW_ENDSTEP);
            sessionStatus.setComplete();
        }
    }

    @ActionMapping(value="editProcedure", params={"saveProcedure"})
    public void saveProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            if (StringUtils.isNotBlank((String)form.getProcedureModel().getName())) {
                String webId = this.getWebId((PortletRequest)request);
                if (StringUtils.isNotEmpty((String)webId)) {
                    this.addAllFieldsToSet(form);
                    this.addAllFiltersToSet(form);
                    this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
                } else {
                    this.procedureService.createProcedure(nuxeoController, form.getProcedureModel(), this.getProcedurePath((PortletRequest)request));
                }
                String redirectUrl = nuxeoController.getPortalUrlFactory().getBackURL(nuxeoController.getPortalCtx(), false);
                response.sendRedirect(redirectUrl);
                sessionStatus.setComplete();
            }
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="editProcedure", params={"deleteProcedure"})
    public void deleteProcedure(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.procedureService.deleteProcedure(nuxeoController, form.getProcedureModel());
        String redirectUrl = this.getPortalUrlFactory().getBackURL(nuxeoController.getPortalCtx(), false);
        try {
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editProcedure", params={"addStep"})
    public void addStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        Integer newIndex = form.getProcedureModel().getSteps().size();
        String path = this.getWebId((PortletRequest)request);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        try {
            if (StringUtils.isNotEmpty((String)path)) {
                form.getProcedureModel().getSteps().add(new Step(newIndex));
                form.setSelectedStep(String.valueOf(newIndex));
                this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
                response.setRenderParameter("action", EDIT_VIEW);
            } else {
                form.getProcedureModel().getSteps().add(new Step(newIndex));
                ProcedureModel createdProcedure = this.procedureService.createProcedure(nuxeoController, form.getProcedureModel(), this.getProcedurePath((PortletRequest)request));
                String redirectUrl = nuxeoController.getLink(createdProcedure.getOriginalDocument(), "adminprocstep").getUrl();
                response.sendRedirect(redirectUrl);
            }
            sessionStatus.setComplete();
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="editProcedure", params={"addTdb"})
    public void addTdb(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        this.addDashboard(request, response, form);
    }

    private void addDashboard(ActionRequest request, ActionResponse response, Form form) throws PortletException {
        String path = this.getWebId((PortletRequest)request);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        try {
            Dashboard newDashboard = new Dashboard();
            newDashboard.setName(this.bundleFactory.getBundle(request.getLocale()).getString("PROCEDURE_DASHBOARD"));
            if (StringUtils.isNotEmpty((String)path)) {
                form.getProcedureModel().getDashboards().add(newDashboard);
                form.setSelectedTdb(String.valueOf(form.getProcedureModel().getDashboards().size() - 1));
                this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
                response.setRenderParameter("action", EDIT_TDB);
            } else {
                form.getProcedureModel().getDashboards().add(newDashboard);
                ProcedureModel createdProcedure = this.procedureService.createProcedure(nuxeoController, form.getProcedureModel(), this.getProcedurePath((PortletRequest)request));
                String redirectUrl = nuxeoController.getLink(createdProcedure.getOriginalDocument(), "adminprocstep").getUrl();
                response.sendRedirect(redirectUrl);
            }
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="editRecord", params={"addColumn"})
    public void addColumnEditRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        form.getTheSelectedTdb().getColumns().add(form.getNewColumn());
        form.setNewColumn(new Column());
        response.setRenderParameter("action", EDIT_RECORD_VIEW);
        response.setRenderParameter("activeTab", "dashboard");
    }

    @ActionMapping(value="editTdb", params={"addColumn"})
    public void addColumn(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        form.getTheSelectedTdb().getColumns().add(form.getNewColumn());
        form.setNewColumn(new Column());
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editTdb", params={"addExportVar"})
    public void addExportVar(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        form.getTheSelectedTdb().getExportVarList().add(form.getNewExportVar());
        form.setNewExportVar(null);
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editProcedure", params={"manageVariables"})
    public void manageVariables(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        for (Step step : form.getProcedureModel().getSteps()) {
            for (Field field : step.getFields()) {
                Variable variable = (Variable)form.getProcedureModel().getVariables().get(field.getName());
                if (variable == null) continue;
                ArrayList<Field> usedInFields = (ArrayList<Field>)variable.getUsedInFields().get(step.getStepName());
                if (usedInFields == null) {
                    usedInFields = new ArrayList<Field>();
                }
                usedInFields.add(field);
                variable.getUsedInFields().put(step.getStepName(), usedInFields);
            }
        }
        response.setRenderParameter("action", MANAGE_VIEW);
    }

    @ActionMapping(value="manageVariables", params={"cancel"})
    public void cancel(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", CREATE_VIEW);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="manageVariables", params={"save"})
    public void save(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        this.updateStartingStep(form);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", CREATE_VIEW);
            sessionStatus.setComplete();
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="manageVariables", params={"deleteVariable"})
    public void deleteVariable(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedVar") String selectedVar) throws PortletException {
        form.getProcedureModel().getVariables().remove(selectedVar);
        response.setRenderParameter("action", MANAGE_VIEW);
    }

    @ActionMapping(value="manageVariables", params={"selectVariable"})
    public void selectVariable(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedVar", required=false) String selectedVar, SessionStatus sessionStatus) throws PortletException {
        Variable selectedVariable = (Variable)form.getProcedureModel().getVariables().get(selectedVar);
        form.setSelectedVariable(selectedVariable);
        response.setRenderParameter("action", MANAGE_VIEW);
    }

    @ActionMapping(value="manageVariables", params={"saveVariable"})
    public void saveVariable(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        Variable selectedVariable = form.getSelectedVariable();
        if (StringUtils.isNotBlank((String)selectedVariable.getName())) {
            form.getProcedureModel().getVariables().put(selectedVariable.getName(), selectedVariable);
            form.setSelectedVariable(null);
        }
        response.setRenderParameter("action", MANAGE_VIEW);
    }

    @ActionMapping(value="editProcedure", params={"addObject"})
    public void addObject(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        String path = this.getWebId((PortletRequest)request);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        try {
            if (StringUtils.isNotEmpty((String)path)) {
                form.getProcedureModel().getProcedureObjects().add(new ProcedureObject());
                this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
                response.setRenderParameter("action", CREATE_VIEW);
            } else {
                form.getProcedureModel().getProcedureObjects().add(new ProcedureObject());
                ProcedureModel createdProcedure = this.procedureService.createProcedure(nuxeoController, form.getProcedureModel(), this.getProcedurePath((PortletRequest)request));
                String redirectUrl = nuxeoController.getLink(createdProcedure.getOriginalDocument(), "adminproc").getUrl();
                response.sendRedirect(redirectUrl);
            }
            sessionStatus.setComplete();
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="editProcedure", params={"deleteObject"})
    public void deleteObject(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedObject", required=false) String selectedObject, SessionStatus sessionStatus) throws PortletException {
        form.getProcedureModel().getProcedureObjects().remove(Integer.valueOf(selectedObject));
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", CREATE_VIEW);
            sessionStatus.setComplete();
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    private String getWebId(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String webId = window.getProperty("osivia.services.procedure.webid");
        return webId;
    }

    private String getId(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String uuid = window.getProperty("osivia.services.procedure.uuid");
        return uuid;
    }

    private String getDocType(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String docType = window.getProperty("osivia.doctype");
        return docType;
    }

    private String getAction(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = window.getProperty("osivia.procedure.admin");
        return action;
    }

    private String getDashboardPath(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        return window.getPageProperty("osivia.procedure.dashboard.path");
    }

    private String getProcedurePath(PortletRequest request) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        return window.getProperty("osivia.services.procedure.procedurePath");
    }

    @ActionMapping(value="editProcedure", params={"editStep"})
    public void editStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="editProcedure", params={"editTdb"})
    public void editTdb(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editStep", params={"cancelStep"})
    public void cancelStep(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", CREATE_VIEW);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editTdb", params={"cancelTdb"})
    public void cancelTdb(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", request.getParameter("cancelTdb"));
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editStep", params={"saveStep"})
    public void saveStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        this.updateStartingStep(form);
        form.getProcedureModel().getSteps().set(form.getTheSelectedStep().getIndex(), form.getTheSelectedStep());
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", CREATE_VIEW);
            sessionStatus.setComplete();
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="editTdb", params={"saveTdb"})
    public void saveTdb(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            this.addAllFieldsToSet(form);
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", CREATE_VIEW);
            sessionStatus.setComplete();
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="editRecord", params={"saveRecord"})
    public void saveRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        if (StringUtils.isNotBlank((String)form.getProcedureModel().getName())) {
            this.addAllFieldsToSet(form);
            String webId = this.getWebId((PortletRequest)request);
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
            try {
                if (StringUtils.isNotEmpty((String)webId)) {
                    this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
                } else {
                    this.procedureService.createProcedure(nuxeoController, form.getProcedureModel(), this.getProcedurePath((PortletRequest)request));
                    String redirectUrl = nuxeoController.getPortalUrlFactory().getBackURL(nuxeoController.getPortalCtx(), false);
                    response.sendRedirect(redirectUrl);
                }
                sessionStatus.setComplete();
                Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
                this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), bundle.getString("MODEL_SAVED"), NotificationsType.SUCCESS);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
            catch (WebIdException e) {
                this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
            }
        }
    }

    private void addAllFiltersToSet(Form form) {
        for (Step step : form.getProcedureModel().getSteps()) {
            for (Action action : step.getActions()) {
                HashSet filtersList = new HashSet();
                this.addAllFiltersToSet(filtersList, action.getFilters());
                action.setFiltersList(filtersList);
            }
            HashSet filtersList = new HashSet();
            this.addAllFiltersToSet(filtersList, step.getInitAction().getFilters());
            step.getInitAction().setFiltersList(filtersList);
        }
    }

    private void addAllFiltersToSet(Set<Filter> filtersList, List<Filter> filters) {
        filtersList.addAll(filters);
        for (Filter filter : filters) {
            if (filter.getFilters() == null) continue;
            this.addAllFiltersToSet(filtersList, filter.getFilters());
        }
    }

    private void addAllFieldsToSet(Form form) {
        for (Step step : form.getProcedureModel().getSteps()) {
            HashSet fieldsSet = new HashSet();
            this.addAllFieldsToSet(fieldsSet, step.getFields());
            step.setFieldsSet(fieldsSet);
        }
    }

    private void addAllFieldsToSet(Set<Field> fieldsSet, List<Field> fields) {
        fieldsSet.addAll(fields);
        for (Field field : fields) {
            if (field.getFields() == null) continue;
            this.addAllFieldsToSet(fieldsSet, field.getFields());
        }
    }

    private void updateStartingStep(Form form) {
        if (!StringUtils.equals((String)form.getTheSelectedStep().getReference(), (String)form.getTheSelectedStep().getOldReference()) && StringUtils.equals((String)form.getProcedureModel().getStartingStep(), (String)form.getTheSelectedStep().getOldReference())) {
            form.getProcedureModel().setStartingStep(form.getTheSelectedStep().getReference());
        }
    }

    @ActionMapping(value="editStep", params={"deleteStep"})
    public void deleteStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        form.getProcedureModel().getSteps().remove(Integer.valueOf(form.getSelectedStep()));
        form.getProcedureModel().updateStepsIndexes();
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", CREATE_VIEW);
            sessionStatus.setComplete();
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="editProcedure", params={"deleteStep"})
    public void deleteStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedStep", required=false) String selectedStep, SessionStatus sessionStatus) throws PortletException {
        form.getProcedureModel().getSteps().remove(Integer.valueOf(selectedStep));
        form.getProcedureModel().updateStepsIndexes();
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", CREATE_VIEW);
            sessionStatus.setComplete();
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="editTdb", params={"deleteTdb"})
    public void deleteTdb(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        form.getProcedureModel().getDashboards().remove(Integer.valueOf(form.getSelectedTdb()));
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", CREATE_VIEW);
            sessionStatus.setComplete();
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="editTdb", params={"deleteCol"})
    public void deleteCol(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedCol", required=false) String selectedCol, SessionStatus sessionStatus) throws PortletException {
        form.getTheSelectedTdb().getColumns().remove(Integer.valueOf(selectedCol));
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editTdb", params={"deleteExportVar"})
    public void deleteExportVar(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedCol", required=false) String selectedCol, SessionStatus sessionStatus) throws PortletException {
        form.getTheSelectedTdb().getExportVarList().remove(Integer.valueOf(selectedCol));
        response.setRenderParameter("action", EDIT_TDB);
    }

    @ActionMapping(value="editRecord", params={"deleteCol"})
    public void deleteColEditRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedCol", required=false) String selectedCol, SessionStatus sessionStatus) throws PortletException {
        if (((Column)form.getTheSelectedTdb().getColumns().get(Integer.valueOf(selectedCol))).isDeletable()) {
            form.getTheSelectedTdb().getColumns().remove(Integer.valueOf(selectedCol));
        }
        response.setRenderParameter("action", EDIT_RECORD_VIEW);
        response.setRenderParameter("activeTab", "dashboard");
    }

    @ActionMapping(value="editProcedure", params={"deleteTdb"})
    public void deleteTdb(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedTdb", required=false) String selectedTdb, SessionStatus sessionStatus) throws PortletException {
        form.getProcedureModel().getDashboards().remove(Integer.valueOf(selectedTdb));
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", CREATE_VIEW);
            sessionStatus.setComplete();
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    private void editField(ActionResponse response, Form form, String action) {
        String[] path = form.getSelectedField().getPath().split(",");
        Field editedField = this.getFieldByPath(form.getTheSelectedStep().getFields(), path);
        if (editedField != null) {
            form.getProcedureModel().getVariables().put(editedField.getName(), new Variable(editedField));
        }
        form.setProcedureInstance(null);
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("activeFormTab", "edit");
        response.setRenderParameter("action", action);
    }

    @ActionMapping(value="editStep", params={"editField"})
    public void editFieldStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.editField(response, form, EDIT_VIEW);
    }

    @ActionMapping(value="editRecord", params={"editField"})
    public void editFieldList(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.editField(response, form, EDIT_RECORD_VIEW);
    }

    private Field getFieldByPath(List<Field> fields, String[] path) {
        Integer index = Integer.parseInt(path[0]);
        if (path.length == 1 && fields != null) {
            ListIterator<Field> listIterator = fields.listIterator();
            while (listIterator.hasNext()) {
                Field field = listIterator.next();
                String[] pathArray = StringUtils.split((String)field.getPath(), (char)',');
                if (pathArray.length <= 0 || Integer.parseInt(pathArray[pathArray.length - 1]) != index) continue;
                return field;
            }
        } else {
            Field nestedField = fields.get(index);
            path = (String[])ArrayUtils.remove((Object[])path, (int)0);
            return this.getFieldByPath(nestedField.getFields(), path);
        }
        return null;
    }

    private void addField(ActionRequest request, ActionResponse response, Form form, String action, Boolean forceInput) throws PortletException {
        AddField addField = form.getNewField();
        Map variables = form.getProcedureModel().getVariables();
        if (StringUtils.isBlank((String)addField.getVariableName())) {
            addField.setVariableName(this.buildUniqueVariableName(variables, addField.getLabel()));
        }
        Field field = new Field(form.getTheSelectedStep().getNextPath(), addField, false);
        variables.put(addField.getVariableName(), new Variable(addField));
        this.updateProcedureWithForm(request, response, form, field, action, forceInput);
    }

    private String buildUniqueVariableName(Map<String, Variable> variables, String label) throws PortletException {
        String cleanLabel;
        try {
            cleanLabel = URLEncoder.encode(StringUtils.deleteWhitespace((String)label), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PortletException((Throwable)e);
        }
        String uniqueVarName = cleanLabel;
        int i = 0;
        while (variables.containsKey(uniqueVarName)) {
            uniqueVarName = cleanLabel + i;
        }
        return uniqueVarName;
    }

    @ActionMapping(value="editStep", params={"addField"})
    public void addFieldInStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.addField(request, response, form, EDIT_VIEW, null);
    }

    @ActionMapping(value="editRecord", params={"addField"})
    public void addFieldInRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.addField(request, response, form, EDIT_RECORD_VIEW, Boolean.valueOf(true));
    }

    @ActionMapping(value="editStep", params={"addFieldSet"})
    public void addFieldSet(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        AddField newFieldSet = form.getNewFieldSet();
        Field field = new Field(form.getTheSelectedStep().getNextPath(), form.getNewFieldSet(), true);
        form.getProcedureModel().getVariables().put(newFieldSet.getVariableName(), new Variable(newFieldSet));
        this.updateProcedureWithForm(request, response, form, field, EDIT_VIEW);
    }

    private void updateProcedureWithForm(ActionRequest request, ActionResponse response, Form form, Field field, String action) throws PortletException {
        this.updateProcedureWithForm(request, response, form, field, action, null);
    }

    private void updateProcedureWithForm(ActionRequest request, ActionResponse response, Form form, Field field, String action, Boolean input) throws PortletException {
        field.setPath(String.valueOf(form.getTheSelectedStep().getFields().size()));
        if (BooleanUtils.isTrue((Boolean)input)) {
            field.setInput(true);
        }
        form.getTheSelectedStep().getFields().add(field);
        form.setNewField(new AddField());
        form.setNewFieldSet(new AddField());
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("action", action);
    }

    private void updateForm(ActionResponse response, Form form, String activeTab, String action) {
        HashMap allFieldsMap = new HashMap();
        if (form.getTheSelectedStep() != null) {
            this.addAllFields(allFieldsMap, form.getTheSelectedStep().getFields());
            this.rebuildStep(allFieldsMap, form.getTheSelectedStep());
        }
        if (form.getTheSelectedTdb() != null) {
            Collections.sort(form.getTheSelectedTdb().getColumns());
        }
        response.setRenderParameter("activeTab", activeTab);
        response.setRenderParameter("action", action);
    }

    @ActionMapping(value="editStep", params={"updateForm"})
    public void updateFormStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.updateForm(response, form, "form", EDIT_VIEW);
    }

    @ActionMapping(value="editRecord", params={"updateForm"})
    public void updateFormRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.updateForm(response, form, "form", EDIT_RECORD_VIEW);
    }

    @ActionMapping(value="editTdb", params={"updateDashboard"})
    public void updateDashboard(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="exportVarList", required=false) String exportVarList) throws PortletException {
        this.updateForm(response, form, "dashboard", EDIT_TDB);
        if (StringUtils.isNotBlank((String)exportVarList)) {
            form.getTheSelectedTdb().setExportVarList(Arrays.asList(StringUtils.split((String)exportVarList, (char)',')));
        }
    }

    private void rebuildStep(Map<String, List<Field>> allFieldsMap, Step step) {
        ArrayList<Field> baseFields = new ArrayList<Field>();
        List<Field> fieldList = allFieldsMap.get("");
        if (fieldList != null) {
            baseFields.addAll(fieldList);
            Collections.sort(baseFields);
        }
        this.rebuildFields(allFieldsMap, baseFields);
        step.setFields(baseFields);
    }

    private void rebuildFields(Map<String, List<Field>> allFieldsMap, List<Field> fields) {
        if (fields != null) {
            for (Field field : fields) {
                field.setFields(allFieldsMap.get(field.getPath()));
                this.rebuildFields(allFieldsMap, field.getFields());
            }
        }
    }

    private void addAllFields(Map<String, List<Field>> allFieldsMap, List<Field> fields) {
        if (fields != null) {
            for (Field field : fields) {
                if (field.getPath() == null) continue;
                String parentPath = StringUtils.split((String)field.getPath(), (char)',').length > 1 ? StringUtils.substringBeforeLast((String)field.getPath(), (String)",") : "";
                List<Field> parentFields = allFieldsMap.get(parentPath);
                if (parentFields == null) {
                    parentFields = new ArrayList<Field>();
                }
                parentFields.add(field);
                Collections.sort(parentFields);
                allFieldsMap.put(parentPath, parentFields);
                this.addAllFields(allFieldsMap, field.getFields());
            }
        }
    }

    @ActionMapping(value="editStep", params={"editButton"})
    public void editAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedButton") String index) throws PortletException {
        form.setSelectedAction(index);
        response.setRenderParameter("action", VIEW_ACTION);
    }

    @ActionMapping(value="editStep", params={"addButton"})
    public void addButton(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        form.getTheSelectedStep().getActions().add(new Action());
        response.setRenderParameter("activeTab", "action");
        response.setRenderParameter("action", EDIT_VIEW);
    }

    @ActionMapping(value="editStep", params={"deleteButton"})
    public void deleteButton(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedButton") String index) throws PortletException {
        form.getTheSelectedStep().getActions().remove(Integer.valueOf(index));
        response.setRenderParameter("activeTab", "action");
        response.setRenderParameter("action", EDIT_VIEW);
    }

    private void fillEditFieldTab(ActionResponse response, Form form, String selectedFieldPath, String action) {
        Field fieldByFieldPath = this.getFieldByFieldPath(form.getTheSelectedStep().getFields(), selectedFieldPath);
        form.setSelectedField(fieldByFieldPath);
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("activeFormTab", "edit");
        response.setRenderParameter("action", action);
    }

    @ActionMapping(value="editStep", params={"selectField"})
    public void fillEditFieldTabStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFieldPath") String selectedFieldPath) {
        this.fillEditFieldTab(response, form, selectedFieldPath, EDIT_VIEW);
    }

    @ActionMapping(value="editRecord", params={"selectField"})
    public void fillEditFieldTabList(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFieldPath") String selectedFieldPath) {
        this.fillEditFieldTab(response, form, selectedFieldPath, EDIT_RECORD_VIEW);
    }

    private Field getFieldByFieldPath(List<Field> fields, String selectedFieldPath) {
        Field returnField = null;
        if (fields != null) {
            for (Field field : fields) {
                Field fieldByPath;
                if (StringUtils.equals((String)field.getPath(), (String)selectedFieldPath)) {
                    returnField = field;
                }
                if ((fieldByPath = this.getFieldByFieldPath(field.getFields(), selectedFieldPath)) == null) continue;
                returnField = fieldByPath;
            }
        }
        return returnField;
    }

    @ActionMapping(value="editAction", params={"addFilter"})
    public void addFilter(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFilterId") String filterId) throws PortletException {
        int newPath;
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        Map formsFilters = nuxeoController.getNuxeoCMSService().getCMSCustomizer().getFormsFilters();
        FormFilter selectedFilter = (FormFilter)formsFilters.get(filterId);
        if (form.getTheSelectedAction().getFilters().isEmpty()) {
            newPath = 0;
        } else {
            String lastPath = ((Filter)form.getTheSelectedAction().getFilters().get(form.getTheSelectedAction().getFilters().size() - 1)).getFilterPath();
            newPath = Integer.parseInt(lastPath) + 1;
        }
        Filter newFilter = new Filter(selectedFilter, String.valueOf(newPath));
        form.getTheSelectedAction().getFilters().add(newFilter);
        response.setRenderParameter("action", VIEW_ACTION);
    }

    @ActionMapping(value="editAction", params={"deleteFilter"})
    public void deleteFilter(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        if (this.removeFilterByFilterPath(form.getTheSelectedAction().getFilters(), form.getSelectedFilter().getFilterPath())) {
            this.updateFiltersPath(form.getTheSelectedAction().getFilters(), "");
        }
        form.setSelectedFilter(null);
        response.setRenderParameter("action", VIEW_ACTION);
        response.setRenderParameter("activeTab", "");
    }

    @ActionMapping(value="editAction", params={"cancelAction"})
    public void cancelAction(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", EDIT_VIEW);
        response.setRenderParameter("activeTab", "action");
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editAction", params={"cancelAction=toStep"})
    public void cancelActionToEditStep(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", EDIT_VIEW);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editAction", params={"cancelAction=toProc"})
    public void cancelActionToEditProcedure(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", CREATE_VIEW);
        sessionStatus.setComplete();
    }

    @ActionMapping(value="editTdb", params={"cancelAction=toProc"})
    public void cancelEditTdbActionToEditProcedure(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) {
        response.setRenderParameter("action", CREATE_VIEW);
        sessionStatus.setComplete();
    }

    private void updateFiltersPath(List<Filter> filters, String currentPath) {
        if (filters != null) {
            for (int i = 0; i < filters.size(); ++i) {
                String newPath = currentPath.length() > 0 ? currentPath.concat(",").concat(String.valueOf(i)) : String.valueOf(i);
                filters.get(i).updateFilterPath(newPath);
                this.updateFiltersPath(filters.get(i).getFilters(), newPath);
            }
        }
    }

    private boolean removeFilterByFilterPath(List<Filter> filters, String filterPath) {
        if (filters != null) {
            ListIterator<Filter> filtersI = filters.listIterator();
            while (filtersI.hasNext()) {
                Filter filter = filtersI.next();
                if (StringUtils.equals((String)filter.getFilterPath(), (String)filterPath)) {
                    filtersI.remove();
                    return true;
                }
                if (!this.removeFilterByFilterPath(filter.getFilters(), filterPath)) continue;
                return true;
            }
        }
        return false;
    }

    @ActionMapping(value="editAction", params={"editFilter"})
    public void editFilter(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        this.updateFilterByFilterPath(form.getTheSelectedAction().getFilters(), form.getSelectedFilter());
        response.setRenderParameter("action", VIEW_ACTION);
        response.setRenderParameter("activeTab", "edit");
    }

    @ActionMapping(value="editAction", params={"selectFilter"})
    public void fillEditTab(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, @RequestParam(value="selectedFilterPath") String selectedFilterPath) {
        if (form.getSelectedFilter() != null && StringUtils.equals((String)form.getSelectedFilter().getFilterPath(), (String)selectedFilterPath)) {
            form.setSelectedFilter(null);
            response.setRenderParameter("activeTab", "");
        } else {
            Filter filterByFilterPath = this.getFilterByFilterPath(form.getTheSelectedAction().getFilters(), selectedFilterPath);
            form.setSelectedFilter(filterByFilterPath);
            response.setRenderParameter("activeTab", "edit");
        }
        response.setRenderParameter("action", VIEW_ACTION);
    }

    private Filter getFilterByFilterPath(List<Filter> filtersList, String selectedFilterPath) {
        Filter returnFilter = null;
        if (filtersList != null) {
            for (Filter filter : filtersList) {
                Filter filterbyId;
                if (StringUtils.equals((String)filter.getFilterPath(), (String)selectedFilterPath)) {
                    returnFilter = filter;
                }
                if ((filterbyId = this.getFilterByFilterPath(filter.getFilters(), selectedFilterPath)) == null) continue;
                returnFilter = filterbyId;
            }
        }
        return returnFilter;
    }

    private void updateFilterByFilterPath(List<Filter> filtersList, Filter filterUpdate) {
        if (filtersList != null) {
            for (Filter filter : filtersList) {
                if (StringUtils.equals((String)filter.getFilterPath(), (String)filterUpdate.getFilterPath())) {
                    filter.updateFilter(filterUpdate);
                    return;
                }
                this.updateFilterByFilterPath(filter.getFilters(), filterUpdate);
            }
        }
    }

    @ActionMapping(value="editAction", params={"saveAction"})
    public void saveAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        this.addAllFieldsToSet(form);
        this.addAllFiltersToSet(form);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        try {
            this.procedureService.updateProcedure(nuxeoController, form.getProcedureModel());
            response.setRenderParameter("action", EDIT_VIEW);
            response.setRenderParameter("activeTab", "action");
            sessionStatus.setComplete();
        }
        catch (WebIdException e) {
            this.getNotificationsService().addSimpleNotification(nuxeoController.getPortalCtx(), this.bundleFactory.getBundle(request.getLocale()).getString("WEBID_ERROR"), NotificationsType.ERROR);
        }
    }

    @ActionMapping(value="editAction", params={"updateForm"})
    public void updateFormAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        HashMap allFiltersMap = new HashMap();
        this.addAllFilters(allFiltersMap, form.getTheSelectedAction().getFilters());
        this.rebuildAction(allFiltersMap, form.getTheSelectedAction());
        form.setSelectedFilter(null);
        response.setRenderParameter("action", VIEW_ACTION);
    }

    private void addAllFilters(Map<String, List<Filter>> allFiltersMap, List<Filter> filters) {
        if (filters != null) {
            for (Filter filter : filters) {
                if (filter.getFilterPath() == null) continue;
                String parentPath = filter.getFilterPath().length() > 1 ? StringUtils.substringBeforeLast((String)filter.getFilterPath(), (String)",") : "";
                List<Filter> parentFilters = allFiltersMap.get(parentPath);
                if (parentFilters == null) {
                    parentFilters = new ArrayList<Filter>();
                }
                filter.setFilterInstanceId(filter.getFilterId().concat(filter.getFilterPath()));
                parentFilters.add(filter);
                Collections.sort(parentFilters);
                allFiltersMap.put(parentPath, parentFilters);
                this.addAllFilters(allFiltersMap, filter.getFilters());
            }
        }
    }

    private void rebuildAction(Map<String, List<Filter>> allFiltersMap, Action action) {
        ArrayList<Filter> baseFilters = new ArrayList<Filter>();
        List<Filter> filtersList = allFiltersMap.get("");
        if (filtersList != null) {
            baseFilters.addAll(filtersList);
            Collections.sort(baseFilters);
        }
        this.rebuildFilters(allFiltersMap, baseFilters);
        action.setFilters(baseFilters);
    }

    private void rebuildFilters(Map<String, List<Filter>> allFiltersMap, List<Filter> baseFilters) {
        if (baseFilters != null) {
            for (Filter filter : baseFilters) {
                filter.setFilters(allFiltersMap.get(filter.getFilterPath()));
                this.rebuildFilters(allFiltersMap, filter.getFilters());
            }
        }
    }

    private void deleteField(ActionResponse response, Form form, String action) {
        if (form.getSelectedField().isDeletable()) {
            if (this.removeFieldsByFieldPath(form.getTheSelectedStep().getFields(), form.getSelectedField().getPath())) {
                this.updateFieldsPath(form.getTheSelectedStep().getFields(), "");
            }
            form.setSelectedField(null);
        }
        response.setRenderParameter("activeTab", "form");
        response.setRenderParameter("activeFormTab", "");
        response.setRenderParameter("action", action);
    }

    @ActionMapping(value="editStep", params={"deleteField"})
    public void deleteFieldStep(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.deleteField(response, form, EDIT_VIEW);
    }

    @ActionMapping(value="editRecord", params={"deleteField"})
    public void deleteFieldList(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) throws PortletException {
        this.deleteField(response, form, EDIT_RECORD_VIEW);
    }

    @ActionMapping(value="editRecord", params={"deleteRecord"})
    public void deleteRecord(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form, SessionStatus sessionStatus) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.procedureService.deleteProcedure(nuxeoController, form.getProcedureModel());
        String redirectUrl = this.getPortalUrlFactory().getBackURL(nuxeoController.getPortalCtx(), false);
        try {
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
        sessionStatus.setComplete();
    }

    private void updateFieldsPath(List<Field> list, String currentPath) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String newPath = currentPath.length() > 0 ? currentPath.concat(",").concat(String.valueOf(i)) : String.valueOf(i);
                list.get(i).setPath(newPath);
                this.updateFieldsPath(list.get(i).getFields(), newPath);
            }
        }
    }

    private boolean removeFieldsByFieldPath(List<Field> list, String fieldPath) {
        if (list != null) {
            ListIterator<Field> filtersI = list.listIterator();
            while (filtersI.hasNext()) {
                Field field = filtersI.next();
                if (StringUtils.equals((String)field.getPath(), (String)fieldPath)) {
                    filtersI.remove();
                    return true;
                }
                if (!this.removeFieldsByFieldPath(field.getFields(), fieldPath)) continue;
                return true;
            }
        }
        return false;
    }

    private void setMultipartFile(Field field, MultipartActionRequest multipartActionRequest, Form form) {
        if (!field.isFieldSet()) {
            MultipartFile multipartFile;
            if (field.isInput() && (multipartFile = (MultipartFile)multipartActionRequest.getFileMap().get("file:" + field.getName())) != null && multipartFile.getSize() > 0L) {
                FilePath filePath = new FilePath();
                filePath.setFile(multipartFile);
                filePath.setVariableName(field.getName());
                filePath.setFileName(String.valueOf(multipartFile.getOriginalFilename()));
                form.getProcedureInstance().getFilesPath().put(filePath.getVariableName(), filePath);
            }
        } else {
            for (Field nestedField : field.getFields()) {
                this.setMultipartFile(nestedField, multipartActionRequest, form);
            }
        }
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}

