/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.model;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.procedure.portlet.command.RetrieveDocumentByWebIdCommand;
import org.osivia.services.procedure.portlet.model.Dashboard;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.ProcedureObject;
import org.osivia.services.procedure.portlet.model.Step;
import org.osivia.services.procedure.portlet.model.Variable;
import org.osivia.services.procedure.portlet.model.VariableTypesEnum;

public class ProcedureModel {
    private String name;
    private String description;
    private Map<String, Variable> variables = new HashMap();
    private List<Step> steps = new ArrayList();
    private List<ProcedureObject> procedureObjects = new ArrayList();
    private List<Dashboard> dashboards;
    private String startingStep;
    private String path;
    private String url;
    private String currentWebId;
    private String newWebId;
    private String webIdParent;
    private String procedureType;
    private Document originalDocument;
    private ProcedureModel ProcedureParent;

    public ProcedureModel() {
    }

    public ProcedureModel(Document document, NuxeoController nuxeoController) {
        PropertyList procedureDashboardsList;
        PropertyList procedureObjectsList;
        PropertyList stepsList;
        this.setOriginalDocument(document);
        PropertyMap properties = document.getProperties();
        this.name = properties.getString("dc:title");
        this.currentWebId = properties.getString("ttc:webid");
        this.newWebId = StringUtils.startsWith((String)this.currentWebId, (String)"procedure_") ? StringUtils.removeStart((String)this.currentWebId, (String)"procedure_") : null;
        this.path = document.getPath();
        this.startingStep = properties.getString("pcd:startingStep");
        this.procedureType = document.getType();
        this.webIdParent = properties.getString("pcd:webIdParent");
        PropertyList globalVariablesList = properties.getList("pcd:globalVariablesDefinitions");
        if (globalVariablesList != null) {
            for (Object globalVariableO : globalVariablesList.list()) {
                PropertyMap globalVariable = (PropertyMap)globalVariableO;
                Object varOptionsO = globalVariable.get("varOptions");
                String varOptions = null;
                if (varOptionsO != null && varOptionsO.getClass() == String.class) {
                    varOptions = varOptionsO.toString();
                }
                Variable var = new Variable(globalVariable.getString("name"), globalVariable.getString("label"), VariableTypesEnum.valueOf((String)StringUtils.defaultIfBlank((String)globalVariable.getString("type"), (String)VariableTypesEnum.TEXT.name())), varOptions);
                this.getVariables().put(var.getName(), var);
            }
        }
        if ((stepsList = properties.getList("pcd:steps")) != null) {
            for (Object stepO : stepsList.list()) {
                PropertyMap stepM = (PropertyMap)stepO;
                Step step = new Step(stepM, this.getVariables(), nuxeoController);
                this.getSteps().add(step);
            }
            Collections.sort(this.getSteps());
        }
        if ((procedureObjectsList = properties.getList("pcd:procedureObjects")) != null) {
            for (Object procedureObject : procedureObjectsList.list()) {
                PropertyMap procedureObjectMap = (PropertyMap)procedureObject;
                ProcedureObject newProcedureObject = new ProcedureObject(procedureObjectMap);
                this.procedureObjects.add(newProcedureObject);
            }
        }
        if ((procedureDashboardsList = properties.getList("pcd:dashboards")) != null) {
            for (Object dashboardObject : procedureDashboardsList.list()) {
                PropertyMap dashboardObjectMap = (PropertyMap)dashboardObject;
                Dashboard dashboard = new Dashboard(dashboardObjectMap);
                this.getDashboards().add(dashboard);
            }
        }
        if (StringUtils.isNotBlank((String)this.getWebIdParent())) {
            RetrieveDocumentByWebIdCommand command = new RetrieveDocumentByWebIdCommand(this.getWebIdParent());
            Document documentParent = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            ProcedureModel procedureParent = new ProcedureModel(documentParent, nuxeoController);
            this.setProcedureParent(procedureParent);
        }
    }

    public void updateStepsIndexes() {
        Collections.sort(this.getSteps());
        for (int i = 0; i < this.getSteps().size(); ++i) {
            ((Step)this.getSteps().get(i)).setIndex(Integer.valueOf(i));
        }
    }

    public Map<String, Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Variable> variables) {
        this.variables = variables;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getStartingStep() {
        return this.startingStep;
    }

    public void setStartingStep(String startingStep) {
        this.startingStep = startingStep;
    }

    public List<ProcedureObject> getProcedureObjects() {
        return this.procedureObjects;
    }

    public ProcedureObject getProcedureObject(String objectName) {
        for (ProcedureObject procedureObject : this.procedureObjects) {
            if (!StringUtils.equals((String)procedureObject.getName(), (String)objectName)) continue;
            return procedureObject;
        }
        return null;
    }

    public void setProcedureObjects(List<ProcedureObject> procedureObjects) {
        this.procedureObjects = procedureObjects;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Document getOriginalDocument() {
        return this.originalDocument;
    }

    public void setOriginalDocument(Document originalDocument) {
        this.originalDocument = originalDocument;
    }

    public String getCurrentWebId() {
        return this.currentWebId;
    }

    public void setCurrentWebId(String currentWebId) {
        this.currentWebId = currentWebId;
    }

    public String getNewWebId() {
        return this.newWebId;
    }

    public void setNewWebId(String newWebId) {
        this.newWebId = newWebId;
    }

    public String getProcedureType() {
        return this.procedureType;
    }

    public void setProcedureType(String procedureType) {
        this.procedureType = procedureType;
    }

    public String getWebIdParent() {
        return this.webIdParent;
    }

    public void setWebIdParent(String webIdParent) {
        this.webIdParent = webIdParent;
    }

    public List<Dashboard> getDashboards() {
        if (this.dashboards == null) {
            this.dashboards = new ArrayList();
        }
        return this.dashboards;
    }

    public void setDashboards(List<Dashboard> dashboards) {
        this.dashboards = dashboards;
    }

    public ProcedureModel getProcedureParent() {
        return this.ProcedureParent;
    }

    public void setProcedureParent(ProcedureModel procedureParent) {
        this.ProcedureParent = procedureParent;
    }

    public void updateVariables() {
        if (StringUtils.equals((String)DocumentTypeEnum.RECORDFOLDER.getDocType(), (String)this.getProcedureType())) {
            HashMap variablesU = new HashMap();
            for (Step step : this.steps) {
                for (Field field : step.getFieldsSet()) {
                    variablesU.put(field.getName(), this.getVariables().get(field.getName()));
                }
            }
            this.setVariables(variablesU);
        }
    }
}

